; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt %s -mtriple=arm64-apple-macosx -passes=inline -inline-threshold=2 -inline-call-penalty=5 -S | FileCheck %s

declare i64 @llvm.objectsize.i64.p0(ptr, i1, i1, i1)
declare ptr @__memcpy_chk(ptr, ptr, i64, i64)
declare ptr @__memmove_chk(ptr, ptr, i64, i64)
declare ptr @__mempcpy_chk(ptr, ptr, i64, i64)
declare ptr @__memset_chk(ptr, i32, i64, i64)

define void @callee(ptr %dst, ptr %src, i64 %size) {
; CHECK-LABEL: define void @callee
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]], i64 [[SIZE:%.*]]) {
; CHECK-NEXT:    [[OBJSIZE:%.*]] = call i64 @llvm.objectsize.i64.p0(ptr [[DST]], i1 false, i1 true, i1 false)
; CHECK-NEXT:    [[CALL_MEMCPY:%.*]] = call ptr @__memcpy_chk(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i64 [[OBJSIZE]])
; CHECK-NEXT:    [[CALL_MEMMOVE:%.*]] = call ptr @__memmove_chk(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i64 [[OBJSIZE]])
; CHECK-NEXT:    [[CALL_MEMPCPY:%.*]] = call ptr @__mempcpy_chk(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i64 [[OBJSIZE]])
; CHECK-NEXT:    [[CALL_MEMSET:%.*]] = call ptr @__memset_chk(ptr [[DST]], i32 0, i64 [[SIZE]], i64 [[OBJSIZE]])
; CHECK-NEXT:    ret void
;
  %objsize = call i64 @llvm.objectsize.i64.p0(ptr %dst, i1 false, i1 true, i1 false)
  %call.memcpy = call ptr @__memcpy_chk(ptr %dst, ptr %src, i64 %size, i64 %objsize)
  %call.memmove = call ptr @__memmove_chk(ptr %dst, ptr %src, i64 %size, i64 %objsize)
  %call.mempcpy = call ptr @__mempcpy_chk(ptr %dst, ptr %src, i64 %size, i64 %objsize)
  %call.memset = call ptr @__memset_chk(ptr %dst, i32 0, i64 %size, i64 %objsize)
  ret void
}

define void @caller(ptr %dst, ptr %src) {
; CHECK-LABEL: define void @caller
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]]) {
; CHECK-NEXT:    [[OBJSIZE_I:%.*]] = call i64 @llvm.objectsize.i64.p0(ptr [[DST]], i1 false, i1 true, i1 false)
; CHECK-NEXT:    [[CALL_MEMCPY_I:%.*]] = call ptr @__memcpy_chk(ptr [[DST]], ptr [[SRC]], i64 4, i64 [[OBJSIZE_I]])
; CHECK-NEXT:    [[CALL_MEMMOVE_I:%.*]] = call ptr @__memmove_chk(ptr [[DST]], ptr [[SRC]], i64 4, i64 [[OBJSIZE_I]])
; CHECK-NEXT:    [[CALL_MEMPCPY_I:%.*]] = call ptr @__mempcpy_chk(ptr [[DST]], ptr [[SRC]], i64 4, i64 [[OBJSIZE_I]])
; CHECK-NEXT:    [[CALL_MEMSET_I:%.*]] = call ptr @__memset_chk(ptr [[DST]], i32 0, i64 4, i64 [[OBJSIZE_I]])
; CHECK-NEXT:    ret void
;
  call void @callee(ptr %dst, ptr %src, i64 4)
  ret void
}

define void @objsize_toosmall_callee(ptr %dst, ptr %src, i64 %size) {
; CHECK-LABEL: define void @objsize_toosmall_callee
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]], i64 [[SIZE:%.*]]) {
; CHECK-NEXT:    [[CALL_MEMCPY:%.*]] = call ptr @__memcpy_chk(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i64 1)
; CHECK-NEXT:    [[CALL_MEMMOVE:%.*]] = call ptr @__memmove_chk(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i64 1)
; CHECK-NEXT:    [[CALL_MEMPCPY:%.*]] = call ptr @__mempcpy_chk(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i64 1)
; CHECK-NEXT:    [[CALL_MEMSET:%.*]] = call ptr @__memset_chk(ptr [[DST]], i32 0, i64 [[SIZE]], i64 1)
; CHECK-NEXT:    ret void
;
  %call.memcpy = call ptr @__memcpy_chk(ptr %dst, ptr %src, i64 %size, i64 1)
  %call.memmove = call ptr @__memmove_chk(ptr %dst, ptr %src, i64 %size, i64 1)
  %call.mempcpy = call ptr @__mempcpy_chk(ptr %dst, ptr %src, i64 %size, i64 1)
  %call.memset = call ptr @__memset_chk(ptr %dst, i32 0, i64 %size, i64 1)
  ret void
}

define void @objsize_toosmall_caller(ptr %dst, ptr %src) {
; CHECK-LABEL: define void @objsize_toosmall_caller
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]]) {
; CHECK-NEXT:    call void @objsize_toosmall_callee(ptr [[DST]], ptr [[SRC]], i64 4)
; CHECK-NEXT:    ret void
;
  call void @objsize_toosmall_callee(ptr %dst, ptr %src, i64 4)
  ret void
}

define void @intrinsics_callee(ptr %dst, ptr %src, i64 %size) {
; CHECK-LABEL: define void @intrinsics_callee
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]], i64 [[SIZE:%.*]]) {
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i1 false)
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i64(ptr [[DST]], ptr [[SRC]], i64 [[SIZE]], i1 false)
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr [[DST]], i8 0, i64 [[SIZE]], i1 false)
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.p0.i64(ptr %dst, ptr %src, i64 %size, i1 false)
  call void @llvm.memmove.p0.p0.i64(ptr %dst, ptr %src, i64 %size, i1 false)
  call void @llvm.memset.p0.i64(ptr %dst, i8 0, i64 %size, i1 false)
  ret void
}

define void @intrinsics_caller(ptr %dst, ptr %src) {
; CHECK-LABEL: define void @intrinsics_caller
; CHECK-SAME: (ptr [[DST:%.*]], ptr [[SRC:%.*]]) {
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[DST]], ptr [[SRC]], i64 4, i1 false)
; CHECK-NEXT:    call void @llvm.memmove.p0.p0.i64(ptr [[DST]], ptr [[SRC]], i64 4, i1 false)
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr [[DST]], i8 0, i64 4, i1 false)
; CHECK-NEXT:    ret void
;
  call void @intrinsics_callee(ptr %dst, ptr %src, i64 4)
  ret void
}
