; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-linux-gnu | FileCheck %s

define i32 @func(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: func:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umull x8, w0, w1
; CHECK-NEXT:    lsr x9, x8, #32
; CHECK-NEXT:    extr w8, w9, w8, #2
; CHECK-NEXT:    cmp w9, #3
; CHECK-NEXT:    csinv w0, w8, wzr, ls
; CHECK-NEXT:    ret
  %tmp = call i32 @llvm.umul.fix.sat.i32(i32 %x, i32 %y, i32 2)
  ret i32 %tmp
}

define i64 @func2(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: func2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x8, x0, x1
; CHECK-NEXT:    umulh x9, x0, x1
; CHECK-NEXT:    extr x8, x9, x8, #2
; CHECK-NEXT:    cmp x9, #3
; CHECK-NEXT:    csinv x0, x8, xzr, ls
; CHECK-NEXT:    ret
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 2)
  ret i64 %tmp
}

define i4 @func3(i4 %x, i4 %y) nounwind {
; CHECK-LABEL: func3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #28
; CHECK-NEXT:    and w9, w1, #0xf
; CHECK-NEXT:    umull x8, w8, w9
; CHECK-NEXT:    lsr x9, x8, #32
; CHECK-NEXT:    extr w8, w9, w8, #2
; CHECK-NEXT:    cmp w9, #3
; CHECK-NEXT:    csinv w8, w8, wzr, ls
; CHECK-NEXT:    lsr w0, w8, #28
; CHECK-NEXT:    ret
  %tmp = call i4 @llvm.umul.fix.sat.i4(i4 %x, i4 %y, i32 2)
  ret i4 %tmp
}

;; These result in regular integer multiplication with a saturation check.
define i32 @func4(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: func4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umull x8, w0, w1
; CHECK-NEXT:    tst x8, #0xffffffff00000000
; CHECK-NEXT:    csinv w0, w8, wzr, eq
; CHECK-NEXT:    ret
  %tmp = call i32 @llvm.umul.fix.sat.i32(i32 %x, i32 %y, i32 0)
  ret i32 %tmp
}

define i64 @func5(i64 %x, i64 %y) {
; CHECK-LABEL: func5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umulh x8, x0, x1
; CHECK-NEXT:    mul x9, x0, x1
; CHECK-NEXT:    cmp xzr, x8
; CHECK-NEXT:    csinv x0, x9, xzr, eq
; CHECK-NEXT:    ret
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 0)
  ret i64 %tmp
}

define i4 @func6(i4 %x, i4 %y) nounwind {
; CHECK-LABEL: func6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #28
; CHECK-NEXT:    and w9, w1, #0xf
; CHECK-NEXT:    umull x8, w8, w9
; CHECK-NEXT:    tst x8, #0xffffffff00000000
; CHECK-NEXT:    csinv w8, w8, wzr, eq
; CHECK-NEXT:    lsr w0, w8, #28
; CHECK-NEXT:    ret
  %tmp = call i4 @llvm.umul.fix.sat.i4(i4 %x, i4 %y, i32 0)
  ret i4 %tmp
}

define <2 x i32> @vec(<2 x i32> %x, <2 x i32> %y) nounwind {
; CHECK-LABEL: vec:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov w8, v1.s[1]
; CHECK-NEXT:    mov w9, v0.s[1]
; CHECK-NEXT:    fmov w10, s0
; CHECK-NEXT:    umull x8, w9, w8
; CHECK-NEXT:    fmov w9, s1
; CHECK-NEXT:    umull x9, w10, w9
; CHECK-NEXT:    tst x8, #0xffffffff00000000
; CHECK-NEXT:    csinv w8, w8, wzr, eq
; CHECK-NEXT:    tst x9, #0xffffffff00000000
; CHECK-NEXT:    csinv w9, w9, wzr, eq
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %tmp = call <2 x i32> @llvm.umul.fix.sat.v2i32(<2 x i32> %x, <2 x i32> %y, i32 0)
  ret <2 x i32> %tmp
}

define <4 x i32> @vec2(<4 x i32> %x, <4 x i32> %y) nounwind {
; CHECK-LABEL: vec2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, v1.s[1]
; CHECK-NEXT:    mov w9, v0.s[1]
; CHECK-NEXT:    fmov w10, s0
; CHECK-NEXT:    mov w11, v0.s[2]
; CHECK-NEXT:    mov w13, v0.s[3]
; CHECK-NEXT:    mov w12, v1.s[3]
; CHECK-NEXT:    umull x8, w9, w8
; CHECK-NEXT:    fmov w9, s1
; CHECK-NEXT:    umull x9, w10, w9
; CHECK-NEXT:    tst x8, #0xffffffff00000000
; CHECK-NEXT:    mov w10, v1.s[2]
; CHECK-NEXT:    csinv w8, w8, wzr, eq
; CHECK-NEXT:    tst x9, #0xffffffff00000000
; CHECK-NEXT:    csinv w9, w9, wzr, eq
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    umull x9, w11, w10
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    tst x9, #0xffffffff00000000
; CHECK-NEXT:    csinv w8, w9, wzr, eq
; CHECK-NEXT:    umull x9, w13, w12
; CHECK-NEXT:    mov v0.s[2], w8
; CHECK-NEXT:    tst x9, #0xffffffff00000000
; CHECK-NEXT:    csinv w8, w9, wzr, eq
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    ret
  %tmp = call <4 x i32> @llvm.umul.fix.sat.v4i32(<4 x i32> %x, <4 x i32> %y, i32 0)
  ret <4 x i32> %tmp
}

define <4 x i64> @vec3(<4 x i64> %x, <4 x i64> %y) nounwind {
; CHECK-LABEL: vec3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, v2.d[1]
; CHECK-NEXT:    mov x9, v0.d[1]
; CHECK-NEXT:    mov x14, v3.d[1]
; CHECK-NEXT:    mov x15, v1.d[1]
; CHECK-NEXT:    fmov x10, d2
; CHECK-NEXT:    fmov x11, d0
; CHECK-NEXT:    mul x12, x11, x10
; CHECK-NEXT:    mul x13, x9, x8
; CHECK-NEXT:    umulh x8, x9, x8
; CHECK-NEXT:    umulh x9, x11, x10
; CHECK-NEXT:    mul x10, x15, x14
; CHECK-NEXT:    extr x13, x8, x13, #32
; CHECK-NEXT:    umulh x11, x15, x14
; CHECK-NEXT:    fmov x14, d3
; CHECK-NEXT:    fmov x15, d1
; CHECK-NEXT:    mul x16, x15, x14
; CHECK-NEXT:    umulh x14, x15, x14
; CHECK-NEXT:    mov w15, #-1 // =0xffffffff
; CHECK-NEXT:    cmp x8, x15
; CHECK-NEXT:    extr x8, x9, x12, #32
; CHECK-NEXT:    csinv x12, x13, xzr, ls
; CHECK-NEXT:    cmp x9, x15
; CHECK-NEXT:    extr x9, x11, x10, #32
; CHECK-NEXT:    csinv x8, x8, xzr, ls
; CHECK-NEXT:    cmp x11, x15
; CHECK-NEXT:    csinv x9, x9, xzr, ls
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    extr x10, x14, x16, #32
; CHECK-NEXT:    cmp x14, x15
; CHECK-NEXT:    csinv x10, x10, xzr, ls
; CHECK-NEXT:    mov v0.d[1], x12
; CHECK-NEXT:    fmov d1, x10
; CHECK-NEXT:    mov v1.d[1], x9
; CHECK-NEXT:    ret
  %tmp = call <4 x i64> @llvm.umul.fix.sat.v4i64(<4 x i64> %x, <4 x i64> %y, i32 32)
  ret <4 x i64> %tmp
}

define i64 @func7(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: func7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x9, x0, x1
; CHECK-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-NEXT:    umulh x10, x0, x1
; CHECK-NEXT:    extr x9, x10, x9, #32
; CHECK-NEXT:    cmp x10, x8
; CHECK-NEXT:    csinv x0, x9, xzr, ls
; CHECK-NEXT:    ret
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 32)
  ret i64 %tmp
}

define i64 @func8(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: func8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul x9, x0, x1
; CHECK-NEXT:    mov x8, #9223372036854775807 // =0x7fffffffffffffff
; CHECK-NEXT:    umulh x10, x0, x1
; CHECK-NEXT:    extr x9, x10, x9, #63
; CHECK-NEXT:    cmp x10, x8
; CHECK-NEXT:    csinv x0, x9, xzr, ls
; CHECK-NEXT:    ret
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 63)
  ret i64 %tmp
}
