/*
 * Copyright (C) 2024 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This file is derived from https://github.com/Ji-Peng/PQRV which uses the
 * following license.
 *
 * The MIT license, the text of which is below, applies to PQRV in general.
 *
 * Copyright (c) 2024 - 2025 Jipeng Zhang (jp-zhang@outlook.com)
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "ext_headers_internal.h"
#include "kyber_ntt.h"
#include "kyber_poly_riscv.h"
#include "kyber_ntt_rv64im.h"

// RV64IM assembly optimized implementation with Plantard multiplication
LC_FIPS_RODATA_SECTION
const uint32_t kyber_zetas_basemul_rv64im[64] = {
	21932846,   3562152210, 752167598,  3417653460, 2112004045, 932791035,
	2951903026, 1419184148, 1817845876, 3434425636, 4233039261, 300609006,
	975366560,  2781600929, 3889854731, 3935010590, 2197155094, 2130066389,
	3598276897, 2308109491, 2382939200, 1228239371, 1884934581, 3466679822,
	1211467195, 2977706375, 3144137970, 3080919767, 945692709,  3015121229,
	345764865,  826997308,	2043625172, 2964804700, 2628071007, 4154339049,
	483812778,  3288636719, 2696449880, 2122325384, 1371447954, 411563403,
	3577634219, 976656727,	2708061387, 723783916,	3181552825, 3346694253,
	3617629408, 1408862808, 519937465,  1323711759, 1474661346, 2773859924,
	3580214553, 1143088323, 2221668274, 1563682897, 2417773720, 1327582262,
	2722253228, 3786641338, 1141798155, 2779020594
};

// 4+3 layer merging strategy with CT butterfly
LC_FIPS_RODATA_SECTION
static const uint32_t kyber_zetas_ntt_rv64im[128] = {
	2230699446, 3328631909, 4243360600, 3408622288, 812805467,  2447447570,
	1094061961, 1370157786, 2475831253, 249002310,	1028263423, 3594406395,
	4205945745, 734105255,	2252632292, 381889553,	372858381,  427045412,
	21932846,   3562152210, 752167598,  3417653460, 3157039644, 4196914574,
	2265533966, 2112004045, 932791035,  2951903026, 1419184148, 1727534158,
	1544330386, 2972545705, 1817845876, 3434425636, 4233039261, 300609006,
	1904287092, 2937711185, 2651294021, 975366560,	2781600929, 3889854731,
	3935010590, 3929849920, 838608815,  2550660963, 2197155094, 2130066389,
	3598276897, 2308109491, 72249375,   3242190693, 815385801,  2382939200,
	1228239371, 1884934581, 3466679822, 2889974991, 3696329620, 42575525,
	1211467195, 2977706375, 3144137970, 3080919767, 1719793153, 1703020977,
	2470670584, 945692709,	3015121229, 345764865,	826997308,  1839778722,
	2991898216, 1851390229, 2043625172, 2964804700, 2628071007, 4154339049,
	2701610550, 1041165097, 583155668,  483812778,	3288636719, 2696449880,
	2122325384, 690239563,	1855260731, 3700200122, 1371447954, 411563403,
	3577634219, 976656727,	3718262466, 1979116802, 3098982111, 2708061387,
	723783916,  3181552825, 3346694253, 3087370604, 3415073125, 3376368103,
	3617629408, 1408862808, 519937465,  1323711759, 3714391964, 1910737929,
	836028480,  1474661346, 2773859924, 3580214553, 1143088323, 2546790461,
	3191874164, 4012420634, 2221668274, 1563682897, 2417773720, 1327582262,
	1059227441, 1583035408, 1174052340, 2722253228, 3786641338, 1141798155,
	2779020594, 0
};

// 3+4 layer merging strategy with GS butterfly.
LC_FIPS_RODATA_SECTION
static const uint32_t kyber_zetas_intt_rv64im[128] = {
	1515946703, 3153169142, 508325959,  1572714069, 3120914957, 2711931889,
	3235739856, 2967385035, 1877193577, 2731284400, 2073299023, 282546663,
	1103093133, 1748176836, 3151878974, 714752744,	1521107373, 2820305951,
	3458938817, 2384229368, 580575333,  2971255538, 3775029832, 2886104489,
	677337889,  918599194,	879894172,  1207596693, 948273044,  1113414472,
	3571183381, 1586905910, 1195985186, 2315850495, 576704831,  3318310570,
	717333078,  3883403894, 2923519343, 594767175,	2439706566, 3604727734,
	2172641913, 1598517417, 1006330578, 3811154519, 3711811629, 3253802200,
	1593356747, 140628248,	1666896290, 1330162597, 2251342125, 2443577068,
	1303069081, 2455188575, 3467969989, 3949202432, 1279846068, 3349274588,
	1824296713, 2591946320, 2575174144, 1214047530, 1150829327, 1317260922,
	3083500102, 4252391772, 598637677,  1404992306, 828287475,  2410032716,
	3066727926, 1912028097, 3479581496, 1052776604, 4222717922, 1986857806,
	696690400,  2164900908, 2097812203, 1744306334, 3456358482, 365117377,
	359956707,  405112566,	1513366368, 3319600737, 1643673276, 1357256112,
	2390680205, 3994358291, 61928036,   860541661,	2477121421, 1322421592,
	2750636911, 2567433139, 2875783149, 1343064271, 3362176262, 2182963252,
	2029433331, 98052723,	1137927653, 877313837,	3542799699, 732815087,
	4273034451, 3867921885, 3922108916, 3913077744, 2042335005, 3560862042,
	89021552,   700560902,	3266703874, 4045964987, 1819136044, 2924809511,
	3200905336, 1847519727, 3482161830, 886345009,	51606697,   966335388,
	1802363867, 2435836064
};

void kyber_ntt(int16_t r[LC_KYBER_N])
{
	kyber_ntt_rv64im(r, kyber_zetas_ntt_rv64im);
}

void kyber_invntt(int16_t r[LC_KYBER_N])
{
	kyber_intt_rv64im(r, kyber_zetas_intt_rv64im);
}
