/*
 * Copyright (C) 2024 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This file is derived from https://github.com/Ji-Peng/PQRV which uses the
 * following license.
 *
 * The MIT license, the text of which is below, applies to PQRV in general.
 *
 * Copyright (c) 2024 - 2025 Jipeng Zhang (jp-zhang@outlook.com)
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "ntt_rvv_vlen256.h"

#define I16(l, h) (h << 8) | l

// clang-format off
const int16_t kyber_qdata_rvv_vlen256[] __attribute__((aligned(16))) = {
#define _MASK_0_7x2
    0,           1,           2,           3,           4,
    5,           6,           7,           0,           1,
    2,           3,           4,           5,           6,
    7,
#define _MASK_8_15x2
    8,           9,           10,          11,          12,
    13,          14,          15,          8,           9,
    10,          11,          12,          13,          14,
    15,
#define _MASK_0_3x2_8_11x2
    0,           1,           2,           3,           0,
    1,           2,           3,           8,           9,
    10,          11,          8,           9,           10,
    11,
#define _MASK_4_7x2_12_15x2
    4,           5,           6,           7,           4,
    5,           6,           7,           12,          13,
    14,          15,          12,          13,          14,
    15,
#define _MASK_01014545
    0,           1,           0,           1,           4,
    5,           4,           5,           8,           9,
    8,           9,           12,          13,          12,
    13,
#define _MASK_23236767
    2,           3,           2,           3,           6,
    7,           6,           7,           10,          11,
    10,          11,          14,          15,          14,
    15,
#define _MASK_10325476
    1,           0,           3,           2,           5,
    4,           7,           6,           9,           8,
    11,          10,          13,          12,          15,
    14,
#define _REJ_UNIFORM_IDX8
    I16(0, 1),   I16(1, 2),   I16(3, 4),   I16(4, 5),   I16(6, 7),
    I16(7, 8),   I16(9, 10),  I16(10, 11), I16(12, 13), I16(13, 14),
    I16(15, 16), I16(16, 17), I16(18, 19), I16(19, 20), I16(21, 22),
    I16(22, 23),
#define _REJ_UNIFORM_MASK_01
    0,           1,           0,           1,           0,
    1,           0,           1,           0,           1,
    0,           1,           0,           1,           0,
    1,
#define _CBD2_MASK_E8_01
    I16(0, 1),   I16(0, 1),   I16(0, 1),   I16(0, 1),   I16(0, 1),
    I16(0, 1),   I16(0, 1),   I16(0, 1),   I16(0, 1),   I16(0, 1),
    I16(0, 1),   I16(0, 1),   I16(0, 1),   I16(0, 1),   I16(0, 1),
    I16(0, 1),
#define _CBD2_IDX8_LOW
    I16(0, 0),   I16(1, 1),   I16(2, 2),   I16(3, 3),   I16(4, 4),
    I16(5, 5),   I16(6, 6),   I16(7, 7),   I16(8, 8),   I16(9, 9),
    I16(10, 10), I16(11, 11), I16(12, 12), I16(13, 13), I16(14, 14),
    I16(15, 15),
#define _CBD2_IDX8_HIGH
    I16(16, 16), I16(17, 17), I16(18, 18), I16(19, 19), I16(20, 20),
    I16(21, 21), I16(22, 22), I16(23, 23), I16(24, 24), I16(25, 25),
    I16(26, 26), I16(27, 27), I16(28, 28), I16(29, 29), I16(30, 30),
    I16(31, 31),
#define _CBD3_MASK_E8_0122
    I16(0, 1),   I16(2, 2),   I16(3, 4),   I16(5, 5),   I16(6, 7),
    I16(8, 8),   I16(9, 10),  I16(11, 11), I16(12, 13), I16(14, 14),
    I16(15, 16), I16(17, 17), I16(18, 19), I16(20, 20), I16(21, 22),
    I16(23, 23),
#define _CBD3_MASK_E16_1100
    1,           1,           0,           0,           1,
    1,           0,           0,           1,           1,
    0,           0,           1,           1,           0,
    0,
#define _CBD3_IDX16_LOW
    0,           1,           0,           1,           2,
    3,           2,           3,           4,           5,
    4,           5,           6,           7,           6,
    7,
#define _CBD3_IDX16_HIGH
    8,           9,           8,           9,           10,
    11,          10,          11,          12,          13,
    12,          13,          14,          15,          14,
    15,
#define _ZETAS_EXP_L0
    31498,       -758,
#define _ZETAS_EXP_L1
    14745,       -359,        787,         -1517,
#define _ZETAS_EXP_L2
    13525,       1493,        -12402,      1422,        28191,
    287,         -16694,      202,         0,           0,
#define _ZETAS_EXP_L3
    -20907,      -20907,      -20907,      -20907,      27758,
    27758,       27758,       27758,       -3799,       -3799,
    -3799,       -3799,       -15690,      -15690,      -15690,
    -15690,      -171,        -171,        -171,        -171,
    622,         622,         622,         622,         1577,
    1577,        1577,        1577,        182,         182,
    182,         182,         10690,       10690,       10690,
    10690,       1358,        1358,        1358,        1358,
    -11202,      -11202,      -11202,      -11202,      31164,
    31164,       31164,       31164,       962,         962,
    962,         962,         -1202,       -1202,       -1202,
    -1202,       -1474,       -1474,       -1474,       -1474,
    1468,        1468,        1468,        1468,
#define _ZETAS_EXP_L4
    -5827,       -5827,       17363,       17363,       -26360,
    -26360,      -29057,      -29057,      5571,        5571,
    -1102,       -1102,       21438,       21438,       -26242,
    -26242,      573,         573,         -1325,       -1325,
    264,         264,         383,         383,         -829,
    -829,        1458,        1458,        -1602,       -1602,
    -130,        -130,        -28073,      -28073,      24313,
    24313,       -10532,      -10532,      8800,        8800,
    18426,       18426,       8859,        8859,        26675,
    26675,       -16163,      -16163,      -681,        -681,
    1017,        1017,        732,         732,         608,
    608,         -1542,       -1542,       411,         411,
    -205,        -205,        -1571,       -1571,
#define _ZETAS_EXP_L5
    -5689,       -6516,       1496,        30967,       -23565,
    20179,       20710,       25080,       -12796,      26616,
    16064,       -12442,      9134,        -650,        -25986,
    27837,       1223,        652,         -552,        1015,
    -1293,       1491,        -282,        -1544,       516,
    -8,          -320,        -666,        -1618,       -1162,
    126,         1469,        19883,       -28250,      -15887,
    -8898,       -28309,      9075,        -30199,      18249,
    13426,       14017,       -29156,      -12757,      16832,
    4311,        -24155,      -17915,      -853,        -90,
    -271,        830,         107,         -1421,       -247,
    -951,        -398,        961,         -1508,       -725,
    448,         -1065,       677,         -1275,
#define _ZETAS_EXP_L6
    -335,        -11477,      -32227,      20494,       -27738,
    945,         -14883,      6182,        32010,       10631,
    29175,       -28762,      -18486,      17560,       -14430,
    -5276,       -1103,       555,         -1251,       1550,
    422,         177,         -291,        1574,        -246,
    1159,        -777,        -602,        -1590,       -872,
    418,         -156,        11182,       13387,       -14233,
    -21655,      13131,       -4587,       23092,       5493,
    -32502,      30317,       -18741,      12639,       20100,
    18525,       19529,       -12619,      430,         843,
    871,         105,         587,         -235,        -460,
    1653,        778,         -147,        1483,        1119,
    644,         349,         329,         -75,         -31183,
    25435,       -7382,       24391,       -20927,      10946,
    24214,       16989,       10335,       -7934,       -22502,
    10906,       31636,       28644,       23998,       -17422,
    817,         603,         1322,        -1465,       -1215,
    1218,        -874,        -1187,       -1185,       -1278,
    -1510,       -870,        -108,        996,         958,
    1522,        20297,       2146,        15355,       -32384,
    -6280,       -14903,      -11044,      14469,       -21498,
    -20198,      23210,       -17442,      -23860,      -20257,
    7756,        23132,       1097,        610,         -1285,
    384,         -136,        -1335,       220,         -1659,
    -1530,       794,         -854,        478,         -308,
    991,         -1460,       1628,
#define _ZETAS_BASEMUL
    -1103,       555,         -1251,       1550,        422,
    177,         -291,        1574,        -246,        1159,
    -777,        -602,        -1590,       -872,        418,
    -156,        1103,        -555,        1251,        -1550,
    -422,        -177,        291,         -1574,       246,
    -1159,       777,         602,         1590,        872,
    -418,        156,         430,         843,         871,
    105,         587,         -235,        -460,        1653,
    778,         -147,        1483,        1119,        644,
    349,         329,         -75,         -430,        -843,
    -871,        -105,        -587,        235,         460,
    -1653,       -778,        147,         -1483,       -1119,
    -644,        -349,        -329,        75,          817,
    603,         1322,        -1465,       -1215,       1218,
    -874,        -1187,       -1185,       -1278,       -1510,
    -870,        -108,        996,         958,         1522,
    -817,        -603,        -1322,       1465,        1215,
    -1218,       874,         1187,        1185,        1278,
    1510,        870,         108,         -996,        -958,
    -1522,       1097,        610,         -1285,       384,
    -136,        -1335,       220,         -1659,       -1530,
    794,         -854,        478,         -308,        991,
    -1460,       1628,        -1097,       -610,        1285,
    -384,        136,         1335,        -220,        1659,
    1530,        -794,        854,         -478,        308,
    -991,        1460,        -1628,
#define _ZETA_EXP_INTT_L0
    -23132,      -7756,       20257,       23860,       17442,
    -23210,      20198,       21498,       -14469,      11044,
    14903,       6280,        32384,       -15355,      -2146,
    -20297,      -1628,       1460,        -991,        308,
    -478,        854,         -794,        1530,        1659,
    -220,        1335,        136,         -384,        1285,
    -610,        -1097,       17422,       -23998,      -28644,
    -31636,      -10906,      22502,       7934,        -10335,
    -16989,      -24214,      -10946,      20927,       -24391,
    7382,        -25435,      31183,       -1522,       -958,
    -996,        108,         870,         1510,        1278,
    1185,        1187,        874,         -1218,       1215,
    1465,        -1322,       -603,        -817,        12619,
    -19529,      -18525,      -20100,      -12639,      18741,
    -30317,      32502,       -5493,       -23092,      4587,
    -13131,      21655,       14233,       -13387,      -11182,
    75,          -329,        -349,        -644,        -1119,
    -1483,       147,         -778,        -1653,       460,
    235,         -587,        -105,        -871,        -843,
    -430,        5276,        14430,       -17560,      18486,
    28762,       -29175,      -10631,      -32010,      -6182,
    14883,       -945,        27738,       -20494,      32227,
    11477,       335,         156,         -418,        872,
    1590,        602,         777,         -1159,       246,
    -1574,       291,         -177,        -422,        -1550,
    1251,        -555,        1103,
#define _ZETA_EXP_INTT_L1
    17915,       24155,       -4311,       -16832,      12757,
    29156,       -14017,      -13426,      -18249,      30199,
    -9075,       28309,       8898,        15887,       28250,
    -19883,      1275,        -677,        1065,        -448,
    725,         1508,        -961,        398,         951,
    247,         1421,        -107,        -830,        271,
    90,          853,         -27837,      25986,       650,
    -9134,       12442,       -16064,      -26616,      12796,
    -25080,      -20710,      -20179,      23565,       -30967,
    -1496,       6516,        5689,        -1469,       -126,
    1162,        1618,        666,         320,         8,
    -516,        1544,        282,         -1491,       1293,
    -1015,       552,         -652,        -1223,
#define _ZETA_EXP_INTT_L2
    16163,       16163,       -26675,      -26675,      -8859,
    -8859,       -18426,      -18426,      -8800,       -8800,
    10532,       10532,       -24313,      -24313,      28073,
    28073,       1571,        1571,        205,         205,
    -411,        -411,        1542,        1542,        -608,
    -608,        -732,        -732,        -1017,       -1017,
    681,         681,         26242,       26242,       -21438,
    -21438,      1102,        1102,        -5571,       -5571,
    29057,       29057,       26360,       26360,       -17363,
    -17363,      5827,        5827,        130,         130,
    1602,        1602,        -1458,       -1458,       829,
    829,         -383,        -383,        -264,        -264,
    1325,        1325,        -573,        -573,
#define _ZETA_EXP_INTT_L3
    -31164,      -31164,      -31164,      -31164,      11202,
    11202,       11202,       11202,       -1358,       -1358,
    -1358,       -1358,       -10690,      -10690,      -10690,
    -10690,      -1468,       -1468,       -1468,       -1468,
    1474,        1474,        1474,        1474,        1202,
    1202,        1202,        1202,        -962,        -962,
    -962,        -962,        15690,       15690,       15690,
    15690,       3799,        3799,        3799,        3799,
    -27758,      -27758,      -27758,      -27758,      20907,
    20907,       20907,       20907,       -182,        -182,
    -182,        -182,        -1577,       -1577,       -1577,
    -1577,       -622,        -622,        -622,        -622,
    171,         171,         171,         171,
#define _ZETA_EXP_INTT_L4
    16694,       16694,       16694,       16694,       16694,
    16694,       16694,       16694,       -28191,      -28191,
    -28191,      -28191,      -28191,      -28191,      -28191,
    -28191,      -202,        -202,        -202,        -202,
    -202,        -202,        -202,        -202,        -287,
    -287,        -287,        -287,        -287,        -287,
    -287,        -287,        12402,       12402,       12402,
    12402,       12402,       12402,       12402,       12402,
    -13525,      -13525,      -13525,      -13525,      -13525,
    -13525,      -13525,      -13525,      -1422,       -1422,
    -1422,       -1422,       -1422,       -1422,       -1422,
    -1422,       -1493,       -1493,       -1493,       -1493,
    -1493,       -1493,       -1493,       -1493,
#define _ZETA_EXP_INTT_L5
    -787,        1517,        -14745,      359,
#define _ZETA_EXP_INTT_L6
    -31498,      758,
};

// clang-format on
