/*
 * Copyright (C) 2020 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#include "compare.h"
#include "lc_hmac_drbg_sha512.h"
#include "test_helper_common.h"
#include "visibility.h"

static int hmac_drbg_tester(void)
{
#if 1
	static const uint8_t ent_nonce[] = {
		0xC5, 0xD9, 0xD7, 0x7B, 0x3E, 0x5C, 0x0E, 0xC8, 0x57, 0x13,
		0xEB, 0x25, 0x12, 0xE8, 0x15, 0x40, 0xBF, 0x65, 0x89, 0x15,
		0xB3, 0xF9, 0xC8, 0x95, 0x22, 0x05, 0xB5, 0xF0, 0x16, 0x0F,
		0xD0, 0xE8, 0xBD, 0xA7, 0xC6, 0x58, 0xE2, 0x4D, 0xB8, 0xBD,
		0xFC, 0xC5, 0x4E, 0x3A, 0xFE, 0xAA, 0xB5, 0x79, 0x71, 0xD4,
		0x95, 0x4D, 0xD9, 0x98, 0x38, 0x34, 0x28, 0xF2, 0x1A, 0x34,
		0x2D, 0xE8, 0xC9, 0x74
	};
	static const uint8_t pers[] = { 0x6E, 0xCF, 0x0F, 0xCC, 0x7C, 0x6F,
					0xEC, 0x03, 0x25, 0x8B, 0xDB, 0x2D,
					0xC5, 0xC5, 0xEB, 0x39, 0x33, 0x09,
					0x39, 0x53, 0xED, 0xDD, 0xC0, 0x23,
					0x26, 0x8A, 0x38, 0xA0, 0x4C, 0x3F,
					0x33, 0xEE };
	static const uint8_t addtl1[] = { 0xB5, 0x18, 0x81, 0x4D, 0xC6, 0xF8,
					  0x71, 0x03, 0x63, 0x5A, 0xCA, 0x88,
					  0xE2, 0xB6, 0x57, 0x13, 0x22, 0x0D,
					  0xE9, 0x28, 0xAD, 0x86, 0x01, 0x6C,
					  0xAE, 0xE9, 0x0C, 0x5C, 0x79, 0x41,
					  0x55, 0xB5 };
	static const uint8_t addtl2[] = { 0xEB, 0x61, 0x23, 0x14, 0xEA, 0x75,
					  0xDE, 0xFB, 0xEA, 0x48, 0x46, 0xA2,
					  0x2D, 0x5B, 0x3A, 0xDD, 0xE2, 0x30,
					  0x44, 0xFD, 0xD0, 0xB4, 0xD5, 0xE9,
					  0xEE, 0xC2, 0xF1, 0x1D, 0x58, 0xF9,
					  0x11, 0x9E };
	static const uint8_t exp[] = {
		0xb6, 0xb5, 0x4e, 0x7d, 0x8c, 0x62, 0xfe, 0x73, 0x64, 0x0d,
		0x57, 0xb4, 0xb5, 0x87, 0x05, 0x12, 0xe7, 0x62, 0xa8, 0x2d,
		0x86, 0xb8, 0x2b, 0xf3, 0x22, 0x66, 0x7e, 0x93, 0x93, 0x45,
		0x88, 0x30, 0xea, 0x2f, 0xbf, 0xba, 0x8f, 0xe7, 0xed, 0x2a,
		0xb2, 0x08, 0x55, 0x37, 0x63, 0x6e, 0xec, 0x1e, 0xe1, 0xdf,
		0x03, 0x60, 0xf0, 0xc0, 0x92, 0x30, 0x21, 0xdd, 0xff, 0x42,
		0xca, 0x5d, 0x7d, 0x67, 0xce, 0x74, 0xc8, 0x6b, 0xad, 0x20,
		0x75, 0xa8, 0xc3, 0xc0, 0x01, 0x98, 0xa1, 0x38, 0x31, 0x2d,
		0xd0, 0x83, 0x75, 0x17, 0x4c, 0x52, 0x5f, 0xed, 0x8a, 0xbc,
		0xa4, 0x0e, 0xd4, 0x4d, 0x0a, 0x32, 0x44, 0x00, 0xbe, 0x5d,
		0x57, 0xb3, 0x11, 0xa0, 0x32, 0x30, 0x49, 0xd8, 0xd3, 0xe9,
		0x35, 0xb6, 0x3b, 0x27, 0x81, 0xb0, 0x82, 0xf8, 0x19, 0x13,
		0xc5, 0xbc, 0x2f, 0xdc, 0x87, 0xcd, 0x92, 0xd2, 0xa7, 0xb2,
		0xe0, 0x8f, 0xcf, 0x79, 0x20, 0x15, 0x5f, 0x40, 0x47, 0xb6,
		0x7c, 0xe5, 0x6c, 0x7a, 0x6c, 0xe6, 0xb9, 0xba, 0x1b, 0x86,
		0x55, 0x1a, 0xc2, 0xc2, 0xf8, 0x3a, 0xd8, 0xd7, 0xa7, 0xe3,
		0x3c, 0x86, 0xa3, 0xe1, 0x88, 0x0f, 0x5c, 0x1e, 0x79, 0xa6,
		0x14, 0x58, 0x9e, 0x22, 0x22, 0xc2, 0x40, 0xf1, 0x93, 0x4b,
		0xb3, 0x3a, 0x25, 0x4e, 0xc2, 0xeb, 0x0d, 0x04, 0xde, 0xc1,
		0xe2, 0x46, 0x85, 0x6e, 0x65, 0x92, 0xa9, 0x24, 0x44, 0x87,
		0xd1, 0x42, 0x4c, 0x54, 0x71, 0xfb, 0xd7, 0x72, 0x84, 0xa5,
		0x64, 0x41, 0x57, 0x74, 0xb6, 0x01, 0xd7, 0x76, 0x4e, 0x66,
		0x86, 0x60, 0x3a, 0xa5, 0x14, 0x55, 0x5d, 0x5a, 0x56, 0xc4,
		0xb2, 0x82, 0xf9, 0xcd, 0x73, 0x7b, 0xb6, 0xe4, 0xac, 0xe5,
		0x46, 0x74, 0x10, 0xeb, 0x9f, 0x0d, 0x22, 0xf0, 0x94, 0xeb,
		0x09, 0x0f, 0x8e, 0x8d, 0x7f, 0x09
	};
	uint8_t act[256];
	struct lc_rng_ctx *drbg = NULL;
	int ret = 1;
	LC_DRBG_HMAC_CTX_ON_STACK(drbg_stack);

	printf("HMAC DRBG ctx len %u\n",
	       (unsigned int)LC_DRBG_HMAC_CTX_SIZE(LC_DRBG_HMAC_CORE));
	if (lc_rng_seed(drbg_stack, ent_nonce, 64, pers, 32))
		goto out;

	if (lc_rng_generate(drbg_stack, addtl1, 32, act, 256) < 0)
		goto out;

	if (lc_rng_generate(drbg_stack, addtl2, 32, act, 256) < 0)
		goto out;

	lc_rng_zero(drbg_stack);

	if (lc_drbg_hmac_healthcheck_sanity(drbg_stack))
		return 1;

	if (lc_drbg_hmac_alloc(&drbg))
		goto out;

	if (lc_rng_seed(drbg, ent_nonce, 64, pers, 32))
		goto out;

	if (lc_rng_generate(drbg, addtl1, 32, act, 256) < 0)
		goto out;

	if (lc_rng_generate(drbg, addtl2, 32, act, 256) < 0)
		goto out;
#endif
#if 0
	static const uint8_t ent_nonce[] = {
		0xAB, 0xB1, 0xC7, 0xCD, 0xBD, 0x22, 0x9C, 0xD3,
		0x88, 0x53, 0x63, 0x2E, 0xFE, 0xC2, 0x9A, 0x8E,
		0x3D, 0xFC, 0x1B, 0x48, 0xFB, 0x56, 0xD9, 0x5F,
		0x5B, 0x8F, 0x93, 0xDB, 0xAA, 0xEB, 0xB9, 0x73,
		0x97, 0x8D, 0xD2, 0x70, 0x3F, 0xD6, 0x63, 0x65,
		0x10, 0xE2, 0x62, 0xC5, 0x82, 0x8B, 0xC0, 0xE0,
		0x3E, 0x47, 0x9F, 0x56, 0x60, 0x8C, 0x03, 0xBF,
		0xD1, 0xD9, 0x6C, 0xAE, 0x87, 0x3F, 0x4D, 0xA4
	};
	static const uint8_t pers[] = {
		0xEC, 0x60, 0x9A, 0x96, 0x4B, 0x21, 0x2F, 0x6B,
		0x41, 0xE5, 0x2F, 0x3B, 0x0D, 0xDD, 0xE3, 0x54,
		0x34, 0x31, 0xF2, 0xD7, 0x2A, 0x3F, 0xF1, 0xC0,
		0x21, 0x8F, 0x74, 0xDC, 0xFA, 0x57, 0xAA, 0x27
	};
	static const uint8_t exp[] = {
		0x57, 0x3b, 0x88, 0xf5, 0x24, 0x55, 0x70, 0xb0,
		0xd9, 0xf8, 0xc9, 0x25, 0xae, 0xf5, 0x5f, 0x9f,
		0xa8, 0xa1, 0xa5, 0x90, 0x55, 0xdc, 0x16, 0x86,
		0x59, 0x87, 0x85, 0xed, 0xa7, 0x8f, 0x45, 0x00,
		0xa5, 0x9f, 0xee, 0x36, 0x75, 0x3e, 0x00, 0x6c,
		0xa8, 0x51, 0x5f, 0xe4, 0x8c, 0x01, 0xc8, 0x28,
		0x9e, 0x4d, 0xae, 0x47, 0xff, 0x88, 0xb3, 0x3e,
		0x61, 0xc3, 0xf3, 0x80, 0xf2, 0x78, 0x82, 0xfd,
		0x7f, 0x70, 0xbe, 0xac, 0xd6, 0xae, 0x19, 0x8e,
		0x62, 0x52, 0x81, 0xfc, 0x67, 0x13, 0xeb, 0xba,
		0x15, 0x16, 0xf2, 0x9d, 0x99, 0xdc, 0x5c, 0x21,
		0xf7, 0x65, 0xcb, 0x2c, 0x60, 0x17, 0x4d, 0x26,
		0x60, 0xef, 0x91, 0x34, 0x79, 0x27, 0xb6, 0x65,
		0x20, 0x1a, 0xd7, 0xa7, 0xf7, 0xb5, 0x6e, 0xd0,
		0xb6, 0x3d, 0x1f, 0x26, 0x20, 0x4b, 0x3b, 0x6d,
		0x49, 0xe5, 0x64, 0x05, 0xb8, 0x84, 0x64, 0x51,
		0xd6, 0xb1, 0x14, 0xa1, 0xb6, 0x91, 0xde, 0x30,
		0x20, 0x14, 0xe8, 0xc4, 0x21, 0x6e, 0x4f, 0x5b,
		0x2e, 0x0d, 0xd9, 0xdc, 0x11, 0x28, 0xc7, 0xa8,
		0xd6, 0x75, 0x2f, 0x93, 0x6e, 0xef, 0xb6, 0x46,
		0x96, 0x7a, 0xf0, 0x9a, 0xc9, 0x2e, 0x56, 0x6b,
		0x41, 0x4e, 0x1b, 0xc6, 0x47, 0x91, 0xcf, 0xba,
		0xc0, 0xc5, 0xe0, 0x83, 0xae, 0x53, 0xb8, 0x59,
		0xa3, 0x8a, 0x5d, 0x87, 0xf3, 0xa9, 0x27, 0x4e,
		0x5b, 0x55, 0xd9, 0x50, 0xdc, 0xf8, 0xa4, 0x41,
		0xef, 0x0e, 0x5a, 0xc2, 0xb2, 0x4a, 0x8d, 0x6b,
		0x04, 0x5f, 0xee, 0x4d, 0xc9, 0xb4, 0xd8, 0x95,
		0x9e, 0xd4, 0x12, 0x11, 0xc3, 0xa8, 0xd4, 0xcf,
		0xb6, 0x5f, 0x29, 0x6e, 0x12, 0xee, 0xae, 0x0b,
		0xfa, 0xb7, 0xa5, 0x5b, 0xeb, 0x7a, 0x4f, 0x59,
		0x26, 0x21, 0xe7, 0xb9, 0xbc, 0x34, 0x72, 0xd8,
		0xfa, 0xb9, 0x51, 0xeb, 0xeb, 0x15, 0xbb, 0x35
	};
	uint8_t act[256];
	struct lc_rng_ctx *drbg;
	int ret = 1;

	if (lc_drbg_hmac_alloc(&drbg))
		goto out;

	if (lc_rng_seed(drbg, ent_nonce, 64, pers, 32))
		goto out;

	if (lc_rng_generate(drbg, NULL, 0, act, 256) < 0)
		goto out;

	if (lc_rng_generate(drbg, NULL, 0, act, 256) < 0)
		goto out;
#endif
#if 0
	static const uint8_t ent_nonce[] = {
		0x6D, 0xF5, 0xD4, 0x41, 0xB7, 0xEA, 0xF6, 0xB4,
		0x23, 0x06, 0xDF, 0x67, 0xE0, 0x18, 0xEF, 0x0B,
		0xD0, 0x67, 0x30, 0x50, 0xEE, 0x94, 0xB8, 0x4B,
		0x61, 0x92, 0xBA, 0x57, 0x7F, 0x0E, 0x66, 0x04,
		0x77, 0x1F, 0xDA, 0xCF, 0x61, 0xCA, 0xEA, 0x60,
		0x25, 0xA7, 0xDC, 0xE3, 0xB2, 0x05, 0xC6, 0xA5,
		0x1A, 0xFC, 0x31, 0x0F, 0x00, 0xC6, 0xA2, 0x75,
		0xC7, 0xBE, 0xCE, 0x4B, 0x61, 0x8B, 0x6B, 0xD8
	};

	static const uint8_t exp[] = {
		0x45, 0x49, 0xf8, 0x49, 0xfe, 0x7a, 0xb8, 0x79,
		0xe2, 0x03, 0x5e, 0xb4, 0x76, 0x50, 0x55, 0x65,
		0xc1, 0x14, 0x27, 0xc9, 0xc6, 0xbd, 0xb6, 0xc1,
		0x95, 0x12, 0x20, 0xf6, 0x1a, 0x3f, 0x86, 0x99,
		0xa8, 0xb1, 0xc9, 0x40, 0x11, 0x30, 0x6d, 0xf9,
		0xcb, 0x8a, 0x4b, 0xff, 0x2c, 0xe2, 0xa5, 0xf2,
		0x1a, 0x89, 0x1a, 0xc2, 0xaf, 0x00, 0xf6, 0xf8,
		0xc4, 0x5f, 0x98, 0xf5, 0xd7, 0x61, 0xa9, 0xae,
		0x3a, 0x93, 0x66, 0xe4, 0x85, 0xfd, 0xbe, 0x40,
		0xbc, 0xb4, 0x7c, 0x9d, 0x88, 0xe3, 0xa7, 0x48,
		0xe0, 0x08, 0x20, 0x04, 0x2b, 0x0a, 0xc9, 0x95,
		0x1c, 0xcc, 0xbc, 0x03, 0xbc, 0x37, 0x42, 0x2c,
		0x04, 0x1c, 0x18, 0x0d, 0x9e, 0x27, 0x9f, 0xa8,
		0x16, 0xc5, 0x69, 0xb7, 0xfa, 0x3e, 0xf5, 0x2c,
		0xd6, 0x4b, 0x3e, 0xa6, 0xb7, 0x72, 0xaa, 0x22,
		0x72, 0xf6, 0x54, 0xab, 0xd7, 0x66, 0x3e, 0x99,
		0xee, 0x9b, 0xc7, 0x53, 0x59, 0x85, 0xbf, 0xe5,
		0x62, 0xab, 0xa2, 0xce, 0x72, 0x18, 0x84, 0xd8,
		0xe0, 0xf1, 0x87, 0x7b, 0xe6, 0x83, 0xea, 0x0b,
		0xe5, 0xc5, 0x9c, 0xca, 0xfd, 0xbb, 0xaf, 0x49,
		0xc6, 0xe9, 0x8a, 0x01, 0x4a, 0x79, 0x66, 0x8d,
		0x20, 0xea, 0xf5, 0x38, 0x44, 0xe8, 0xc1, 0xc5,
		0x8d, 0x7d, 0xdd, 0xce, 0x0f, 0xa8, 0x91, 0xd9,
		0x67, 0xfe, 0xa4, 0xb4, 0x23, 0x56, 0x37, 0xee,
		0xe9, 0x35, 0x2b, 0x0c, 0x1d, 0x48, 0xea, 0xef,
		0xbd, 0xe2, 0x48, 0xba, 0xd0, 0x99, 0x26, 0xd6,
		0xbe, 0x55, 0xbd, 0x91, 0xef, 0x81, 0xa9, 0x6a,
		0x27, 0xb3, 0xb7, 0x67, 0x05, 0x20, 0x2d, 0x82,
		0x9f, 0xd7, 0x08, 0x77, 0x05, 0x3a, 0xc8, 0xec,
		0x2a, 0xe5, 0x6f, 0x7c, 0xb5, 0x8e, 0xd7, 0x18,
		0xca, 0xa4, 0x9a, 0x56, 0xdd, 0x95, 0xb0, 0xee,
		0xd2, 0xdf, 0x0d, 0x9e, 0x2e, 0x7e, 0xbe, 0x39
	};
	uint8_t act[256];
	struct lc_rng_ctx *drbg;
	int ret = 1;

	if (lc_drbg_hmac_alloc(&drbg))
		goto out;

	if (lc_rng_seed(drbg, ent_nonce, 64, NULL, 0))
		goto out;

	if (lc_rng_generate(drbg, NULL, 0, act, 256) < 0)
		goto out;

	if (lc_rng_generate(drbg, NULL, 0, act, 256) < 0)
		goto out;
#endif

	ret = lc_compare(act, exp, 256, "Hash DRBG SHA-512");

out:
	lc_rng_zero_free(drbg);
	return ret;
}

LC_TEST_FUNC(int, main, int argc, char *argv[])
{
	int ret;

	(void)argc;
	(void)argv;

	ret = hmac_drbg_tester();

	ret = test_validate_status(ret, LC_ALG_STATUS_HMAC_DRBG, 1);
	ret = test_validate_status(ret, LC_ALG_STATUS_SHA256, 1);
#ifndef LC_FIPS140_DEBUG
	ret = test_validate_status(ret, LC_ALG_STATUS_SHA512, 1);
#endif
	ret = test_validate_status(ret, LC_ALG_STATUS_HMAC, 1);
	ret += test_print_status();

	return ret;
}
