import argparse
import json
import sys

from keylime.mba import mba
from keylime.mba.elparsing import tpm2_tools_elparser

from . import policies

# This main module is just for command-line based testing.
# It implements a command to do one test.
# Invoke it with `python3 -m $packagename`, for some value of
# `$packagename` that works with your `$PYTHONPATH`.

mba.load_imports()
parser = argparse.ArgumentParser()
parser.add_argument("policy_name", choices=policies.get_policy_names())
parser.add_argument("refstate_file", help="Path to reference state file (text mode)")
parser.add_argument(
    "eventlog_file", nargs="?", default="-", help="Path to event log file (binary mode), use '-' for stdin"
)
args = parser.parse_args()
policy = policies.get_policy(args.policy_name)
if policy is None:
    print(
        f"Specified policy '{args.policy_name}' does not exist. Options are: {policies.get_policy_names()}.",
        file=sys.stderr,
    )
    sys.exit(1)

with open(args.refstate_file, "rt", encoding="utf-8") as refstate_file:
    refstate_str = refstate_file.read()
refstate = json.loads(refstate_str)

if args.eventlog_file == "-":
    log_bin = sys.stdin.buffer.read()
else:
    with open(args.eventlog_file, "rb") as eventlog_file:
        log_bin = eventlog_file.read()

_, log_data = tpm2_tools_elparser.parse_binary_bootlog(log_bin)
with open("/tmp/parsed.json", "wt", encoding="utf-8") as log_data_file:
    log_data_file.write(json.dumps(log_data, indent=True))
why_not = policy.evaluate(refstate, log_data)
if why_not:
    print(why_not, file=sys.stderr)
    sys.exit(1)
print("AOK")
