# PR Title 
**Example:** `feat: Add secure boot measurement support`

## Type of Change
*(Select all that apply)*
- [ ] Bug fix (non-breaking change)
- [ ] New feature (non-breaking change)
- [ ] Breaking change (fix/feature causing existing behavior to change)
- [ ] Documentation update (standalone)
- [ ] Code refactor (no functional changes)
- [ ] Test cases (added/modified)
- [ ] CI/CD changes
- [ ] Other (please specify: ______)

## Related Issues
*(If you use an issue tracker, please put references to them)*  
**Resolves:** #123  
**See also:** #456, #789

## Change Description

### Concise Summary
Summarize changes in around 50 characters or less  

More detailed explanatory text, if necessary. Wrap it to about 72 characters or so. In some contexts, the first line is treated as the subject of the commit and the rest of the text as the body. The blank line separating the summary from the body is critical (unless you omit the body entirely); various tools like `log`, `shortlog` and `rebase` can get confused if you run the two together.

### Technical Details
 
Explain the problem being solved and why this change is necessary. Focus on:
- Motivation behind the change
- Architectural decisions
- Unintended side effects
- Alternative approaches considered

Use bullet points where appropriate:
- Keep items concise
- Separate with blank lines
- Maintain consistency

## Documentation Updates Required
*(Check all that apply)*
- [ ] Updated markdown docs (file path: ______)
- [ ] Updated code comments/docstrings
- [ ] Needs user guide updates (`docs/`)
- [ ] Needs ReadTheDocs updates
- [ ] No docs needed (requires maintainer approval)

## Verification Process
1. Describe test environment
2. Step-by-step validation procedure
3. Expected vs actual results

## Checklist
- [ ] Code follows project style guidelines
- [ ] Unit/integration tests added/updated
- [ ] Documentation updated (per above section)
- [ ] Commit messages follow [Chris Beams' How to Write a Git Commit Message article] (https://chris.beams.io/posts/git-commit/)
- [ ] CHANGELOG updated (if applicable)
- [ ] All tests pass (local & CI)

## Additional Context
*(Optional: follow-up tasks, special considerations)*