/* Generated by JTB 1.5.1 */
package EDU.purdue.jtb.parser.visitor;

import static EDU.purdue.jtb.parser.syntaxtree.NodeConstants.*;
import EDU.purdue.jtb.parser.Token;
import EDU.purdue.jtb.parser.syntaxtree.*;
import EDU.purdue.jtb.parser.visitor.signature.NodeFieldsSignature;

/**
 * Provides default methods which visit each node in the tree in depth-first order.<br>
 * In your "Int" visitors extend this class and override part or all of these methods.
 *
 */
public class DepthFirstIntVisitor implements IIntVisitor {


  /*
   * Base nodes classes visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link NodeChoice} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public int visit(final NodeChoice n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    final int nRes = n.choice.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link NodeList} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public int visit(final NodeList n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    int nRes = 0;
    for (INode e : n.nodes) {
      @SuppressWarnings("unused")
      final int sRes = e.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link NodeListOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public int visit(final NodeListOptional n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    if (n.present()) {
      int nRes = 0;
      for (INode e : n.nodes) {
        @SuppressWarnings("unused")
        int sRes = e.accept(this);
      }
      return nRes;
    }
    return 0;
  }

  /**
   * Visits a {@link NodeOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public int visit(final NodeOptional n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    if (n.present()) {
      final int nRes = n.node.accept(this);
      return nRes;
    }
    return 0;
  }

  /**
   * Visits a {@link NodeSequence} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public int visit(final NodeSequence n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    int nRes = 0;
    for (INode e : n.nodes) {
      @SuppressWarnings("unused")
      int subRet = e.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link Token} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public int visit(final Token n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    int nRes = 0;
    @SuppressWarnings("unused")
    final String tkIm = n.image;
    return nRes;
  }

  /*
   * User grammar generated visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link JavaCCInput} node, whose children are the following :
   * <p>
   * f0 -> JavaCCOptions()<br>
   * f1 -> "PARSER_BEGIN"<br>
   * f2 -> "("<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> ")"<br>
   * f5 -> CompilationUnit()<br>
   * f6 -> "PARSER_END"<br>
   * f7 -> "("<br>
   * f8 -> IdentifierAsString()<br>
   * f9 -> ")"<br>
   * f10 -> ( Production() )+<br>
   * f11 -> < EOF ><br>
   * s: 1465207473<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1465207473, JTB_SIG_JAVACCINPUT, JTB_USER_JAVACCINPUT })
  public int visit(final JavaCCInput n) {
    int nRes = 0;
    // f0 -> JavaCCOptions()
    final JavaCCOptions n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "PARSER_BEGIN"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "("
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> ")"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> CompilationUnit()
    final CompilationUnit n5 = n.f5;
    nRes = n5.accept(this);
    // f6 -> "PARSER_END"
    final Token n6 = n.f6;
    nRes = n6.accept(this);
    // f7 -> "("
    final Token n7 = n.f7;
    nRes = n7.accept(this);
    // f8 -> IdentifierAsString()
    final IdentifierAsString n8 = n.f8;
    nRes = n8.accept(this);
    // f9 -> ")"
    final Token n9 = n.f9;
    nRes = n9.accept(this);
    // f10 -> ( Production() )+
    final NodeList n10 = n.f10;
    for (int i = 0; i < n10.size(); i++) {
      final INode lsteai = n10.elementAt(i);
      nRes = lsteai.accept(this);
    }
    // f11 -> < EOF >
    final Token n11 = n.f11;
    nRes = n11.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link JavaCCOptions} node, whose child is the following :
   * <p>
   * f0 -> [ #0 "options" #1 "{"<br>
   * .. .. . #2 ( OptionBinding() )*<br>
   * .. .. . #3 "}" ]<br>
   * s: -1270729337<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1270729337, JTB_SIG_JAVACCOPTIONS, JTB_USER_JAVACCOPTIONS })
  public int visit(final JavaCCOptions n) {
    int nRes = 0;
    // f0 -> [ #0 "options" #1 "{"
    // .. .. . #2 ( OptionBinding() )*
    // .. .. . #3 "}" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence seq = (NodeSequence) n0.node;
      //#0 "options"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 "{"
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
      //#2 ( OptionBinding() )*
      final INode nd2 = seq.elementAt(2);
      final NodeListOptional nlo = (NodeListOptional) nd2;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          nRes = nloeai.accept(this);
        }
      }
      //#3 "}"
      final INode nd3 = seq.elementAt(3);
      nRes = nd3.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link OptionBinding} node, whose children are the following :
   * <p>
   * f0 -> ( %0 < IDENTIFIER ><br>
   * .. .. | %1 "LOOKAHEAD"<br>
   * .. .. | %2 "IGNORE_CASE"<br>
   * .. .. | %3 "static" )<br>
   * f1 -> "="<br>
   * f2 -> ( %0 IntegerLiteral()<br>
   * .. .. | %1 BooleanLiteral()<br>
   * .. .. | %2 StringLiteral() )<br>
   * f3 -> ";"<br>
   * s: -1998174573<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1998174573, JTB_SIG_OPTIONBINDING, JTB_USER_OPTIONBINDING })
  public int visit(final OptionBinding n) {
    int nRes = 0;
    // f0 -> ( %0 < IDENTIFIER >
    // .. .. | %1 "LOOKAHEAD"
    // .. .. | %2 "IGNORE_CASE"
    // .. .. | %3 "static" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < IDENTIFIER >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 "LOOKAHEAD"
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 "IGNORE_CASE"
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 "static"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f1 -> "="
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 IntegerLiteral()
    // .. .. | %1 BooleanLiteral()
    // .. .. | %2 StringLiteral() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch1 = n2;
    final INode ich1 = nch1.choice;
    switch (nch1.which) {
      case 0:
        //%0 IntegerLiteral()
        nRes = ich1.accept(this);
        break;
      case 1:
        //%1 BooleanLiteral()
        nRes = ich1.accept(this);
        break;
      case 2:
        //%2 StringLiteral()
        nRes = ich1.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch1);
    }
    // f3 -> ";"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Production} node, whose child is the following :
   * <p>
   * f0 -> . %0 JavaCodeProduction()<br>
   * .. .. | %1 RegularExprProduction()<br>
   * .. .. | %2 TokenManagerDecls()<br>
   * .. .. | %3 BNFProduction()<br>
   * s: -120615333<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -120615333, JTB_SIG_PRODUCTION, JTB_USER_PRODUCTION })
  public int visit(final Production n) {
    int nRes = 0;
    // f0 -> . %0 JavaCodeProduction()
    // .. .. | %1 RegularExprProduction()
    // .. .. | %2 TokenManagerDecls()
    // .. .. | %3 BNFProduction()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 JavaCodeProduction()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 RegularExprProduction()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 TokenManagerDecls()
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 BNFProduction()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link JavaCodeProduction} node, whose children are the following :
   * <p>
   * f0 -> "JAVACODE"<br>
   * f1 -> AccessModifier()<br>
   * f2 -> ResultType()<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> FormalParameters()<br>
   * f5 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f6 -> [ "%" ]<br>
   * f7 -> Block()<br>
   * s: -763138104<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -763138104, JTB_SIG_JAVACODEPRODUCTION, JTB_USER_JAVACODEPRODUCTION })
  public int visit(final JavaCodeProduction n) {
    int nRes = 0;
    // f0 -> "JAVACODE"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> AccessModifier()
    final AccessModifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ResultType()
    final ResultType n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> FormalParameters()
    final FormalParameters n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence seq = (NodeSequence) n5.node;
      //#0 "throws"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 Name()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
      //#2 ( $0 "," $1 Name() )*
      final INode nd2 = seq.elementAt(2);
      final NodeListOptional nlo = (NodeListOptional) nd2;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) nloeai;
          //$0 ","
          final INode nd3 = seq1.elementAt(0);
          nRes = nd3.accept(this);
          //$1 Name()
          final INode nd4 = seq1.elementAt(1);
          nRes = nd4.accept(this);
        }
      }
    }
    // f6 -> [ "%" ]
    final NodeOptional n6 = n.f6;
    if (n6.present()) {
      nRes = n6.accept(this);
    }
    // f7 -> Block()
    final Block n7 = n.f7;
    nRes = n7.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BNFProduction} node, whose children are the following :
   * <p>
   * f0 -> AccessModifier()<br>
   * f1 -> ResultType()<br>
   * f2 -> IdentifierAsString()<br>
   * f3 -> FormalParameters()<br>
   * f4 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f5 -> [ "!" ]<br>
   * f6 -> ":"<br>
   * f7 -> Block()<br>
   * f8 -> "{"<br>
   * f9 -> ExpansionChoices()<br>
   * f10 -> "}"<br>
   * s: 1323482450<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1323482450, JTB_SIG_BNFPRODUCTION, JTB_USER_BNFPRODUCTION })
  public int visit(final BNFProduction n) {
    int nRes = 0;
    // f0 -> AccessModifier()
    final AccessModifier n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> IdentifierAsString()
    final IdentifierAsString n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> FormalParameters()
    final FormalParameters n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence seq = (NodeSequence) n4.node;
      //#0 "throws"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 Name()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
      //#2 ( $0 "," $1 Name() )*
      final INode nd2 = seq.elementAt(2);
      final NodeListOptional nlo = (NodeListOptional) nd2;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) nloeai;
          //$0 ","
          final INode nd3 = seq1.elementAt(0);
          nRes = nd3.accept(this);
          //$1 Name()
          final INode nd4 = seq1.elementAt(1);
          nRes = nd4.accept(this);
        }
      }
    }
    // f5 -> [ "!" ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      nRes = n5.accept(this);
    }
    // f6 -> ":"
    final Token n6 = n.f6;
    nRes = n6.accept(this);
    // f7 -> Block()
    final Block n7 = n.f7;
    nRes = n7.accept(this);
    // f8 -> "{"
    final Token n8 = n.f8;
    nRes = n8.accept(this);
    // f9 -> ExpansionChoices()
    final ExpansionChoices n9 = n.f9;
    nRes = n9.accept(this);
    // f10 -> "}"
    final Token n10 = n.f10;
    nRes = n10.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AccessModifier} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "public"<br>
   * .. .. | %1 "protected"<br>
   * .. .. | %2 "private"<br>
   * .. .. | %3 "final" )*<br>
   * s: -1053437682<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1053437682, JTB_SIG_ACCESSMODIFIER, JTB_USER_ACCESSMODIFIER })
  public int visit(final AccessModifier n) {
    int nRes = 0;
    // f0 -> ( %0 "public"
    // .. .. | %1 "protected"
    // .. .. | %2 "private"
    // .. .. | %3 "final" )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode nloeai = n0.elementAt(i);
        final NodeChoice nch = (NodeChoice) nloeai;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 "public"
            nRes = ich.accept(this);
            break;
          case 1:
            //%1 "protected"
            nRes = ich.accept(this);
            break;
          case 2:
            //%2 "private"
            nRes = ich.accept(this);
            break;
          case 3:
            //%3 "final"
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link RegularExprProduction} node, whose children are the following :
   * <p>
   * f0 -> [ %0 #0 "<" #1 "*" #2 ">"<br>
   * .. .. | %1 #0 "<" #1 < IDENTIFIER ><br>
   * .. .. . .. #2 ( $0 "," $1 < IDENTIFIER > )*<br>
   * .. .. . .. #3 ">" ]<br>
   * f1 -> RegExprKind()<br>
   * f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]<br>
   * f3 -> ":"<br>
   * f4 -> "{"<br>
   * f5 -> RegExprSpec()<br>
   * f6 -> ( #0 "|" #1 RegExprSpec() )*<br>
   * f7 -> "}"<br>
   * s: 484788342<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 484788342, JTB_SIG_REGULAREXPRPRODUCTION, JTB_USER_REGULAREXPRPRODUCTION })
  public int visit(final RegularExprProduction n) {
    int nRes = 0;
    // f0 -> [ %0 #0 "<" #1 "*" #2 ">"
    // .. .. | %1 #0 "<" #1 < IDENTIFIER >
    // .. .. . .. #2 ( $0 "," $1 < IDENTIFIER > )*
    // .. .. . .. #3 ">" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeChoice nch = (NodeChoice) n0.node;
      final INode ich = nch.choice;
      switch (nch.which) {
        case 0:
          //%0 #0 "<" #1 "*" #2 ">"
          final NodeSequence seq = (NodeSequence) ich;
          //#0 "<"
          final INode nd = seq.elementAt(0);
          nRes = nd.accept(this);
          //#1 "*"
          final INode nd1 = seq.elementAt(1);
          nRes = nd1.accept(this);
          //#2 ">"
          final INode nd2 = seq.elementAt(2);
          nRes = nd2.accept(this);
          break;
        case 1:
          //%1 #0 "<" #1 < IDENTIFIER >
          //.. #2 ( $0 "," $1 < IDENTIFIER > )*
          //.. #3 ">"
          final NodeSequence seq1 = (NodeSequence) ich;
          //#0 "<"
          final INode nd3 = seq1.elementAt(0);
          nRes = nd3.accept(this);
          //#1 < IDENTIFIER >
          final INode nd4 = seq1.elementAt(1);
          nRes = nd4.accept(this);
          //#2 ( $0 "," $1 < IDENTIFIER > )*
          final INode nd5 = seq1.elementAt(2);
          final NodeListOptional nlo = (NodeListOptional) nd5;
          if (nlo.present()) {
            for (int i = 0; i < nlo.size(); i++) {
              final INode nloeai = nlo.elementAt(i);
              final NodeSequence seq2 = (NodeSequence) nloeai;
              //$0 ","
              final INode nd6 = seq2.elementAt(0);
              nRes = nd6.accept(this);
              //$1 < IDENTIFIER >
              final INode nd7 = seq2.elementAt(1);
              nRes = nd7.accept(this);
            }
          }
          //#3 ">"
          final INode nd8 = seq1.elementAt(3);
          nRes = nd8.accept(this);
          break;
        default:
          // should not occur !!!
          throw new ShouldNotOccurException(nch);
      }
    }
    // f1 -> RegExprKind()
    final RegExprKind n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence seq3 = (NodeSequence) n2.node;
      //#0 "["
      final INode nd9 = seq3.elementAt(0);
      nRes = nd9.accept(this);
      //#1 "IGNORE_CASE"
      final INode nd10 = seq3.elementAt(1);
      nRes = nd10.accept(this);
      //#2 "]"
      final INode nd11 = seq3.elementAt(2);
      nRes = nd11.accept(this);
    }
    // f3 -> ":"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> "{"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> RegExprSpec()
    final RegExprSpec n5 = n.f5;
    nRes = n5.accept(this);
    // f6 -> ( #0 "|" #1 RegExprSpec() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode nloeai = n6.elementAt(i);
        final NodeSequence seq4 = (NodeSequence) nloeai;
        //#0 "|"
        final INode nd12 = seq4.elementAt(0);
        nRes = nd12.accept(this);
        //#1 RegExprSpec()
        final INode nd13 = seq4.elementAt(1);
        nRes = nd13.accept(this);
      }
    }
    // f7 -> "}"
    final Token n7 = n.f7;
    nRes = n7.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TokenManagerDecls} node, whose children are the following :
   * <p>
   * f0 -> "TOKEN_MGR_DECLS"<br>
   * f1 -> ":"<br>
   * f2 -> ClassOrInterfaceBody()<br>
   * s: -1566997219<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1566997219, JTB_SIG_TOKENMANAGERDECLS, JTB_USER_TOKENMANAGERDECLS })
  public int visit(final TokenManagerDecls n) {
    int nRes = 0;
    // f0 -> "TOKEN_MGR_DECLS"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ":"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link RegExprKind} node, whose child is the following :
   * <p>
   * f0 -> . %0 "TOKEN"<br>
   * .. .. | %1 "SPECIAL_TOKEN"<br>
   * .. .. | %2 "SKIP"<br>
   * .. .. | %3 "MORE"<br>
   * s: -1874441621<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1874441621, JTB_SIG_REGEXPRKIND, JTB_USER_REGEXPRKIND })
  public int visit(final RegExprKind n) {
    int nRes = 0;
    // f0 -> . %0 "TOKEN"
    // .. .. | %1 "SPECIAL_TOKEN"
    // .. .. | %2 "SKIP"
    // .. .. | %3 "MORE"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 "TOKEN"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 "SPECIAL_TOKEN"
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 "SKIP"
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 "MORE"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link RegExprSpec} node, whose children are the following :
   * <p>
   * f0 -> RegularExpression()<br>
   * f1 -> [ "!" ]<br>
   * f2 -> [ Block() ]<br>
   * f3 -> [ #0 ":" #1 < IDENTIFIER > ]<br>
   * s: -1949948808<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1949948808, JTB_SIG_REGEXPRSPEC, JTB_USER_REGEXPRSPEC })
  public int visit(final RegExprSpec n) {
    int nRes = 0;
    // f0 -> RegularExpression()
    final RegularExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ "!" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> [ Block() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ #0 ":" #1 < IDENTIFIER > ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      //#0 ":"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 < IDENTIFIER >
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ExpansionChoices} node, whose children are the following :
   * <p>
   * f0 -> Expansion()<br>
   * f1 -> ( #0 "|" #1 Expansion() )*<br>
   * s: -1726831935<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1726831935, JTB_SIG_EXPANSIONCHOICES, JTB_USER_EXPANSIONCHOICES })
  public int visit(final ExpansionChoices n) {
    int nRes = 0;
    // f0 -> Expansion()
    final Expansion n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "|" #1 Expansion() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "|"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 Expansion()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link Expansion} node, whose children are the following :
   * <p>
   * f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?<br>
   * f1 -> ( ExpansionUnit() )+<br>
   * s: -2134365682<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2134365682, JTB_SIG_EXPANSION, JTB_USER_EXPANSION })
  public int visit(final Expansion n) {
    int nRes = 0;
    // f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence seq = (NodeSequence) n0.node;
      //#0 "LOOKAHEAD"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 "("
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
      //#2 LocalLookahead()
      final INode nd2 = seq.elementAt(2);
      nRes = nd2.accept(this);
      //#3 ")"
      final INode nd3 = seq.elementAt(3);
      nRes = nd3.accept(this);
    }
    // f1 -> ( ExpansionUnit() )+
    final NodeList n1 = n.f1;
    for (int i = 0; i < n1.size(); i++) {
      final INode lsteai = n1.elementAt(i);
      nRes = lsteai.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link LocalLookahead} node, whose children are the following :
   * <p>
   * f0 -> [ IntegerLiteral() ]<br>
   * f1 -> [ "," ]<br>
   * f2 -> [ ExpansionChoices() ]<br>
   * f3 -> [ "," ]<br>
   * f4 -> [ #0 "{"<br>
   * .. .. . #1 [ Expression() ]<br>
   * .. .. . #2 "}" ]<br>
   * s: -1879920786<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1879920786, JTB_SIG_LOCALLOOKAHEAD, JTB_USER_LOCALLOOKAHEAD })
  public int visit(final LocalLookahead n) {
    int nRes = 0;
    // f0 -> [ IntegerLiteral() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> [ "," ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> [ ExpansionChoices() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> [ #0 "{"
    // .. .. . #1 [ Expression() ]
    // .. .. . #2 "}" ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence seq = (NodeSequence) n4.node;
      //#0 "{"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 [ Expression() ]
      final INode nd1 = seq.elementAt(1);
      final NodeOptional opt = (NodeOptional) nd1;
      if (opt.present()) {
        nRes = opt.accept(this);
      }
      //#2 "}"
      final INode nd2 = seq.elementAt(2);
      nRes = nd2.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ExpansionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"<br>
   * .. .. | %1 Block()<br>
   * .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"<br>
   * .. .. | %3 ExpansionUnitTCF()<br>
   * .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]<br>
   * .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()<br>
   * .. .. . .. .. . .. $2 [ "!" ]<br>
   * .. .. . .. .. | &1 $0 RegularExpression()<br>
   * .. .. . .. .. . .. $1 [ ?0 "." ?1 < IDENTIFIER > ]<br>
   * .. .. . .. .. . .. $2 [ "!" ] )<br>
   * .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?" )?<br>
   * s: 1116287061<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1116287061, JTB_SIG_EXPANSIONUNIT, JTB_USER_EXPANSIONUNIT })
  public int visit(final ExpansionUnit n) {
    int nRes = 0;
    // f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
    // .. .. | %1 Block()
    // .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"
    // .. .. | %3 ExpansionUnitTCF()
    // .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]
    // .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
    // .. .. . .. .. . .. $2 [ "!" ]
    // .. .. . .. .. | &1 $0 RegularExpression()
    // .. .. . .. .. . .. $1 [ ?0 "." ?1 < IDENTIFIER > ]
    // .. .. . .. .. . .. $2 [ "!" ] )
    // .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?" )?
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "LOOKAHEAD"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 "("
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 LocalLookahead()
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        //#3 ")"
        final INode nd3 = seq.elementAt(3);
        nRes = nd3.accept(this);
        break;
      case 1:
        //%1 Block()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 #0 "[" #1 ExpansionChoices() #2 "]"
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "["
        final INode nd4 = seq1.elementAt(0);
        nRes = nd4.accept(this);
        //#1 ExpansionChoices()
        final INode nd5 = seq1.elementAt(1);
        nRes = nd5.accept(this);
        //#2 "]"
        final INode nd6 = seq1.elementAt(2);
        nRes = nd6.accept(this);
        break;
      case 3:
        //%3 ExpansionUnitTCF()
        nRes = ich.accept(this);
        break;
      case 4:
        //%4 #0 [ $0 PrimaryExpression() $1 "=" ]
        //.. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
        //.. .. .. $2 [ "!" ]
        //.. .. | &1 $0 RegularExpression()
        //.. .. .. $1 [ ?0 "." ?1 < IDENTIFIER > ]
        //.. .. .. $2 [ "!" ] )
        final NodeSequence seq2 = (NodeSequence) ich;
        //#0 [ $0 PrimaryExpression() $1 "=" ]
        final INode nd7 = seq2.elementAt(0);
        final NodeOptional opt = (NodeOptional) nd7;
        if (opt.present()) {
          final NodeSequence seq3 = (NodeSequence) opt.node;
          //$0 PrimaryExpression()
          final INode nd8 = seq3.elementAt(0);
          nRes = nd8.accept(this);
          //$1 "="
          final INode nd9 = seq3.elementAt(1);
          nRes = nd9.accept(this);
        }
        //#1 ( &0 $0 IdentifierAsString() $1 Arguments()
        //.. .. $2 [ "!" ]
        //.. | &1 $0 RegularExpression()
        //.. .. $1 [ ?0 "." ?1 < IDENTIFIER > ]
        //.. .. $2 [ "!" ] )
        final INode nd10 = seq2.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) nd10;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 $0 IdentifierAsString() $1 Arguments()
            //.. $2 [ "!" ]
            final NodeSequence seq4 = (NodeSequence) ich1;
            //$0 IdentifierAsString()
            final INode nd11 = seq4.elementAt(0);
            nRes = nd11.accept(this);
            //$1 Arguments()
            final INode nd12 = seq4.elementAt(1);
            nRes = nd12.accept(this);
            //$2 [ "!" ]
            final INode nd13 = seq4.elementAt(2);
            final NodeOptional opt1 = (NodeOptional) nd13;
            if (opt1.present()) {
              nRes = opt1.accept(this);
            }
            break;
          case 1:
            //&1 $0 RegularExpression()
            //.. $1 [ ?0 "." ?1 < IDENTIFIER > ]
            //.. $2 [ "!" ]
            final NodeSequence seq5 = (NodeSequence) ich1;
            //$0 RegularExpression()
            final INode nd14 = seq5.elementAt(0);
            nRes = nd14.accept(this);
            //$1 [ ?0 "." ?1 < IDENTIFIER > ]
            final INode nd15 = seq5.elementAt(1);
            final NodeOptional opt2 = (NodeOptional) nd15;
            if (opt2.present()) {
              final NodeSequence seq6 = (NodeSequence) opt2.node;
              //?0 "."
              final INode nd16 = seq6.elementAt(0);
              nRes = nd16.accept(this);
              //?1 < IDENTIFIER >
              final INode nd17 = seq6.elementAt(1);
              nRes = nd17.accept(this);
            }
            //$2 [ "!" ]
            final INode nd18 = seq5.elementAt(2);
            final NodeOptional opt3 = (NodeOptional) nd18;
            if (opt3.present()) {
              nRes = opt3.accept(this);
            }
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      case 5:
        //%5 #0 "(" #1 ExpansionChoices() #2 ")"
        //.. #3 ( &0 "+"
        //.. .. | &1 "*"
        //.. .. | &2 "?" )?
        final NodeSequence seq7 = (NodeSequence) ich;
        //#0 "("
        final INode nd19 = seq7.elementAt(0);
        nRes = nd19.accept(this);
        //#1 ExpansionChoices()
        final INode nd20 = seq7.elementAt(1);
        nRes = nd20.accept(this);
        //#2 ")"
        final INode nd21 = seq7.elementAt(2);
        nRes = nd21.accept(this);
        //#3 ( &0 "+"
        //.. | &1 "*"
        //.. | &2 "?" )?
        final INode nd22 = seq7.elementAt(3);
        final NodeOptional opt4 = (NodeOptional) nd22;
        if (opt4.present()) {
          final NodeChoice nch2 = (NodeChoice) opt4.node;
          final INode ich2 = nch2.choice;
          switch (nch2.which) {
            case 0:
              //&0 "+"
              nRes = ich2.accept(this);
              break;
            case 1:
              //&1 "*"
              nRes = ich2.accept(this);
              break;
            case 2:
              //&2 "?"
              nRes = ich2.accept(this);
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch2);
          }
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ExpansionUnitTCF} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> "{"<br>
   * f2 -> ExpansionChoices()<br>
   * f3 -> "}"<br>
   * f4 -> ( #0 "catch" #1 "("<br>
   * .. .. . #2 ( Annotation() )*<br>
   * .. .. . #3 [ "final" ]<br>
   * .. .. . #4 Name() #5 < IDENTIFIER > #6 ")" #7 Block() )*<br>
   * f5 -> [ #0 "finally" #1 Block() ]<br>
   * s: 1601707097<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1601707097, JTB_SIG_EXPANSIONUNITTCF, JTB_USER_EXPANSIONUNITTCF })
  public int visit(final ExpansionUnitTCF n) {
    int nRes = 0;
    // f0 -> "try"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "{"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ExpansionChoices()
    final ExpansionChoices n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> "}"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> ( #0 "catch" #1 "("
    // .. .. . #2 ( Annotation() )*
    // .. .. . #3 [ "final" ]
    // .. .. . #4 Name() #5 < IDENTIFIER > #6 ")" #7 Block() )*
    final NodeListOptional n4 = n.f4;
    if (n4.present()) {
      for (int i = 0; i < n4.size(); i++) {
        final INode nloeai = n4.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "catch"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 "("
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 ( Annotation() )*
        final INode nd2 = seq.elementAt(2);
        final NodeListOptional nlo = (NodeListOptional) nd2;
        if (nlo.present()) {
          for (int i1 = 0; i1 < nlo.size(); i1++) {
            final INode nloeai1 = nlo.elementAt(i1);
            nRes = nloeai1.accept(this);
          }
        }
        //#3 [ "final" ]
        final INode nd3 = seq.elementAt(3);
        final NodeOptional opt = (NodeOptional) nd3;
        if (opt.present()) {
          nRes = opt.accept(this);
        }
        //#4 Name()
        final INode nd4 = seq.elementAt(4);
        nRes = nd4.accept(this);
        //#5 < IDENTIFIER >
        final INode nd5 = seq.elementAt(5);
        nRes = nd5.accept(this);
        //#6 ")"
        final INode nd6 = seq.elementAt(6);
        nRes = nd6.accept(this);
        //#7 Block()
        final INode nd7 = seq.elementAt(7);
        nRes = nd7.accept(this);
      }
    }
    // f5 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence seq1 = (NodeSequence) n5.node;
      //#0 "finally"
      final INode nd8 = seq1.elementAt(0);
      nRes = nd8.accept(this);
      //#1 Block()
      final INode nd9 = seq1.elementAt(1);
      nRes = nd9.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link RegularExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<"<br>
   * .. .. . .. #1 [ $0 [ "#" ]<br>
   * .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]<br>
   * .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"<br>
   * .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %3 #0 "<" #1 "EOF" #2 ">"<br>
   * s: 1719627151<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1719627151, JTB_SIG_REGULAREXPRESSION, JTB_USER_REGULAREXPRESSION })
  public int visit(final RegularExpression n) {
    int nRes = 0;
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<"
    // .. .. . .. #1 [ $0 [ "#" ]
    // .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]
    // .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"
    // .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %3 #0 "<" #1 "EOF" #2 ">"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 StringLiteral()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 "<"
        //.. #1 [ $0 [ "#" ]
        //.. .. . $1 IdentifierAsString() $2 ":" ]
        //.. #2 ComplexRegularExpressionChoices() #3 ">"
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "<"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 [ $0 [ "#" ]
        //.. . $1 IdentifierAsString() $2 ":" ]
        final INode nd1 = seq.elementAt(1);
        final NodeOptional opt = (NodeOptional) nd1;
        if (opt.present()) {
          final NodeSequence seq1 = (NodeSequence) opt.node;
          //$0 [ "#" ]
          final INode nd2 = seq1.elementAt(0);
          final NodeOptional opt1 = (NodeOptional) nd2;
          if (opt1.present()) {
            nRes = opt1.accept(this);
          }
          //$1 IdentifierAsString()
          final INode nd3 = seq1.elementAt(1);
          nRes = nd3.accept(this);
          //$2 ":"
          final INode nd4 = seq1.elementAt(2);
          nRes = nd4.accept(this);
        }
        //#2 ComplexRegularExpressionChoices()
        final INode nd5 = seq.elementAt(2);
        nRes = nd5.accept(this);
        //#3 ">"
        final INode nd6 = seq.elementAt(3);
        nRes = nd6.accept(this);
        break;
      case 2:
        //%2 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence seq2 = (NodeSequence) ich;
        //#0 "<"
        final INode nd7 = seq2.elementAt(0);
        nRes = nd7.accept(this);
        //#1 IdentifierAsString()
        final INode nd8 = seq2.elementAt(1);
        nRes = nd8.accept(this);
        //#2 ">"
        final INode nd9 = seq2.elementAt(2);
        nRes = nd9.accept(this);
        break;
      case 3:
        //%3 #0 "<" #1 "EOF" #2 ">"
        final NodeSequence seq3 = (NodeSequence) ich;
        //#0 "<"
        final INode nd10 = seq3.elementAt(0);
        nRes = nd10.accept(this);
        //#1 "EOF"
        final INode nd11 = seq3.elementAt(1);
        nRes = nd11.accept(this);
        //#2 ">"
        final INode nd12 = seq3.elementAt(2);
        nRes = nd12.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpressionChoices} node, whose children are the following :
   * <p>
   * f0 -> ComplexRegularExpression()<br>
   * f1 -> ( #0 "|" #1 ComplexRegularExpression() )*<br>
   * s: -1240933595<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1240933595, JTB_SIG_COMPLEXREGULAREXPRESSIONCHOICES, JTB_USER_COMPLEXREGULAREXPRESSIONCHOICES })
  public int visit(final ComplexRegularExpressionChoices n) {
    int nRes = 0;
    // f0 -> ComplexRegularExpression()
    final ComplexRegularExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "|" #1 ComplexRegularExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "|"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ComplexRegularExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpression} node, whose child is the following :
   * <p>
   * f0 -> ( ComplexRegularExpressionUnit() )+<br>
   * s: 896313544<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 896313544, JTB_SIG_COMPLEXREGULAREXPRESSION, JTB_USER_COMPLEXREGULAREXPRESSION })
  public int visit(final ComplexRegularExpression n) {
    int nRes = 0;
    // f0 -> ( ComplexRegularExpressionUnit() )+
    final NodeList n0 = n.f0;
    for (int i = 0; i < n0.size(); i++) {
      final INode lsteai = n0.elementAt(i);
      nRes = lsteai.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ComplexRegularExpressionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %2 CharacterList()<br>
   * .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?"<br>
   * .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()<br>
   * .. .. . .. .. . .. $2 [ ?0 ","<br>
   * .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]<br>
   * .. .. . .. .. . .. $3 "}" )?<br>
   * s: -1507427530<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1507427530, JTB_SIG_COMPLEXREGULAREXPRESSIONUNIT, JTB_USER_COMPLEXREGULAREXPRESSIONUNIT })
  public int visit(final ComplexRegularExpressionUnit n) {
    int nRes = 0;
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %2 CharacterList()
    // .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?"
    // .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()
    // .. .. . .. .. . .. $2 [ ?0 ","
    // .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]
    // .. .. . .. .. . .. $3 "}" )?
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 StringLiteral()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "<"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 IdentifierAsString()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 ">"
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        break;
      case 2:
        //%2 CharacterList()
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
        //.. #3 ( &0 "+"
        //.. .. | &1 "*"
        //.. .. | &2 "?"
        //.. .. | &3 $0 "{" $1 IntegerLiteral()
        //.. .. .. $2 [ ?0 ","
        //.. .. .. .. . ?1 [ IntegerLiteral() ] ]
        //.. .. .. $3 "}" )?
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "("
        final INode nd3 = seq1.elementAt(0);
        nRes = nd3.accept(this);
        //#1 ComplexRegularExpressionChoices()
        final INode nd4 = seq1.elementAt(1);
        nRes = nd4.accept(this);
        //#2 ")"
        final INode nd5 = seq1.elementAt(2);
        nRes = nd5.accept(this);
        //#3 ( &0 "+"
        //.. | &1 "*"
        //.. | &2 "?"
        //.. | &3 $0 "{" $1 IntegerLiteral()
        //.. .. $2 [ ?0 ","
        //.. .. .. . ?1 [ IntegerLiteral() ] ]
        //.. .. $3 "}" )?
        final INode nd6 = seq1.elementAt(3);
        final NodeOptional opt = (NodeOptional) nd6;
        if (opt.present()) {
          final NodeChoice nch1 = (NodeChoice) opt.node;
          final INode ich1 = nch1.choice;
          switch (nch1.which) {
            case 0:
              //&0 "+"
              nRes = ich1.accept(this);
              break;
            case 1:
              //&1 "*"
              nRes = ich1.accept(this);
              break;
            case 2:
              //&2 "?"
              nRes = ich1.accept(this);
              break;
            case 3:
              //&3 $0 "{" $1 IntegerLiteral()
              //.. $2 [ ?0 ","
              //.. .. . ?1 [ IntegerLiteral() ] ]
              //.. $3 "}"
              final NodeSequence seq2 = (NodeSequence) ich1;
              //$0 "{"
              final INode nd7 = seq2.elementAt(0);
              nRes = nd7.accept(this);
              //$1 IntegerLiteral()
              final INode nd8 = seq2.elementAt(1);
              nRes = nd8.accept(this);
              //$2 [ ?0 ","
              //.. . ?1 [ IntegerLiteral() ] ]
              final INode nd9 = seq2.elementAt(2);
              final NodeOptional opt1 = (NodeOptional) nd9;
              if (opt1.present()) {
                final NodeSequence seq3 = (NodeSequence) opt1.node;
                //?0 ","
                final INode nd10 = seq3.elementAt(0);
                nRes = nd10.accept(this);
                //?1 [ IntegerLiteral() ]
                final INode nd11 = seq3.elementAt(1);
                final NodeOptional opt2 = (NodeOptional) nd11;
                if (opt2.present()) {
                  nRes = opt2.accept(this);
                }
              }
              //$3 "}"
              final INode nd12 = seq2.elementAt(3);
              nRes = nd12.accept(this);
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch1);
          }
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link CharacterList} node, whose children are the following :
   * <p>
   * f0 -> [ "~" ]<br>
   * f1 -> "["<br>
   * f2 -> [ #0 CharacterDescriptor()<br>
   * .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]<br>
   * f3 -> "]"<br>
   * s: -966448889<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -966448889, JTB_SIG_CHARACTERLIST, JTB_USER_CHARACTERLIST })
  public int visit(final CharacterList n) {
    int nRes = 0;
    // f0 -> [ "~" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> "["
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ #0 CharacterDescriptor()
    // .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence seq = (NodeSequence) n2.node;
      //#0 CharacterDescriptor()
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 ( $0 "," $1 CharacterDescriptor() )*
      final INode nd1 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) nd1;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) nloeai;
          //$0 ","
          final INode nd2 = seq1.elementAt(0);
          nRes = nd2.accept(this);
          //$1 CharacterDescriptor()
          final INode nd3 = seq1.elementAt(1);
          nRes = nd3.accept(this);
        }
      }
    }
    // f3 -> "]"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link CharacterDescriptor} node, whose children are the following :
   * <p>
   * f0 -> StringLiteral()<br>
   * f1 -> [ #0 "-" #1 StringLiteral() ]<br>
   * s: 895087809<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 895087809, JTB_SIG_CHARACTERDESCRIPTOR, JTB_USER_CHARACTERDESCRIPTOR })
  public int visit(final CharacterDescriptor n) {
    int nRes = 0;
    // f0 -> StringLiteral()
    final StringLiteral n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "-" #1 StringLiteral() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 "-"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 StringLiteral()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link IdentifierAsString} node, whose child is the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * s: -1580059612<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1580059612, JTB_SIG_IDENTIFIERASSTRING, JTB_USER_IDENTIFIERASSTRING })
  public int visit(final IdentifierAsString n) {
    int nRes = 0;
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link JavaIdentifier} node, whose child is the following :
   * <p>
   * f0 -> ( %00 < IDENTIFIER ><br>
   * .. .. | %01 "LOOKAHEAD"<br>
   * .. .. | %02 "IGNORE_CASE"<br>
   * .. .. | %03 "PARSER_BEGIN"<br>
   * .. .. | %04 "PARSER_END"<br>
   * .. .. | %05 "JAVACODE"<br>
   * .. .. | %06 "TOKEN"<br>
   * .. .. | %07 "SPECIAL_TOKEN"<br>
   * .. .. | %08 "MORE"<br>
   * .. .. | %09 "SKIP"<br>
   * .. .. | %10 "TOKEN_MGR_DECLS"<br>
   * .. .. | %11 "EOF" )<br>
   * s: 1665786565<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1665786565, JTB_SIG_JAVAIDENTIFIER, JTB_USER_JAVAIDENTIFIER })
  public int visit(final JavaIdentifier n) {
    int nRes = 0;
    // f0 -> ( %00 < IDENTIFIER >
    // .. .. | %01 "LOOKAHEAD"
    // .. .. | %02 "IGNORE_CASE"
    // .. .. | %03 "PARSER_BEGIN"
    // .. .. | %04 "PARSER_END"
    // .. .. | %05 "JAVACODE"
    // .. .. | %06 "TOKEN"
    // .. .. | %07 "SPECIAL_TOKEN"
    // .. .. | %08 "MORE"
    // .. .. | %09 "SKIP"
    // .. .. | %10 "TOKEN_MGR_DECLS"
    // .. .. | %11 "EOF" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%00 < IDENTIFIER >
        nRes = ich.accept(this);
        break;
      case 1:
        //%01 "LOOKAHEAD"
        nRes = ich.accept(this);
        break;
      case 2:
        //%02 "IGNORE_CASE"
        nRes = ich.accept(this);
        break;
      case 3:
        //%03 "PARSER_BEGIN"
        nRes = ich.accept(this);
        break;
      case 4:
        //%04 "PARSER_END"
        nRes = ich.accept(this);
        break;
      case 5:
        //%05 "JAVACODE"
        nRes = ich.accept(this);
        break;
      case 6:
        //%06 "TOKEN"
        nRes = ich.accept(this);
        break;
      case 7:
        //%07 "SPECIAL_TOKEN"
        nRes = ich.accept(this);
        break;
      case 8:
        //%08 "MORE"
        nRes = ich.accept(this);
        break;
      case 9:
        //%09 "SKIP"
        nRes = ich.accept(this);
        break;
      case 10:
        //%10 "TOKEN_MGR_DECLS"
        nRes = ich.accept(this);
        break;
      case 11:
        //%11 "EOF"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link CompilationUnit} node, whose children are the following :
   * <p>
   * f0 -> [ PackageDeclaration() ]<br>
   * f1 -> ( ImportDeclaration() )*<br>
   * f2 -> ( TypeDeclaration() )*<br>
   * s: 1761039264<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1761039264, JTB_SIG_COMPILATIONUNIT, JTB_USER_COMPILATIONUNIT })
  public int visit(final CompilationUnit n) {
    int nRes = 0;
    // f0 -> [ PackageDeclaration() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> ( ImportDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    // f2 -> ( TypeDeclaration() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link PackageDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "package"<br>
   * f1 -> Name()<br>
   * f2 -> ";"<br>
   * s: -2133750237<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2133750237, JTB_SIG_PACKAGEDECLARATION, JTB_USER_PACKAGEDECLARATION })
  public int visit(final PackageDeclaration n) {
    int nRes = 0;
    // f0 -> "package"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ";"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ImportDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "import"<br>
   * f1 -> [ "static" ]<br>
   * f2 -> Name()<br>
   * f3 -> [ #0 "." #1 "*" ]<br>
   * f4 -> ";"<br>
   * s: -1592912780<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1592912780, JTB_SIG_IMPORTDECLARATION, JTB_USER_IMPORTDECLARATION })
  public int visit(final ImportDeclaration n) {
    int nRes = 0;
    // f0 -> "import"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ "static" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> Name()
    final Name n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ #0 "." #1 "*" ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      //#0 "."
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 "*"
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    // f4 -> ";"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Modifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %00 "public"<br>
   * .. .. . | %01 "static"<br>
   * .. .. . | %02 "protected"<br>
   * .. .. . | %03 "private"<br>
   * .. .. . | %04 "final"<br>
   * .. .. . | %05 "abstract"<br>
   * .. .. . | %06 "synchronized"<br>
   * .. .. . | %07 "native"<br>
   * .. .. . | %08 "transient"<br>
   * .. .. . | %09 "volatile"<br>
   * .. .. . | %10 "strictfp"<br>
   * .. .. . | %11 Annotation() ) )*<br>
   * s: -2047145049<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2047145049, JTB_SIG_MODIFIERS, JTB_USER_MODIFIERS })
  public int visit(final Modifiers n) {
    int nRes = 0;
    // f0 -> ( ( %00 "public"
    // .. .. . | %01 "static"
    // .. .. . | %02 "protected"
    // .. .. . | %03 "private"
    // .. .. . | %04 "final"
    // .. .. . | %05 "abstract"
    // .. .. . | %06 "synchronized"
    // .. .. . | %07 "native"
    // .. .. . | %08 "transient"
    // .. .. . | %09 "volatile"
    // .. .. . | %10 "strictfp"
    // .. .. . | %11 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode nloeai = n0.elementAt(i);
        final NodeChoice nch = (NodeChoice) nloeai;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%00 "public"
            nRes = ich.accept(this);
            break;
          case 1:
            //%01 "static"
            nRes = ich.accept(this);
            break;
          case 2:
            //%02 "protected"
            nRes = ich.accept(this);
            break;
          case 3:
            //%03 "private"
            nRes = ich.accept(this);
            break;
          case 4:
            //%04 "final"
            nRes = ich.accept(this);
            break;
          case 5:
            //%05 "abstract"
            nRes = ich.accept(this);
            break;
          case 6:
            //%06 "synchronized"
            nRes = ich.accept(this);
            break;
          case 7:
            //%07 "native"
            nRes = ich.accept(this);
            break;
          case 8:
            //%08 "transient"
            nRes = ich.accept(this);
            break;
          case 9:
            //%09 "volatile"
            nRes = ich.accept(this);
            break;
          case 10:
            //%10 "strictfp"
            nRes = ich.accept(this);
            break;
          case 11:
            //%11 Annotation()
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 ";"<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration() )<br>
   * s: -297159274<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -297159274, JTB_SIG_TYPEDECLARATION, JTB_USER_TYPEDECLARATION })
  public int visit(final TypeDeclaration n) {
    int nRes = 0;
    // f0 -> . %0 ";"
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration() )
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 ";"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 Modifiers()
        //.. #1 ( &0 ClassOrInterfaceDeclaration()
        //.. .. | &1 EnumDeclaration()
        //.. .. | &2 AnnotationTypeDeclaration() )
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Modifiers()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ( &0 ClassOrInterfaceDeclaration()
        //.. | &1 EnumDeclaration()
        //.. | &2 AnnotationTypeDeclaration() )
        final INode nd1 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) nd1;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 ClassOrInterfaceDeclaration()
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 EnumDeclaration()
            nRes = ich1.accept(this);
            break;
          case 2:
            //&2 AnnotationTypeDeclaration()
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceDeclaration} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "class"<br>
   * .. .. | %1 "interface" )<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> [ TypeParameters() ]<br>
   * f3 -> [ ExtendsList() ]<br>
   * f4 -> [ ImplementsList() ]<br>
   * f5 -> ClassOrInterfaceBody()<br>
   * s: 37426766<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 37426766, JTB_SIG_CLASSORINTERFACEDECLARATION, JTB_USER_CLASSORINTERFACEDECLARATION })
  public int visit(final ClassOrInterfaceDeclaration n) {
    int nRes = 0;
    // f0 -> ( %0 "class"
    // .. .. | %1 "interface" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 "class"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 "interface"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f1 -> < IDENTIFIER >
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ TypeParameters() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ ExtendsList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> [ ImplementsList() ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      nRes = n4.accept(this);
    }
    // f5 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n5 = n.f5;
    nRes = n5.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ExtendsList} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   * s: 24279225<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 24279225, JTB_SIG_EXTENDSLIST, JTB_USER_EXTENDSLIST })
  public int visit(final ExtendsList n) {
    int nRes = 0;
    // f0 -> "extends"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ClassOrInterfaceType()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ImplementsList} node, whose children are the following :
   * <p>
   * f0 -> "implements"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   * s: 1830366786<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1830366786, JTB_SIG_IMPLEMENTSLIST, JTB_USER_IMPLEMENTSLIST })
  public int visit(final ImplementsList n) {
    int nRes = 0;
    // f0 -> "implements"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ClassOrInterfaceType()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link EnumDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "enum"<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> [ ImplementsList() ]<br>
   * f3 -> EnumBody()<br>
   * s: 359041865<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 359041865, JTB_SIG_ENUMDECLARATION, JTB_USER_ENUMDECLARATION })
  public int visit(final EnumDeclaration n) {
    int nRes = 0;
    // f0 -> "enum"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> < IDENTIFIER >
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ ImplementsList() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> EnumBody()
    final EnumBody n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link EnumBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 EnumConstant()<br>
   * .. .. . #1 ( $0 "," $1 EnumConstant() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> [ #0 ";"<br>
   * .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]<br>
   * f4 -> "}"<br>
   * s: -1338633176<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1338633176, JTB_SIG_ENUMBODY, JTB_USER_ENUMBODY })
  public int visit(final EnumBody n) {
    int nRes = 0;
    // f0 -> "{"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 EnumConstant()
    // .. .. . #1 ( $0 "," $1 EnumConstant() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 EnumConstant()
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 ( $0 "," $1 EnumConstant() )*
      final INode nd1 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) nd1;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) nloeai;
          //$0 ","
          final INode nd2 = seq1.elementAt(0);
          nRes = nd2.accept(this);
          //$1 EnumConstant()
          final INode nd3 = seq1.elementAt(1);
          nRes = nd3.accept(this);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ #0 ";"
    // .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq2 = (NodeSequence) n3.node;
      //#0 ";"
      final INode nd4 = seq2.elementAt(0);
      nRes = nd4.accept(this);
      //#1 ( ClassOrInterfaceBodyDeclaration() )*
      final INode nd5 = seq2.elementAt(1);
      final NodeListOptional nlo1 = (NodeListOptional) nd5;
      if (nlo1.present()) {
        for (int i = 0; i < nlo1.size(); i++) {
          final INode nloeai = nlo1.elementAt(i);
          nRes = nloeai.accept(this);
        }
      }
    }
    // f4 -> "}"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link EnumConstant} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> [ Arguments() ]<br>
   * f3 -> [ ClassOrInterfaceBody() ]<br>
   * s: -8699830<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -8699830, JTB_SIG_ENUMCONSTANT, JTB_USER_ENUMCONSTANT })
  public int visit(final EnumConstant n) {
    int nRes = 0;
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> < IDENTIFIER >
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ Arguments() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> [ ClassOrInterfaceBody() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeParameters} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeParameter()<br>
   * f2 -> ( #0 "," #1 TypeParameter() )*<br>
   * f3 -> ">"<br>
   * s: 1962566888<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1962566888, JTB_SIG_TYPEPARAMETERS, JTB_USER_TYPEPARAMETERS })
  public int visit(final TypeParameters n) {
    int nRes = 0;
    // f0 -> "<"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> TypeParameter()
    final TypeParameter n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 TypeParameter() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 TypeParameter()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    // f3 -> ">"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TypeParameter} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> [ TypeBound() ]<br>
   * s: 1306471903<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1306471903, JTB_SIG_TYPEPARAMETER, JTB_USER_TYPEPARAMETER })
  public int visit(final TypeParameter n) {
    int nRes = 0;
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ TypeBound() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeBound} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*<br>
   * s: -2080520397<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2080520397, JTB_SIG_TYPEBOUND, JTB_USER_TYPEBOUND })
  public int visit(final TypeBound n) {
    int nRes = 0;
    // f0 -> "extends"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "&"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ClassOrInterfaceType()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( ClassOrInterfaceBodyDeclaration() )*<br>
   * f2 -> "}"<br>
   * s: 1154515364<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1154515364, JTB_SIG_CLASSORINTERFACEBODY, JTB_USER_CLASSORINTERFACEBODY })
  public int visit(final ClassOrInterfaceBody n) {
    int nRes = 0;
    // f0 -> "{"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( ClassOrInterfaceBodyDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    // f2 -> "}"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceBodyDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 Initializer()<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &3 ConstructorDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration()<br>
   * .. .. . .. .. | &5 MethodDeclaration() )<br>
   * .. .. | %2 ";"<br>
   * s: -1583474828<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1583474828, JTB_SIG_CLASSORINTERFACEBODYDECLARATION, JTB_USER_CLASSORINTERFACEBODYDECLARATION })
  public int visit(final ClassOrInterfaceBodyDeclaration n) {
    int nRes = 0;
    // f0 -> . %0 Initializer()
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration()
    // .. .. . .. .. | &3 ConstructorDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration()
    // .. .. . .. .. | &5 MethodDeclaration() )
    // .. .. | %2 ";"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 Initializer()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 Modifiers()
        //.. #1 ( &0 ClassOrInterfaceDeclaration()
        //.. .. | &1 EnumDeclaration()
        //.. .. | &2 AnnotationTypeDeclaration()
        //.. .. | &3 ConstructorDeclaration()
        //.. .. | &4 FieldDeclaration()
        //.. .. | &5 MethodDeclaration() )
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Modifiers()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ( &0 ClassOrInterfaceDeclaration()
        //.. | &1 EnumDeclaration()
        //.. | &2 AnnotationTypeDeclaration()
        //.. | &3 ConstructorDeclaration()
        //.. | &4 FieldDeclaration()
        //.. | &5 MethodDeclaration() )
        final INode nd1 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) nd1;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 ClassOrInterfaceDeclaration()
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 EnumDeclaration()
            nRes = ich1.accept(this);
            break;
          case 2:
            //&2 AnnotationTypeDeclaration()
            nRes = ich1.accept(this);
            break;
          case 3:
            //&3 ConstructorDeclaration()
            nRes = ich1.accept(this);
            break;
          case 4:
            //&4 FieldDeclaration()
            nRes = ich1.accept(this);
            break;
          case 5:
            //&5 MethodDeclaration()
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      case 2:
        //%2 ";"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link FieldDeclaration} node, whose children are the following :
   * <p>
   * f0 -> Type()<br>
   * f1 -> VariableDeclarator()<br>
   * f2 -> ( #0 "," #1 VariableDeclarator() )*<br>
   * f3 -> ";"<br>
   * s: 1567612384<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1567612384, JTB_SIG_FIELDDECLARATION, JTB_USER_FIELDDECLARATION })
  public int visit(final FieldDeclaration n) {
    int nRes = 0;
    // f0 -> Type()
    final Type n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> VariableDeclarator()
    final VariableDeclarator n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 VariableDeclarator()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    // f3 -> ";"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link VariableDeclarator} node, whose children are the following :
   * <p>
   * f0 -> VariableDeclaratorId()<br>
   * f1 -> [ #0 "=" #1 VariableInitializer() ]<br>
   * s: -484955779<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -484955779, JTB_SIG_VARIABLEDECLARATOR, JTB_USER_VARIABLEDECLARATOR })
  public int visit(final VariableDeclarator n) {
    int nRes = 0;
    // f0 -> VariableDeclaratorId()
    final VariableDeclaratorId n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "=" #1 VariableInitializer() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 "="
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 VariableInitializer()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link VariableDeclaratorId} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> ( #0 "[" #1 "]" )*<br>
   * s: 416704472<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 416704472, JTB_SIG_VARIABLEDECLARATORID, JTB_USER_VARIABLEDECLARATORID })
  public int visit(final VariableDeclaratorId n) {
    int nRes = 0;
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "["
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 "]"
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link VariableInitializer} node, whose child is the following :
   * <p>
   * f0 -> . %0 ArrayInitializer()<br>
   * .. .. | %1 Expression()<br>
   * s: 617286101<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 617286101, JTB_SIG_VARIABLEINITIALIZER, JTB_USER_VARIABLEINITIALIZER })
  public int visit(final VariableInitializer n) {
    int nRes = 0;
    // f0 -> . %0 ArrayInitializer()
    // .. .. | %1 Expression()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 ArrayInitializer()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Expression()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 VariableInitializer()<br>
   * .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> "}"<br>
   * s: -251326055<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -251326055, JTB_SIG_ARRAYINITIALIZER, JTB_USER_ARRAYINITIALIZER })
  public int visit(final ArrayInitializer n) {
    int nRes = 0;
    // f0 -> "{"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 VariableInitializer()
    // .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 VariableInitializer()
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 ( $0 "," $1 VariableInitializer() )*
      final INode nd1 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) nd1;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) nloeai;
          //$0 ","
          final INode nd2 = seq1.elementAt(0);
          nRes = nd2.accept(this);
          //$1 VariableInitializer()
          final INode nd3 = seq1.elementAt(1);
          nRes = nd3.accept(this);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> "}"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MethodDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> ResultType()<br>
   * f2 -> MethodDeclarator()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> ( %0 Block()<br>
   * .. .. | %1 ";" )<br>
   * s: -418256626<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -418256626, JTB_SIG_METHODDECLARATION, JTB_USER_METHODDECLARATION })
  public int visit(final MethodDeclaration n) {
    int nRes = 0;
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> MethodDeclarator()
    final MethodDeclarator n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      //#0 "throws"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 NameList()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    // f4 -> ( %0 Block()
    // .. .. | %1 ";" )
    final NodeChoice n4 = n.f4;
    final NodeChoice nch = n4;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 Block()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 ";"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link MethodDeclarator} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> FormalParameters()<br>
   * f2 -> ( #0 "[" #1 "]" )*<br>
   * s: -837793747<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -837793747, JTB_SIG_METHODDECLARATOR, JTB_USER_METHODDECLARATOR })
  public int visit(final MethodDeclarator n) {
    int nRes = 0;
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> FormalParameters()
    final FormalParameters n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "["
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 "]"
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link FormalParameters} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ #0 FormalParameter()<br>
   * .. .. . #1 ( $0 "," $1 FormalParameter() )* ]<br>
   * f2 -> ")"<br>
   * s: -97312104<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -97312104, JTB_SIG_FORMALPARAMETERS, JTB_USER_FORMALPARAMETERS })
  public int visit(final FormalParameters n) {
    int nRes = 0;
    // f0 -> "("
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 FormalParameter()
    // .. .. . #1 ( $0 "," $1 FormalParameter() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 FormalParameter()
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 ( $0 "," $1 FormalParameter() )*
      final INode nd1 = seq.elementAt(1);
      final NodeListOptional nlo = (NodeListOptional) nd1;
      if (nlo.present()) {
        for (int i = 0; i < nlo.size(); i++) {
          final INode nloeai = nlo.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) nloeai;
          //$0 ","
          final INode nd2 = seq1.elementAt(0);
          nRes = nd2.accept(this);
          //$1 FormalParameter()
          final INode nd3 = seq1.elementAt(1);
          nRes = nd3.accept(this);
        }
      }
    }
    // f2 -> ")"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link FormalParameter} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> Type()<br>
   * f2 -> [ "..." ]<br>
   * f3 -> VariableDeclaratorId()<br>
   * s: -1358852705<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1358852705, JTB_SIG_FORMALPARAMETER, JTB_USER_FORMALPARAMETER })
  public int visit(final FormalParameter n) {
    int nRes = 0;
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Type()
    final Type n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ "..." ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      nRes = n2.accept(this);
    }
    // f3 -> VariableDeclaratorId()
    final VariableDeclaratorId n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ConstructorDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> < IDENTIFIER ><br>
   * f2 -> FormalParameters()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> "{"<br>
   * f5 -> [ ExplicitConstructorInvocation() ]<br>
   * f6 -> ( BlockStatement() )*<br>
   * f7 -> "}"<br>
   * s: 1258397065<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1258397065, JTB_SIG_CONSTRUCTORDECLARATION, JTB_USER_CONSTRUCTORDECLARATION })
  public int visit(final ConstructorDeclaration n) {
    int nRes = 0;
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> < IDENTIFIER >
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> FormalParameters()
    final FormalParameters n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq = (NodeSequence) n3.node;
      //#0 "throws"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 NameList()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    // f4 -> "{"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> [ ExplicitConstructorInvocation() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      nRes = n5.accept(this);
    }
    // f6 -> ( BlockStatement() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode nloeai = n6.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    // f7 -> "}"
    final Token n7 = n.f7;
    nRes = n7.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ExplicitConstructorInvocation} node, whose child is the following :
   * <p>
   * f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()<br>
   * .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*<br>
   * .. .. . .. .. . $3 ">" ]<br>
   * .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"<br>
   * .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )<br>
   * .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )<br>
   * s: -492225557<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -492225557, JTB_SIG_EXPLICITCONSTRUCTORINVOCATION, JTB_USER_EXPLICITCONSTRUCTORINVOCATION })
  public int visit(final ExplicitConstructorInvocation n) {
    int nRes = 0;
    // f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()
    // .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*
    // .. .. . .. .. . $3 ">" ]
    // .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
    // .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )
    // .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 [ $0 "<" $1 ReferenceType()
        //.. .. . $2 ( ?0 "," ?1 ReferenceType() )*
        //.. .. . $3 ">" ]
        //.. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
        //.. .. | &1 $0 "super" $1 Arguments() $2 ";" )
        final NodeSequence seq = (NodeSequence) ich;
        //#0 [ $0 "<" $1 ReferenceType()
        //.. . $2 ( ?0 "," ?1 ReferenceType() )*
        //.. . $3 ">" ]
        final INode nd = seq.elementAt(0);
        final NodeOptional opt = (NodeOptional) nd;
        if (opt.present()) {
          final NodeSequence seq1 = (NodeSequence) opt.node;
          //$0 "<"
          final INode nd1 = seq1.elementAt(0);
          nRes = nd1.accept(this);
          //$1 ReferenceType()
          final INode nd2 = seq1.elementAt(1);
          nRes = nd2.accept(this);
          //$2 ( ?0 "," ?1 ReferenceType() )*
          final INode nd3 = seq1.elementAt(2);
          final NodeListOptional nlo = (NodeListOptional) nd3;
          if (nlo.present()) {
            for (int i = 0; i < nlo.size(); i++) {
              final INode nloeai = nlo.elementAt(i);
              final NodeSequence seq2 = (NodeSequence) nloeai;
              //?0 ","
              final INode nd4 = seq2.elementAt(0);
              nRes = nd4.accept(this);
              //?1 ReferenceType()
              final INode nd5 = seq2.elementAt(1);
              nRes = nd5.accept(this);
            }
          }
          //$3 ">"
          final INode nd6 = seq1.elementAt(3);
          nRes = nd6.accept(this);
        }
        //#1 ( &0 $0 "this" $1 Arguments() $2 ";"
        //.. | &1 $0 "super" $1 Arguments() $2 ";" )
        final INode nd7 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) nd7;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 $0 "this" $1 Arguments() $2 ";"
            final NodeSequence seq3 = (NodeSequence) ich1;
            //$0 "this"
            final INode nd8 = seq3.elementAt(0);
            nRes = nd8.accept(this);
            //$1 Arguments()
            final INode nd9 = seq3.elementAt(1);
            nRes = nd9.accept(this);
            //$2 ";"
            final INode nd10 = seq3.elementAt(2);
            nRes = nd10.accept(this);
            break;
          case 1:
            //&1 $0 "super" $1 Arguments() $2 ";"
            final NodeSequence seq4 = (NodeSequence) ich1;
            //$0 "super"
            final INode nd11 = seq4.elementAt(0);
            nRes = nd11.accept(this);
            //$1 Arguments()
            final INode nd12 = seq4.elementAt(1);
            nRes = nd12.accept(this);
            //$2 ";"
            final INode nd13 = seq4.elementAt(2);
            nRes = nd13.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      case 1:
        //%1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" )
        final NodeSequence seq5 = (NodeSequence) ich;
        //#0 PrimaryExpression()
        final INode nd14 = seq5.elementAt(0);
        nRes = nd14.accept(this);
        //#1 "."
        final INode nd15 = seq5.elementAt(1);
        nRes = nd15.accept(this);
        //#2 "super"
        final INode nd16 = seq5.elementAt(2);
        nRes = nd16.accept(this);
        //#3 Arguments()
        final INode nd17 = seq5.elementAt(3);
        nRes = nd17.accept(this);
        //#4 ";"
        final INode nd18 = seq5.elementAt(4);
        nRes = nd18.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link Initializer} node, whose children are the following :
   * <p>
   * f0 -> [ "static" ]<br>
   * f1 -> Block()<br>
   * s: -423135641<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -423135641, JTB_SIG_INITIALIZER, JTB_USER_INITIALIZER })
  public int visit(final Initializer n) {
    int nRes = 0;
    // f0 -> [ "static" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
    }
    // f1 -> Block()
    final Block n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Type} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 PrimitiveType()<br>
   * s: -1143267570<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1143267570, JTB_SIG_TYPE, JTB_USER_TYPE })
  public int visit(final Type n) {
    int nRes = 0;
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 PrimitiveType()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 ReferenceType()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 PrimitiveType()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ReferenceType} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 PrimitiveType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )+<br>
   * .. .. | %1 #0 ClassOrInterfaceType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   * s: -275468366<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -275468366, JTB_SIG_REFERENCETYPE, JTB_USER_REFERENCETYPE })
  public int visit(final ReferenceType n) {
    int nRes = 0;
    // f0 -> . %0 #0 PrimitiveType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )+
    // .. .. | %1 #0 ClassOrInterfaceType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 PrimitiveType()
        //.. #1 ( $0 "[" $1 "]" )+
        final NodeSequence seq = (NodeSequence) ich;
        //#0 PrimitiveType()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ( $0 "[" $1 "]" )+
        final INode nd1 = seq.elementAt(1);
        final NodeList lst = (NodeList) nd1;
        for (int i = 0; i < lst.size(); i++) {
          final INode lsteai = lst.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) lsteai;
          //$0 "["
          final INode nd2 = seq1.elementAt(0);
          nRes = nd2.accept(this);
          //$1 "]"
          final INode nd3 = seq1.elementAt(1);
          nRes = nd3.accept(this);
        }
        break;
      case 1:
        //%1 #0 ClassOrInterfaceType()
        //.. #1 ( $0 "[" $1 "]" )*
        final NodeSequence seq2 = (NodeSequence) ich;
        //#0 ClassOrInterfaceType()
        final INode nd4 = seq2.elementAt(0);
        nRes = nd4.accept(this);
        //#1 ( $0 "[" $1 "]" )*
        final INode nd5 = seq2.elementAt(1);
        final NodeListOptional nlo = (NodeListOptional) nd5;
        if (nlo.present()) {
          for (int i = 0; i < nlo.size(); i++) {
            final INode nloeai = nlo.elementAt(i);
            final NodeSequence seq3 = (NodeSequence) nloeai;
            //$0 "["
            final INode nd6 = seq3.elementAt(0);
            nRes = nd6.accept(this);
            //$1 "]"
            final INode nd7 = seq3.elementAt(1);
            nRes = nd7.accept(this);
          }
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ClassOrInterfaceType} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> [ TypeArguments() ]<br>
   * f2 -> ( #0 "." #1 < IDENTIFIER ><br>
   * .. .. . #2 [ TypeArguments() ] )*<br>
   * s: -1178309727<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1178309727, JTB_SIG_CLASSORINTERFACETYPE, JTB_USER_CLASSORINTERFACETYPE })
  public int visit(final ClassOrInterfaceType n) {
    int nRes = 0;
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ TypeArguments() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ( #0 "." #1 < IDENTIFIER >
    // .. .. . #2 [ TypeArguments() ] )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "."
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 < IDENTIFIER >
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 [ TypeArguments() ]
        final INode nd2 = seq.elementAt(2);
        final NodeOptional opt = (NodeOptional) nd2;
        if (opt.present()) {
          nRes = opt.accept(this);
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link TypeArguments} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeArgument()<br>
   * f2 -> ( #0 "," #1 TypeArgument() )*<br>
   * f3 -> ">"<br>
   * s: 131755052<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 131755052, JTB_SIG_TYPEARGUMENTS, JTB_USER_TYPEARGUMENTS })
  public int visit(final TypeArguments n) {
    int nRes = 0;
    // f0 -> "<"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> TypeArgument()
    final TypeArgument n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 TypeArgument() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 TypeArgument()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    // f3 -> ">"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link EmptyTypeArguments} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> ">"<br>
   * s: 859421181<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 859421181, JTB_SIG_EMPTYTYPEARGUMENTS, JTB_USER_EMPTYTYPEARGUMENTS })
  public int visit(final EmptyTypeArguments n) {
    int nRes = 0;
    // f0 -> "<"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ">"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TypeArgument} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 #0 "?"<br>
   * .. .. . .. #1 [ WildcardBounds() ]<br>
   * s: 36461692<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 36461692, JTB_SIG_TYPEARGUMENT, JTB_USER_TYPEARGUMENT })
  public int visit(final TypeArgument n) {
    int nRes = 0;
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 #0 "?"
    // .. .. . .. #1 [ WildcardBounds() ]
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 ReferenceType()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 "?"
        //.. #1 [ WildcardBounds() ]
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "?"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 [ WildcardBounds() ]
        final INode nd1 = seq.elementAt(1);
        final NodeOptional opt = (NodeOptional) nd1;
        if (opt.present()) {
          nRes = opt.accept(this);
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link WildcardBounds} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "extends" #1 ReferenceType()<br>
   * .. .. | %1 #0 "super" #1 ReferenceType()<br>
   * s: 122808000<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 122808000, JTB_SIG_WILDCARDBOUNDS, JTB_USER_WILDCARDBOUNDS })
  public int visit(final WildcardBounds n) {
    int nRes = 0;
    // f0 -> . %0 #0 "extends" #1 ReferenceType()
    // .. .. | %1 #0 "super" #1 ReferenceType()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "extends" #1 ReferenceType()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "extends"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ReferenceType()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 #0 "super" #1 ReferenceType()
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "super"
        final INode nd2 = seq1.elementAt(0);
        nRes = nd2.accept(this);
        //#1 ReferenceType()
        final INode nd3 = seq1.elementAt(1);
        nRes = nd3.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link PrimitiveType} node, whose child is the following :
   * <p>
   * f0 -> . %0 "boolean"<br>
   * .. .. | %1 "char"<br>
   * .. .. | %2 "byte"<br>
   * .. .. | %3 "short"<br>
   * .. .. | %4 "int"<br>
   * .. .. | %5 "long"<br>
   * .. .. | %6 "float"<br>
   * .. .. | %7 "double"<br>
   * s: 427914477<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 427914477, JTB_SIG_PRIMITIVETYPE, JTB_USER_PRIMITIVETYPE })
  public int visit(final PrimitiveType n) {
    int nRes = 0;
    // f0 -> . %0 "boolean"
    // .. .. | %1 "char"
    // .. .. | %2 "byte"
    // .. .. | %3 "short"
    // .. .. | %4 "int"
    // .. .. | %5 "long"
    // .. .. | %6 "float"
    // .. .. | %7 "double"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 "boolean"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 "char"
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 "byte"
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 "short"
        nRes = ich.accept(this);
        break;
      case 4:
        //%4 "int"
        nRes = ich.accept(this);
        break;
      case 5:
        //%5 "long"
        nRes = ich.accept(this);
        break;
      case 6:
        //%6 "float"
        nRes = ich.accept(this);
        break;
      case 7:
        //%7 "double"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ResultType} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "void"<br>
   * .. .. | %1 Type() )<br>
   * s: 805291204<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 805291204, JTB_SIG_RESULTTYPE, JTB_USER_RESULTTYPE })
  public int visit(final ResultType n) {
    int nRes = 0;
    // f0 -> ( %0 "void"
    // .. .. | %1 Type() )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 "void"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Type()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link Name} node, whose children are the following :
   * <p>
   * f0 -> JavaIdentifier()<br>
   * f1 -> ( #0 "." #1 JavaIdentifier() )*<br>
   * s: 565597065<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 565597065, JTB_SIG_NAME, JTB_USER_NAME })
  public int visit(final Name n) {
    int nRes = 0;
    // f0 -> JavaIdentifier()
    final JavaIdentifier n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "." #1 JavaIdentifier() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "."
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 JavaIdentifier()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link NameList} node, whose children are the following :
   * <p>
   * f0 -> Name()<br>
   * f1 -> ( #0 "," #1 Name() )*<br>
   * s: -1147957113<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1147957113, JTB_SIG_NAMELIST, JTB_USER_NAMELIST })
  public int visit(final NameList n) {
    int nRes = 0;
    // f0 -> Name()
    final Name n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 Name() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 Name()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link Expression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalExpression()<br>
   * f1 -> [ #0 AssignmentOperator() #1 Expression() ]<br>
   * s: -1186270200<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1186270200, JTB_SIG_EXPRESSION, JTB_USER_EXPRESSION })
  public int visit(final Expression n) {
    int nRes = 0;
    // f0 -> ConditionalExpression()
    final ConditionalExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 AssignmentOperator() #1 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 AssignmentOperator()
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 Expression()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link AssignmentOperator} node, whose child is the following :
   * <p>
   * f0 -> . %00 "="<br>
   * .. .. | %01 "*="<br>
   * .. .. | %02 "/="<br>
   * .. .. | %03 "%="<br>
   * .. .. | %04 "+="<br>
   * .. .. | %05 "-="<br>
   * .. .. | %06 "<<="<br>
   * .. .. | %07 ">>="<br>
   * .. .. | %08 ">>>="<br>
   * .. .. | %09 "&="<br>
   * .. .. | %10 "^="<br>
   * .. .. | %11 "|="<br>
   * s: 21393769<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 21393769, JTB_SIG_ASSIGNMENTOPERATOR, JTB_USER_ASSIGNMENTOPERATOR })
  public int visit(final AssignmentOperator n) {
    int nRes = 0;
    // f0 -> . %00 "="
    // .. .. | %01 "*="
    // .. .. | %02 "/="
    // .. .. | %03 "%="
    // .. .. | %04 "+="
    // .. .. | %05 "-="
    // .. .. | %06 "<<="
    // .. .. | %07 ">>="
    // .. .. | %08 ">>>="
    // .. .. | %09 "&="
    // .. .. | %10 "^="
    // .. .. | %11 "|="
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%00 "="
        nRes = ich.accept(this);
        break;
      case 1:
        //%01 "*="
        nRes = ich.accept(this);
        break;
      case 2:
        //%02 "/="
        nRes = ich.accept(this);
        break;
      case 3:
        //%03 "%="
        nRes = ich.accept(this);
        break;
      case 4:
        //%04 "+="
        nRes = ich.accept(this);
        break;
      case 5:
        //%05 "-="
        nRes = ich.accept(this);
        break;
      case 6:
        //%06 "<<="
        nRes = ich.accept(this);
        break;
      case 7:
        //%07 ">>="
        nRes = ich.accept(this);
        break;
      case 8:
        //%08 ">>>="
        nRes = ich.accept(this);
        break;
      case 9:
        //%09 "&="
        nRes = ich.accept(this);
        break;
      case 10:
        //%10 "^="
        nRes = ich.accept(this);
        break;
      case 11:
        //%11 "|="
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ConditionalExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalOrExpression()<br>
   * f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]<br>
   * s: -1150694214<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1150694214, JTB_SIG_CONDITIONALEXPRESSION, JTB_USER_CONDITIONALEXPRESSION })
  public int visit(final ConditionalExpression n) {
    int nRes = 0;
    // f0 -> ConditionalOrExpression()
    final ConditionalOrExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 "?"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 Expression()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
      //#2 ":"
      final INode nd2 = seq.elementAt(2);
      nRes = nd2.accept(this);
      //#3 Expression()
      final INode nd3 = seq.elementAt(3);
      nRes = nd3.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link ConditionalOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalAndExpression()<br>
   * f1 -> ( #0 "||" #1 ConditionalAndExpression() )*<br>
   * s: -1592298777<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1592298777, JTB_SIG_CONDITIONALOREXPRESSION, JTB_USER_CONDITIONALOREXPRESSION })
  public int visit(final ConditionalOrExpression n) {
    int nRes = 0;
    // f0 -> ConditionalAndExpression()
    final ConditionalAndExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "||" #1 ConditionalAndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "||"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ConditionalAndExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ConditionalAndExpression} node, whose children are the following :
   * <p>
   * f0 -> InclusiveOrExpression()<br>
   * f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*<br>
   * s: -1425815203<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1425815203, JTB_SIG_CONDITIONALANDEXPRESSION, JTB_USER_CONDITIONALANDEXPRESSION })
  public int visit(final ConditionalAndExpression n) {
    int nRes = 0;
    // f0 -> InclusiveOrExpression()
    final InclusiveOrExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "&&"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 InclusiveOrExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link InclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ExclusiveOrExpression()<br>
   * f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*<br>
   * s: 963402497<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 963402497, JTB_SIG_INCLUSIVEOREXPRESSION, JTB_USER_INCLUSIVEOREXPRESSION })
  public int visit(final InclusiveOrExpression n) {
    int nRes = 0;
    // f0 -> ExclusiveOrExpression()
    final ExclusiveOrExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "|"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ExclusiveOrExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ExclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> AndExpression()<br>
   * f1 -> ( #0 "^" #1 AndExpression() )*<br>
   * s: -1241708769<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1241708769, JTB_SIG_EXCLUSIVEOREXPRESSION, JTB_USER_EXCLUSIVEOREXPRESSION })
  public int visit(final ExclusiveOrExpression n) {
    int nRes = 0;
    // f0 -> AndExpression()
    final AndExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "^" #1 AndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "^"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 AndExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link AndExpression} node, whose children are the following :
   * <p>
   * f0 -> EqualityExpression()<br>
   * f1 -> ( #0 "&" #1 EqualityExpression() )*<br>
   * s: -629554573<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -629554573, JTB_SIG_ANDEXPRESSION, JTB_USER_ANDEXPRESSION })
  public int visit(final AndExpression n) {
    int nRes = 0;
    // f0 -> EqualityExpression()
    final EqualityExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "&" #1 EqualityExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "&"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 EqualityExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link EqualityExpression} node, whose children are the following :
   * <p>
   * f0 -> InstanceOfExpression()<br>
   * f1 -> ( #0 ( %0 "=="<br>
   * .. .. . .. | %1 "!=" )<br>
   * .. .. . #1 InstanceOfExpression() )*<br>
   * s: 1053085061<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1053085061, JTB_SIG_EQUALITYEXPRESSION, JTB_USER_EQUALITYEXPRESSION })
  public int visit(final EqualityExpression n) {
    int nRes = 0;
    // f0 -> InstanceOfExpression()
    final InstanceOfExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "=="
    // .. .. . .. | %1 "!=" )
    // .. .. . #1 InstanceOfExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ( %0 "=="
        //.. | %1 "!=" )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) nd;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 "=="
            nRes = ich.accept(this);
            break;
          case 1:
            //%1 "!="
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
        //#1 InstanceOfExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link InstanceOfExpression} node, whose children are the following :
   * <p>
   * f0 -> RelationalExpression()<br>
   * f1 -> [ #0 "instanceof" #1 Type() ]<br>
   * s: 933354553<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 933354553, JTB_SIG_INSTANCEOFEXPRESSION, JTB_USER_INSTANCEOFEXPRESSION })
  public int visit(final InstanceOfExpression n) {
    int nRes = 0;
    // f0 -> RelationalExpression()
    final RelationalExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ #0 "instanceof" #1 Type() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence seq = (NodeSequence) n1.node;
      //#0 "instanceof"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 Type()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link RelationalExpression} node, whose children are the following :
   * <p>
   * f0 -> ShiftExpression()<br>
   * f1 -> ( #0 ( %0 "<"<br>
   * .. .. . .. | %1 ">"<br>
   * .. .. . .. | %2 "<="<br>
   * .. .. . .. | %3 ">=" )<br>
   * .. .. . #1 ShiftExpression() )*<br>
   * s: 1473482530<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1473482530, JTB_SIG_RELATIONALEXPRESSION, JTB_USER_RELATIONALEXPRESSION })
  public int visit(final RelationalExpression n) {
    int nRes = 0;
    // f0 -> ShiftExpression()
    final ShiftExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "<"
    // .. .. . .. | %1 ">"
    // .. .. . .. | %2 "<="
    // .. .. . .. | %3 ">=" )
    // .. .. . #1 ShiftExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ( %0 "<"
        //.. | %1 ">"
        //.. | %2 "<="
        //.. | %3 ">=" )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) nd;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 "<"
            nRes = ich.accept(this);
            break;
          case 1:
            //%1 ">"
            nRes = ich.accept(this);
            break;
          case 2:
            //%2 "<="
            nRes = ich.accept(this);
            break;
          case 3:
            //%3 ">="
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
        //#1 ShiftExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ShiftExpression} node, whose children are the following :
   * <p>
   * f0 -> AdditiveExpression()<br>
   * f1 -> ( #0 ( %0 "<<"<br>
   * .. .. . .. | %1 RUnsignedShift()<br>
   * .. .. . .. | %2 RSignedShift() )<br>
   * .. .. . #1 AdditiveExpression() )*<br>
   * s: 1210478291<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1210478291, JTB_SIG_SHIFTEXPRESSION, JTB_USER_SHIFTEXPRESSION })
  public int visit(final ShiftExpression n) {
    int nRes = 0;
    // f0 -> AdditiveExpression()
    final AdditiveExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "<<"
    // .. .. . .. | %1 RUnsignedShift()
    // .. .. . .. | %2 RSignedShift() )
    // .. .. . #1 AdditiveExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ( %0 "<<"
        //.. | %1 RUnsignedShift()
        //.. | %2 RSignedShift() )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) nd;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 "<<"
            nRes = ich.accept(this);
            break;
          case 1:
            //%1 RUnsignedShift()
            nRes = ich.accept(this);
            break;
          case 2:
            //%2 RSignedShift()
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
        //#1 AdditiveExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link RSignedShift} node, whose children are the following :
   * <p>
   * f0 -> ">"<br>
   * f1 -> ">"<br>
   * s: 1560485759<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1560485759, JTB_SIG_RSIGNEDSHIFT, JTB_USER_RSIGNEDSHIFT })
  public int visit(final RSignedShift n) {
    int nRes = 0;
    // f0 -> ">"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ">"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link RUnsignedShift} node, whose children are the following :
   * <p>
   * f0 -> ">"<br>
   * f1 -> ">"<br>
   * f2 -> ">"<br>
   * s: -171434548<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -171434548, JTB_SIG_RUNSIGNEDSHIFT, JTB_USER_RUNSIGNEDSHIFT })
  public int visit(final RUnsignedShift n) {
    int nRes = 0;
    // f0 -> ">"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ">"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ">"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AdditiveExpression} node, whose children are the following :
   * <p>
   * f0 -> MultiplicativeExpression()<br>
   * f1 -> ( #0 ( %0 "+"<br>
   * .. .. . .. | %1 "-" )<br>
   * .. .. . #1 MultiplicativeExpression() )*<br>
   * s: -1807059397<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1807059397, JTB_SIG_ADDITIVEEXPRESSION, JTB_USER_ADDITIVEEXPRESSION })
  public int visit(final AdditiveExpression n) {
    int nRes = 0;
    // f0 -> MultiplicativeExpression()
    final MultiplicativeExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "+"
    // .. .. . .. | %1 "-" )
    // .. .. . #1 MultiplicativeExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ( %0 "+"
        //.. | %1 "-" )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) nd;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 "+"
            nRes = ich.accept(this);
            break;
          case 1:
            //%1 "-"
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
        //#1 MultiplicativeExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link MultiplicativeExpression} node, whose children are the following :
   * <p>
   * f0 -> UnaryExpression()<br>
   * f1 -> ( #0 ( %0 "*"<br>
   * .. .. . .. | %1 "/"<br>
   * .. .. . .. | %2 "%" )<br>
   * .. .. . #1 UnaryExpression() )*<br>
   * s: 853643830<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 853643830, JTB_SIG_MULTIPLICATIVEEXPRESSION, JTB_USER_MULTIPLICATIVEEXPRESSION })
  public int visit(final MultiplicativeExpression n) {
    int nRes = 0;
    // f0 -> UnaryExpression()
    final UnaryExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 ( %0 "*"
    // .. .. . .. | %1 "/"
    // .. .. . .. | %2 "%" )
    // .. .. . #1 UnaryExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ( %0 "*"
        //.. | %1 "/"
        //.. | %2 "%" )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch = (NodeChoice) nd;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 "*"
            nRes = ich.accept(this);
            break;
          case 1:
            //%1 "/"
            nRes = ich.accept(this);
            break;
          case 2:
            //%2 "%"
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
        //#1 UnaryExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link UnaryExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "+"<br>
   * .. .. . .. .. | &1 "-" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 PreIncrementExpression()<br>
   * .. .. | %2 PreDecrementExpression()<br>
   * .. .. | %3 UnaryExpressionNotPlusMinus()<br>
   * s: 256050335<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 256050335, JTB_SIG_UNARYEXPRESSION, JTB_USER_UNARYEXPRESSION })
  public int visit(final UnaryExpression n) {
    int nRes = 0;
    // f0 -> . %0 #0 ( &0 "+"
    // .. .. . .. .. | &1 "-" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 PreIncrementExpression()
    // .. .. | %2 PreDecrementExpression()
    // .. .. | %3 UnaryExpressionNotPlusMinus()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 ( &0 "+"
        //.. .. | &1 "-" )
        //.. #1 UnaryExpression()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 ( &0 "+"
        //.. | &1 "-" )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch1 = (NodeChoice) nd;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 "+"
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 "-"
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        //#1 UnaryExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 PreIncrementExpression()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 PreDecrementExpression()
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 UnaryExpressionNotPlusMinus()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link PreIncrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "++"<br>
   * f1 -> PrimaryExpression()<br>
   * s: 2138182184<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2138182184, JTB_SIG_PREINCREMENTEXPRESSION, JTB_USER_PREINCREMENTEXPRESSION })
  public int visit(final PreIncrementExpression n) {
    int nRes = 0;
    // f0 -> "++"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link PreDecrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "--"<br>
   * f1 -> PrimaryExpression()<br>
   * s: -743030168<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -743030168, JTB_SIG_PREDECREMENTEXPRESSION, JTB_USER_PREDECREMENTEXPRESSION })
  public int visit(final PreDecrementExpression n) {
    int nRes = 0;
    // f0 -> "--"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link UnaryExpressionNotPlusMinus} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 CastExpression()<br>
   * .. .. | %2 PostfixExpression()<br>
   * s: -323186655<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -323186655, JTB_SIG_UNARYEXPRESSIONNOTPLUSMINUS, JTB_USER_UNARYEXPRESSIONNOTPLUSMINUS })
  public int visit(final UnaryExpressionNotPlusMinus n) {
    int nRes = 0;
    // f0 -> . %0 #0 ( &0 "~"
    // .. .. . .. .. | &1 "!" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 CastExpression()
    // .. .. | %2 PostfixExpression()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 ( &0 "~"
        //.. .. | &1 "!" )
        //.. #1 UnaryExpression()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 ( &0 "~"
        //.. | &1 "!" )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch1 = (NodeChoice) nd;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 "~"
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 "!"
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        //#1 UnaryExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 CastExpression()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 PostfixExpression()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link CastLookahead} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 PrimitiveType()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"<br>
   * .. .. | %2 #0 "(" #1 Type() #2 ")"<br>
   * .. .. . .. #3 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!"<br>
   * .. .. . .. .. | &2 "("<br>
   * .. .. . .. .. | &3 < IDENTIFIER ><br>
   * .. .. . .. .. | &4 "this"<br>
   * .. .. . .. .. | &5 "super"<br>
   * .. .. . .. .. | &6 "new"<br>
   * .. .. . .. .. | &7 Literal() )<br>
   * s: 611584359<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 611584359, JTB_SIG_CASTLOOKAHEAD, JTB_USER_CASTLOOKAHEAD })
  public int visit(final CastLookahead n) {
    int nRes = 0;
    // f0 -> . %0 #0 "(" #1 PrimitiveType()
    // .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"
    // .. .. | %2 #0 "(" #1 Type() #2 ")"
    // .. .. . .. #3 ( &0 "~"
    // .. .. . .. .. | &1 "!"
    // .. .. . .. .. | &2 "("
    // .. .. . .. .. | &3 < IDENTIFIER >
    // .. .. . .. .. | &4 "this"
    // .. .. . .. .. | &5 "super"
    // .. .. . .. .. | &6 "new"
    // .. .. . .. .. | &7 Literal() )
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "(" #1 PrimitiveType()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "("
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 PrimitiveType()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 #0 "(" #1 Type() #2 "[" #3 "]"
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "("
        final INode nd2 = seq1.elementAt(0);
        nRes = nd2.accept(this);
        //#1 Type()
        final INode nd3 = seq1.elementAt(1);
        nRes = nd3.accept(this);
        //#2 "["
        final INode nd4 = seq1.elementAt(2);
        nRes = nd4.accept(this);
        //#3 "]"
        final INode nd5 = seq1.elementAt(3);
        nRes = nd5.accept(this);
        break;
      case 2:
        //%2 #0 "(" #1 Type() #2 ")"
        //.. #3 ( &0 "~"
        //.. .. | &1 "!"
        //.. .. | &2 "("
        //.. .. | &3 < IDENTIFIER >
        //.. .. | &4 "this"
        //.. .. | &5 "super"
        //.. .. | &6 "new"
        //.. .. | &7 Literal() )
        final NodeSequence seq2 = (NodeSequence) ich;
        //#0 "("
        final INode nd6 = seq2.elementAt(0);
        nRes = nd6.accept(this);
        //#1 Type()
        final INode nd7 = seq2.elementAt(1);
        nRes = nd7.accept(this);
        //#2 ")"
        final INode nd8 = seq2.elementAt(2);
        nRes = nd8.accept(this);
        //#3 ( &0 "~"
        //.. | &1 "!"
        //.. | &2 "("
        //.. | &3 < IDENTIFIER >
        //.. | &4 "this"
        //.. | &5 "super"
        //.. | &6 "new"
        //.. | &7 Literal() )
        final INode nd9 = seq2.elementAt(3);
        final NodeChoice nch1 = (NodeChoice) nd9;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 "~"
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 "!"
            nRes = ich1.accept(this);
            break;
          case 2:
            //&2 "("
            nRes = ich1.accept(this);
            break;
          case 3:
            //&3 < IDENTIFIER >
            nRes = ich1.accept(this);
            break;
          case 4:
            //&4 "this"
            nRes = ich1.accept(this);
            break;
          case 5:
            //&5 "super"
            nRes = ich1.accept(this);
            break;
          case 6:
            //&6 "new"
            nRes = ich1.accept(this);
            break;
          case 7:
            //&7 Literal()
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link PostfixExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryExpression()<br>
   * f1 -> [ %0 "++"<br>
   * .. .. | %1 "--" ]<br>
   * s: -141317959<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -141317959, JTB_SIG_POSTFIXEXPRESSION, JTB_USER_POSTFIXEXPRESSION })
  public int visit(final PostfixExpression n) {
    int nRes = 0;
    // f0 -> PrimaryExpression()
    final PrimaryExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ %0 "++"
    // .. .. | %1 "--" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeChoice nch = (NodeChoice) n1.node;
      final INode ich = nch.choice;
      switch (nch.which) {
        case 0:
          //%0 "++"
          nRes = ich.accept(this);
          break;
        case 1:
          //%1 "--"
          nRes = ich.accept(this);
          break;
        default:
          // should not occur !!!
          throw new ShouldNotOccurException(nch);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link CastExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()<br>
   * s: -326666679<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -326666679, JTB_SIG_CASTEXPRESSION, JTB_USER_CASTEXPRESSION })
  public int visit(final CastExpression n) {
    int nRes = 0;
    // f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
    // .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "("
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 Type()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 ")"
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        //#3 UnaryExpression()
        final INode nd3 = seq.elementAt(3);
        nRes = nd3.accept(this);
        break;
      case 1:
        //%1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "("
        final INode nd4 = seq1.elementAt(0);
        nRes = nd4.accept(this);
        //#1 Type()
        final INode nd5 = seq1.elementAt(1);
        nRes = nd5.accept(this);
        //#2 ")"
        final INode nd6 = seq1.elementAt(2);
        nRes = nd6.accept(this);
        //#3 UnaryExpressionNotPlusMinus()
        final INode nd7 = seq1.elementAt(3);
        nRes = nd7.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link PrimaryExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryPrefix()<br>
   * f1 -> ( PrimarySuffix() )*<br>
   * s: -840041189<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -840041189, JTB_SIG_PRIMARYEXPRESSION, JTB_USER_PRIMARYEXPRESSION })
  public int visit(final PrimaryExpression n) {
    int nRes = 0;
    // f0 -> PrimaryPrefix()
    final PrimaryPrefix n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( PrimarySuffix() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link MemberSelector} node, whose children are the following :
   * <p>
   * f0 -> "."<br>
   * f1 -> TypeArguments()<br>
   * f2 -> < IDENTIFIER ><br>
   * s: 257570924<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 257570924, JTB_SIG_MEMBERSELECTOR, JTB_USER_MEMBERSELECTOR })
  public int visit(final MemberSelector n) {
    int nRes = 0;
    // f0 -> "."
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> TypeArguments()
    final TypeArguments n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> < IDENTIFIER >
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link PrimaryPrefix} node, whose child is the following :
   * <p>
   * f0 -> . %0 Literal()<br>
   * .. .. | %1 "this"<br>
   * .. .. | %2 #0 "super" #1 "." #2 < IDENTIFIER ><br>
   * .. .. | %3 #0 "(" #1 Expression() #2 ")"<br>
   * .. .. | %4 AllocationExpression()<br>
   * .. .. | %5 #0 ResultType() #1 "." #2 "class"<br>
   * .. .. | %6 Name()<br>
   * s: -1251837238<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1251837238, JTB_SIG_PRIMARYPREFIX, JTB_USER_PRIMARYPREFIX })
  public int visit(final PrimaryPrefix n) {
    int nRes = 0;
    // f0 -> . %0 Literal()
    // .. .. | %1 "this"
    // .. .. | %2 #0 "super" #1 "." #2 < IDENTIFIER >
    // .. .. | %3 #0 "(" #1 Expression() #2 ")"
    // .. .. | %4 AllocationExpression()
    // .. .. | %5 #0 ResultType() #1 "." #2 "class"
    // .. .. | %6 Name()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 Literal()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 "this"
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 #0 "super" #1 "." #2 < IDENTIFIER >
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "super"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 "."
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 < IDENTIFIER >
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        break;
      case 3:
        //%3 #0 "(" #1 Expression() #2 ")"
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "("
        final INode nd3 = seq1.elementAt(0);
        nRes = nd3.accept(this);
        //#1 Expression()
        final INode nd4 = seq1.elementAt(1);
        nRes = nd4.accept(this);
        //#2 ")"
        final INode nd5 = seq1.elementAt(2);
        nRes = nd5.accept(this);
        break;
      case 4:
        //%4 AllocationExpression()
        nRes = ich.accept(this);
        break;
      case 5:
        //%5 #0 ResultType() #1 "." #2 "class"
        final NodeSequence seq2 = (NodeSequence) ich;
        //#0 ResultType()
        final INode nd6 = seq2.elementAt(0);
        nRes = nd6.accept(this);
        //#1 "."
        final INode nd7 = seq2.elementAt(1);
        nRes = nd7.accept(this);
        //#2 "class"
        final INode nd8 = seq2.elementAt(2);
        nRes = nd8.accept(this);
        break;
      case 6:
        //%6 Name()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link PrimarySuffix} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "." #1 "this"<br>
   * .. .. | %1 #0 "." #1 AllocationExpression()<br>
   * .. .. | %2 MemberSelector()<br>
   * .. .. | %3 #0 "[" #1 Expression() #2 "]"<br>
   * .. .. | %4 #0 "." #1 < IDENTIFIER ><br>
   * .. .. | %5 Arguments()<br>
   * s: -1259210971<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1259210971, JTB_SIG_PRIMARYSUFFIX, JTB_USER_PRIMARYSUFFIX })
  public int visit(final PrimarySuffix n) {
    int nRes = 0;
    // f0 -> . %0 #0 "." #1 "this"
    // .. .. | %1 #0 "." #1 AllocationExpression()
    // .. .. | %2 MemberSelector()
    // .. .. | %3 #0 "[" #1 Expression() #2 "]"
    // .. .. | %4 #0 "." #1 < IDENTIFIER >
    // .. .. | %5 Arguments()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "." #1 "this"
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "."
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 "this"
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 #0 "." #1 AllocationExpression()
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "."
        final INode nd2 = seq1.elementAt(0);
        nRes = nd2.accept(this);
        //#1 AllocationExpression()
        final INode nd3 = seq1.elementAt(1);
        nRes = nd3.accept(this);
        break;
      case 2:
        //%2 MemberSelector()
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 #0 "[" #1 Expression() #2 "]"
        final NodeSequence seq2 = (NodeSequence) ich;
        //#0 "["
        final INode nd4 = seq2.elementAt(0);
        nRes = nd4.accept(this);
        //#1 Expression()
        final INode nd5 = seq2.elementAt(1);
        nRes = nd5.accept(this);
        //#2 "]"
        final INode nd6 = seq2.elementAt(2);
        nRes = nd6.accept(this);
        break;
      case 4:
        //%4 #0 "." #1 < IDENTIFIER >
        final NodeSequence seq3 = (NodeSequence) ich;
        //#0 "."
        final INode nd7 = seq3.elementAt(0);
        nRes = nd7.accept(this);
        //#1 < IDENTIFIER >
        final INode nd8 = seq3.elementAt(1);
        nRes = nd8.accept(this);
        break;
      case 5:
        //%5 Arguments()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link Literal} node, whose child is the following :
   * <p>
   * f0 -> . %0 < INTEGER_LITERAL ><br>
   * .. .. | %1 < FLOATING_POINT_LITERAL ><br>
   * .. .. | %2 < CHARACTER_LITERAL ><br>
   * .. .. | %3 < STRING_LITERAL ><br>
   * .. .. | %4 BooleanLiteral()<br>
   * .. .. | %5 NullLiteral()<br>
   * s: 454259936<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 454259936, JTB_SIG_LITERAL, JTB_USER_LITERAL })
  public int visit(final Literal n) {
    int nRes = 0;
    // f0 -> . %0 < INTEGER_LITERAL >
    // .. .. | %1 < FLOATING_POINT_LITERAL >
    // .. .. | %2 < CHARACTER_LITERAL >
    // .. .. | %3 < STRING_LITERAL >
    // .. .. | %4 BooleanLiteral()
    // .. .. | %5 NullLiteral()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < INTEGER_LITERAL >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 < FLOATING_POINT_LITERAL >
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 < CHARACTER_LITERAL >
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 < STRING_LITERAL >
        nRes = ich.accept(this);
        break;
      case 4:
        //%4 BooleanLiteral()
        nRes = ich.accept(this);
        break;
      case 5:
        //%5 NullLiteral()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link IntegerLiteral} node, whose child is the following :
   * <p>
   * f0 -> < INTEGER_LITERAL ><br>
   * s: -1048223857<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1048223857, JTB_SIG_INTEGERLITERAL, JTB_USER_INTEGERLITERAL })
  public int visit(final IntegerLiteral n) {
    int nRes = 0;
    // f0 -> < INTEGER_LITERAL >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BooleanLiteral} node, whose child is the following :
   * <p>
   * f0 -> . %0 "true"<br>
   * .. .. | %1 "false"<br>
   * s: -1365265107<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1365265107, JTB_SIG_BOOLEANLITERAL, JTB_USER_BOOLEANLITERAL })
  public int visit(final BooleanLiteral n) {
    int nRes = 0;
    // f0 -> . %0 "true"
    // .. .. | %1 "false"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 "true"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 "false"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link StringLiteral} node, whose child is the following :
   * <p>
   * f0 -> < STRING_LITERAL ><br>
   * s: 241433948<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 241433948, JTB_SIG_STRINGLITERAL, JTB_USER_STRINGLITERAL })
  public int visit(final StringLiteral n) {
    int nRes = 0;
    // f0 -> < STRING_LITERAL >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link NullLiteral} node, whose child is the following :
   * <p>
   * f0 -> "null"<br>
   * s: -1703344686<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1703344686, JTB_SIG_NULLLITERAL, JTB_USER_NULLLITERAL })
  public int visit(final NullLiteral n) {
    int nRes = 0;
    // f0 -> "null"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Arguments} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ ArgumentList() ]<br>
   * f2 -> ")"<br>
   * s: 2046130821<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2046130821, JTB_SIG_ARGUMENTS, JTB_USER_ARGUMENTS })
  public int visit(final Arguments n) {
    int nRes = 0;
    // f0 -> "("
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ ArgumentList() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ")"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ArgumentList} node, whose children are the following :
   * <p>
   * f0 -> Expression()<br>
   * f1 -> ( #0 "," #1 Expression() )*<br>
   * s: -662366547<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -662366547, JTB_SIG_ARGUMENTLIST, JTB_USER_ARGUMENTLIST })
  public int visit(final ArgumentList n) {
    int nRes = 0;
    // f0 -> Expression()
    final Expression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 Expression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 Expression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link AllocationExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()<br>
   * .. .. | %1 #0 "new" #1 ClassOrInterfaceType()<br>
   * .. .. . .. #2 [ &0 EmptyTypeArguments()<br>
   * .. .. . .. .. | &1 TypeArguments() ]<br>
   * .. .. . .. #3 ( &0 ArrayDimsAndInits()<br>
   * .. .. . .. .. | &1 $0 Arguments()<br>
   * .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )<br>
   * s: 1688598744<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1688598744, JTB_SIG_ALLOCATIONEXPRESSION, JTB_USER_ALLOCATIONEXPRESSION })
  public int visit(final AllocationExpression n) {
    int nRes = 0;
    // f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
    // .. .. | %1 #0 "new" #1 ClassOrInterfaceType()
    // .. .. . .. #2 [ &0 EmptyTypeArguments()
    // .. .. . .. .. | &1 TypeArguments() ]
    // .. .. . .. #3 ( &0 ArrayDimsAndInits()
    // .. .. . .. .. | &1 $0 Arguments()
    // .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "new"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 PrimitiveType()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 ArrayDimsAndInits()
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        break;
      case 1:
        //%1 #0 "new" #1 ClassOrInterfaceType()
        //.. #2 [ &0 EmptyTypeArguments()
        //.. .. | &1 TypeArguments() ]
        //.. #3 ( &0 ArrayDimsAndInits()
        //.. .. | &1 $0 Arguments()
        //.. .. .. $1 [ ClassOrInterfaceBody() ] )
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "new"
        final INode nd3 = seq1.elementAt(0);
        nRes = nd3.accept(this);
        //#1 ClassOrInterfaceType()
        final INode nd4 = seq1.elementAt(1);
        nRes = nd4.accept(this);
        //#2 [ &0 EmptyTypeArguments()
        //.. | &1 TypeArguments() ]
        final INode nd5 = seq1.elementAt(2);
        final NodeOptional opt = (NodeOptional) nd5;
        if (opt.present()) {
          final NodeChoice nch1 = (NodeChoice) opt.node;
          final INode ich1 = nch1.choice;
          switch (nch1.which) {
            case 0:
              //&0 EmptyTypeArguments()
              nRes = ich1.accept(this);
              break;
            case 1:
              //&1 TypeArguments()
              nRes = ich1.accept(this);
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch1);
          }
        }
        //#3 ( &0 ArrayDimsAndInits()
        //.. | &1 $0 Arguments()
        //.. .. $1 [ ClassOrInterfaceBody() ] )
        final INode nd6 = seq1.elementAt(3);
        final NodeChoice nch2 = (NodeChoice) nd6;
        final INode ich2 = nch2.choice;
        switch (nch2.which) {
          case 0:
            //&0 ArrayDimsAndInits()
            nRes = ich2.accept(this);
            break;
          case 1:
            //&1 $0 Arguments()
            //.. $1 [ ClassOrInterfaceBody() ]
            final NodeSequence seq2 = (NodeSequence) ich2;
            //$0 Arguments()
            final INode nd7 = seq2.elementAt(0);
            nRes = nd7.accept(this);
            //$1 [ ClassOrInterfaceBody() ]
            final INode nd8 = seq2.elementAt(1);
            final NodeOptional opt1 = (NodeOptional) nd8;
            if (opt1.present()) {
              nRes = opt1.accept(this);
            }
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch2);
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link ArrayDimsAndInits} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   * .. .. | %1 #0 ( $0 "[" $1 "]" )+<br>
   * .. .. . .. #1 ArrayInitializer()<br>
   * s: 184028601<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 184028601, JTB_SIG_ARRAYDIMSANDINITS, JTB_USER_ARRAYDIMSANDINITS })
  public int visit(final ArrayDimsAndInits n) {
    int nRes = 0;
    // f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    // .. .. | %1 #0 ( $0 "[" $1 "]" )+
    // .. .. . .. #1 ArrayInitializer()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 ( $0 "[" $1 Expression() $2 "]" )+
        //.. #1 ( $0 "[" $1 "]" )*
        final NodeSequence seq = (NodeSequence) ich;
        //#0 ( $0 "[" $1 Expression() $2 "]" )+
        final INode nd = seq.elementAt(0);
        final NodeList lst = (NodeList) nd;
        for (int i = 0; i < lst.size(); i++) {
          final INode lsteai = lst.elementAt(i);
          final NodeSequence seq1 = (NodeSequence) lsteai;
          //$0 "["
          final INode nd1 = seq1.elementAt(0);
          nRes = nd1.accept(this);
          //$1 Expression()
          final INode nd2 = seq1.elementAt(1);
          nRes = nd2.accept(this);
          //$2 "]"
          final INode nd3 = seq1.elementAt(2);
          nRes = nd3.accept(this);
        }
        //#1 ( $0 "[" $1 "]" )*
        final INode nd4 = seq.elementAt(1);
        final NodeListOptional nlo = (NodeListOptional) nd4;
        if (nlo.present()) {
          for (int i = 0; i < nlo.size(); i++) {
            final INode nloeai = nlo.elementAt(i);
            final NodeSequence seq2 = (NodeSequence) nloeai;
            //$0 "["
            final INode nd5 = seq2.elementAt(0);
            nRes = nd5.accept(this);
            //$1 "]"
            final INode nd6 = seq2.elementAt(1);
            nRes = nd6.accept(this);
          }
        }
        break;
      case 1:
        //%1 #0 ( $0 "[" $1 "]" )+
        //.. #1 ArrayInitializer()
        final NodeSequence seq3 = (NodeSequence) ich;
        //#0 ( $0 "[" $1 "]" )+
        final INode nd7 = seq3.elementAt(0);
        final NodeList lst1 = (NodeList) nd7;
        for (int i = 0; i < lst1.size(); i++) {
          final INode lsteai = lst1.elementAt(i);
          final NodeSequence seq4 = (NodeSequence) lsteai;
          //$0 "["
          final INode nd8 = seq4.elementAt(0);
          nRes = nd8.accept(this);
          //$1 "]"
          final INode nd9 = seq4.elementAt(1);
          nRes = nd9.accept(this);
        }
        //#1 ArrayInitializer()
        final INode nd10 = seq3.elementAt(1);
        nRes = nd10.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link Statement} node, whose child is the following :
   * <p>
   * f0 -> . %00 LabeledStatement()<br>
   * .. .. | %01 AssertStatement()<br>
   * .. .. | %02 Block()<br>
   * .. .. | %03 EmptyStatement()<br>
   * .. .. | %04 #0 StatementExpression() #1 ";"<br>
   * .. .. | %05 SwitchStatement()<br>
   * .. .. | %06 IfStatement()<br>
   * .. .. | %07 WhileStatement()<br>
   * .. .. | %08 DoStatement()<br>
   * .. .. | %09 ForStatement()<br>
   * .. .. | %10 BreakStatement()<br>
   * .. .. | %11 ContinueStatement()<br>
   * .. .. | %12 ReturnStatement()<br>
   * .. .. | %13 ThrowStatement()<br>
   * .. .. | %14 SynchronizedStatement()<br>
   * .. .. | %15 TryStatement()<br>
   * s: 1394695492<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1394695492, JTB_SIG_STATEMENT, JTB_USER_STATEMENT })
  public int visit(final Statement n) {
    int nRes = 0;
    // f0 -> . %00 LabeledStatement()
    // .. .. | %01 AssertStatement()
    // .. .. | %02 Block()
    // .. .. | %03 EmptyStatement()
    // .. .. | %04 #0 StatementExpression() #1 ";"
    // .. .. | %05 SwitchStatement()
    // .. .. | %06 IfStatement()
    // .. .. | %07 WhileStatement()
    // .. .. | %08 DoStatement()
    // .. .. | %09 ForStatement()
    // .. .. | %10 BreakStatement()
    // .. .. | %11 ContinueStatement()
    // .. .. | %12 ReturnStatement()
    // .. .. | %13 ThrowStatement()
    // .. .. | %14 SynchronizedStatement()
    // .. .. | %15 TryStatement()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%00 LabeledStatement()
        nRes = ich.accept(this);
        break;
      case 1:
        //%01 AssertStatement()
        nRes = ich.accept(this);
        break;
      case 2:
        //%02 Block()
        nRes = ich.accept(this);
        break;
      case 3:
        //%03 EmptyStatement()
        nRes = ich.accept(this);
        break;
      case 4:
        //%04 #0 StatementExpression() #1 ";"
        final NodeSequence seq = (NodeSequence) ich;
        //#0 StatementExpression()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ";"
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 5:
        //%05 SwitchStatement()
        nRes = ich.accept(this);
        break;
      case 6:
        //%06 IfStatement()
        nRes = ich.accept(this);
        break;
      case 7:
        //%07 WhileStatement()
        nRes = ich.accept(this);
        break;
      case 8:
        //%08 DoStatement()
        nRes = ich.accept(this);
        break;
      case 9:
        //%09 ForStatement()
        nRes = ich.accept(this);
        break;
      case 10:
        //%10 BreakStatement()
        nRes = ich.accept(this);
        break;
      case 11:
        //%11 ContinueStatement()
        nRes = ich.accept(this);
        break;
      case 12:
        //%12 ReturnStatement()
        nRes = ich.accept(this);
        break;
      case 13:
        //%13 ThrowStatement()
        nRes = ich.accept(this);
        break;
      case 14:
        //%14 SynchronizedStatement()
        nRes = ich.accept(this);
        break;
      case 15:
        //%15 TryStatement()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link AssertStatement} node, whose children are the following :
   * <p>
   * f0 -> "assert"<br>
   * f1 -> Expression()<br>
   * f2 -> [ #0 ":" #1 Expression() ]<br>
   * f3 -> ";"<br>
   * s: -579866328<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -579866328, JTB_SIG_ASSERTSTATEMENT, JTB_USER_ASSERTSTATEMENT })
  public int visit(final AssertStatement n) {
    int nRes = 0;
    // f0 -> "assert"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> [ #0 ":" #1 Expression() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence seq = (NodeSequence) n2.node;
      //#0 ":"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 Expression()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    // f3 -> ";"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link LabeledStatement} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> ":"<br>
   * f2 -> Statement()<br>
   * s: -1956923191<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1956923191, JTB_SIG_LABELEDSTATEMENT, JTB_USER_LABELEDSTATEMENT })
  public int visit(final LabeledStatement n) {
    int nRes = 0;
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ":"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Statement()
    final Statement n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link Block} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( BlockStatement() )*<br>
   * f2 -> "}"<br>
   * s: -47169424<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -47169424, JTB_SIG_BLOCK, JTB_USER_BLOCK })
  public int visit(final Block n) {
    int nRes = 0;
    // f0 -> "{"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( BlockStatement() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    // f2 -> "}"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BlockStatement} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"<br>
   * .. .. | %1 Statement()<br>
   * .. .. | %2 ClassOrInterfaceDeclaration()<br>
   * s: -1009630136<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1009630136, JTB_SIG_BLOCKSTATEMENT, JTB_USER_BLOCKSTATEMENT })
  public int visit(final BlockStatement n) {
    int nRes = 0;
    // f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"
    // .. .. | %1 Statement()
    // .. .. | %2 ClassOrInterfaceDeclaration()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 LocalVariableDeclaration() #1 ";"
        final NodeSequence seq = (NodeSequence) ich;
        //#0 LocalVariableDeclaration()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ";"
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 Statement()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 ClassOrInterfaceDeclaration()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link LocalVariableDeclaration} node, whose children are the following :
   * <p>
   * f0 -> VariableModifiers()<br>
   * f1 -> Type()<br>
   * f2 -> VariableDeclarator()<br>
   * f3 -> ( #0 "," #1 VariableDeclarator() )*<br>
   * s: 225808290<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 225808290, JTB_SIG_LOCALVARIABLEDECLARATION, JTB_USER_LOCALVARIABLEDECLARATION })
  public int visit(final LocalVariableDeclaration n) {
    int nRes = 0;
    // f0 -> VariableModifiers()
    final VariableModifiers n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Type()
    final Type n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> VariableDeclarator()
    final VariableDeclarator n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n3 = n.f3;
    if (n3.present()) {
      for (int i = 0; i < n3.size(); i++) {
        final INode nloeai = n3.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 VariableDeclarator()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link VariableModifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %0 "final"<br>
   * .. .. . | %1 Annotation() ) )*<br>
   * s: 2076055340<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2076055340, JTB_SIG_VARIABLEMODIFIERS, JTB_USER_VARIABLEMODIFIERS })
  public int visit(final VariableModifiers n) {
    int nRes = 0;
    // f0 -> ( ( %0 "final"
    // .. .. . | %1 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode nloeai = n0.elementAt(i);
        final NodeChoice nch = (NodeChoice) nloeai;
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 "final"
            nRes = ich.accept(this);
            break;
          case 1:
            //%1 Annotation()
            nRes = ich.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link EmptyStatement} node, whose child is the following :
   * <p>
   * f0 -> ";"<br>
   * s: 2055660624<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2055660624, JTB_SIG_EMPTYSTATEMENT, JTB_USER_EMPTYSTATEMENT })
  public int visit(final EmptyStatement n) {
    int nRes = 0;
    // f0 -> ";"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link StatementExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 PreIncrementExpression()<br>
   * .. .. | %1 PreDecrementExpression()<br>
   * .. .. | %2 #0 PrimaryExpression()<br>
   * .. .. . .. #1 [ &0 "++"<br>
   * .. .. . .. .. | &1 "--"<br>
   * .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]<br>
   * s: 757890000<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 757890000, JTB_SIG_STATEMENTEXPRESSION, JTB_USER_STATEMENTEXPRESSION })
  public int visit(final StatementExpression n) {
    int nRes = 0;
    // f0 -> . %0 PreIncrementExpression()
    // .. .. | %1 PreDecrementExpression()
    // .. .. | %2 #0 PrimaryExpression()
    // .. .. . .. #1 [ &0 "++"
    // .. .. . .. .. | &1 "--"
    // .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 PreIncrementExpression()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 PreDecrementExpression()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 #0 PrimaryExpression()
        //.. #1 [ &0 "++"
        //.. .. | &1 "--"
        //.. .. | &2 $0 AssignmentOperator() $1 Expression() ]
        final NodeSequence seq = (NodeSequence) ich;
        //#0 PrimaryExpression()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 [ &0 "++"
        //.. | &1 "--"
        //.. | &2 $0 AssignmentOperator() $1 Expression() ]
        final INode nd1 = seq.elementAt(1);
        final NodeOptional opt = (NodeOptional) nd1;
        if (opt.present()) {
          final NodeChoice nch1 = (NodeChoice) opt.node;
          final INode ich1 = nch1.choice;
          switch (nch1.which) {
            case 0:
              //&0 "++"
              nRes = ich1.accept(this);
              break;
            case 1:
              //&1 "--"
              nRes = ich1.accept(this);
              break;
            case 2:
              //&2 $0 AssignmentOperator() $1 Expression()
              final NodeSequence seq1 = (NodeSequence) ich1;
              //$0 AssignmentOperator()
              final INode nd2 = seq1.elementAt(0);
              nRes = nd2.accept(this);
              //$1 Expression()
              final INode nd3 = seq1.elementAt(1);
              nRes = nd3.accept(this);
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch1);
          }
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link SwitchStatement} node, whose children are the following :
   * <p>
   * f0 -> "switch"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> "{"<br>
   * f5 -> ( #0 SwitchLabel()<br>
   * .. .. . #1 ( BlockStatement() )* )*<br>
   * f6 -> "}"<br>
   * s: 645895087<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 645895087, JTB_SIG_SWITCHSTATEMENT, JTB_USER_SWITCHSTATEMENT })
  public int visit(final SwitchStatement n) {
    int nRes = 0;
    // f0 -> "switch"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> "{"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> ( #0 SwitchLabel()
    // .. .. . #1 ( BlockStatement() )* )*
    final NodeListOptional n5 = n.f5;
    if (n5.present()) {
      for (int i = 0; i < n5.size(); i++) {
        final INode nloeai = n5.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 SwitchLabel()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ( BlockStatement() )*
        final INode nd1 = seq.elementAt(1);
        final NodeListOptional nlo = (NodeListOptional) nd1;
        if (nlo.present()) {
          for (int i1 = 0; i1 < nlo.size(); i1++) {
            final INode nloeai1 = nlo.elementAt(i1);
            nRes = nloeai1.accept(this);
          }
        }
      }
    }
    // f6 -> "}"
    final Token n6 = n.f6;
    nRes = n6.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link SwitchLabel} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "case" #1 Expression() #2 ":"<br>
   * .. .. | %1 #0 "default" #1 ":"<br>
   * s: 63513165<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 63513165, JTB_SIG_SWITCHLABEL, JTB_USER_SWITCHLABEL })
  public int visit(final SwitchLabel n) {
    int nRes = 0;
    // f0 -> . %0 #0 "case" #1 Expression() #2 ":"
    // .. .. | %1 #0 "default" #1 ":"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "case" #1 Expression() #2 ":"
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "case"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 Expression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 ":"
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        break;
      case 1:
        //%1 #0 "default" #1 ":"
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "default"
        final INode nd3 = seq1.elementAt(0);
        nRes = nd3.accept(this);
        //#1 ":"
        final INode nd4 = seq1.elementAt(1);
        nRes = nd4.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link IfStatement} node, whose children are the following :
   * <p>
   * f0 -> "if"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * f5 -> [ #0 "else" #1 Statement() ]<br>
   * s: -1906079982<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1906079982, JTB_SIG_IFSTATEMENT, JTB_USER_IFSTATEMENT })
  public int visit(final IfStatement n) {
    int nRes = 0;
    // f0 -> "if"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> [ #0 "else" #1 Statement() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence seq = (NodeSequence) n5.node;
      //#0 "else"
      final INode nd = seq.elementAt(0);
      nRes = nd.accept(this);
      //#1 Statement()
      final INode nd1 = seq.elementAt(1);
      nRes = nd1.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link WhileStatement} node, whose children are the following :
   * <p>
   * f0 -> "while"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * s: 503551312<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 503551312, JTB_SIG_WHILESTATEMENT, JTB_USER_WHILESTATEMENT })
  public int visit(final WhileStatement n) {
    int nRes = 0;
    // f0 -> "while"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link DoStatement} node, whose children are the following :
   * <p>
   * f0 -> "do"<br>
   * f1 -> Statement()<br>
   * f2 -> "while"<br>
   * f3 -> "("<br>
   * f4 -> Expression()<br>
   * f5 -> ")"<br>
   * f6 -> ";"<br>
   * s: 1162769715<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1162769715, JTB_SIG_DOSTATEMENT, JTB_USER_DOSTATEMENT })
  public int visit(final DoStatement n) {
    int nRes = 0;
    // f0 -> "do"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Statement()
    final Statement n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "while"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> "("
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Expression()
    final Expression n4 = n.f4;
    nRes = n4.accept(this);
    // f5 -> ")"
    final Token n5 = n.f5;
    nRes = n5.accept(this);
    // f6 -> ";"
    final Token n6 = n.f6;
    nRes = n6.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ForStatement} node, whose children are the following :
   * <p>
   * f0 -> "for"<br>
   * f1 -> "("<br>
   * f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 < IDENTIFIER > #3 ":" #4 Expression()<br>
   * .. .. | %1 #0 [ ForInit() ]<br>
   * .. .. . .. #1 ";"<br>
   * .. .. . .. #2 [ Expression() ]<br>
   * .. .. . .. #3 ";"<br>
   * .. .. . .. #4 [ ForUpdate() ] )<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * s: 755358653<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 755358653, JTB_SIG_FORSTATEMENT, JTB_USER_FORSTATEMENT })
  public int visit(final ForStatement n) {
    int nRes = 0;
    // f0 -> "for"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 < IDENTIFIER > #3 ":" #4 Expression()
    // .. .. | %1 #0 [ ForInit() ]
    // .. .. . .. #1 ";"
    // .. .. . .. #2 [ Expression() ]
    // .. .. . .. #3 ";"
    // .. .. . .. #4 [ ForUpdate() ] )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 VariableModifiers() #1 Type() #2 < IDENTIFIER > #3 ":" #4 Expression()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 VariableModifiers()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 Type()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 < IDENTIFIER >
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        //#3 ":"
        final INode nd3 = seq.elementAt(3);
        nRes = nd3.accept(this);
        //#4 Expression()
        final INode nd4 = seq.elementAt(4);
        nRes = nd4.accept(this);
        break;
      case 1:
        //%1 #0 [ ForInit() ]
        //.. #1 ";"
        //.. #2 [ Expression() ]
        //.. #3 ";"
        //.. #4 [ ForUpdate() ]
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 [ ForInit() ]
        final INode nd5 = seq1.elementAt(0);
        final NodeOptional opt = (NodeOptional) nd5;
        if (opt.present()) {
          nRes = opt.accept(this);
        }
        //#1 ";"
        final INode nd6 = seq1.elementAt(1);
        nRes = nd6.accept(this);
        //#2 [ Expression() ]
        final INode nd7 = seq1.elementAt(2);
        final NodeOptional opt1 = (NodeOptional) nd7;
        if (opt1.present()) {
          nRes = opt1.accept(this);
        }
        //#3 ";"
        final INode nd8 = seq1.elementAt(3);
        nRes = nd8.accept(this);
        //#4 [ ForUpdate() ]
        final INode nd9 = seq1.elementAt(4);
        final NodeOptional opt2 = (NodeOptional) nd9;
        if (opt2.present()) {
          nRes = opt2.accept(this);
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f3 -> ")"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ForInit} node, whose child is the following :
   * <p>
   * f0 -> . %0 LocalVariableDeclaration()<br>
   * .. .. | %1 StatementExpressionList()<br>
   * s: 1128701780<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1128701780, JTB_SIG_FORINIT, JTB_USER_FORINIT })
  public int visit(final ForInit n) {
    int nRes = 0;
    // f0 -> . %0 LocalVariableDeclaration()
    // .. .. | %1 StatementExpressionList()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 LocalVariableDeclaration()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 StatementExpressionList()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link StatementExpressionList} node, whose children are the following :
   * <p>
   * f0 -> StatementExpression()<br>
   * f1 -> ( #0 "," #1 StatementExpression() )*<br>
   * s: 186773841<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 186773841, JTB_SIG_STATEMENTEXPRESSIONLIST, JTB_USER_STATEMENTEXPRESSIONLIST })
  public int visit(final StatementExpressionList n) {
    int nRes = 0;
    // f0 -> StatementExpression()
    final StatementExpression n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 StatementExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 StatementExpression()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link ForUpdate} node, whose child is the following :
   * <p>
   * f0 -> StatementExpressionList()<br>
   * s: -1489663891<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1489663891, JTB_SIG_FORUPDATE, JTB_USER_FORUPDATE })
  public int visit(final ForUpdate n) {
    int nRes = 0;
    // f0 -> StatementExpressionList()
    final StatementExpressionList n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link BreakStatement} node, whose children are the following :
   * <p>
   * f0 -> "break"<br>
   * f1 -> [ < IDENTIFIER > ]<br>
   * f2 -> ";"<br>
   * s: 2096828507<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2096828507, JTB_SIG_BREAKSTATEMENT, JTB_USER_BREAKSTATEMENT })
  public int visit(final BreakStatement n) {
    int nRes = 0;
    // f0 -> "break"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ < IDENTIFIER > ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ";"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ContinueStatement} node, whose children are the following :
   * <p>
   * f0 -> "continue"<br>
   * f1 -> [ < IDENTIFIER > ]<br>
   * f2 -> ";"<br>
   * s: -1991535243<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1991535243, JTB_SIG_CONTINUESTATEMENT, JTB_USER_CONTINUESTATEMENT })
  public int visit(final ContinueStatement n) {
    int nRes = 0;
    // f0 -> "continue"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ < IDENTIFIER > ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ";"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ReturnStatement} node, whose children are the following :
   * <p>
   * f0 -> "return"<br>
   * f1 -> [ Expression() ]<br>
   * f2 -> ";"<br>
   * s: -1971167888<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1971167888, JTB_SIG_RETURNSTATEMENT, JTB_USER_RETURNSTATEMENT })
  public int visit(final ReturnStatement n) {
    int nRes = 0;
    // f0 -> "return"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ";"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link ThrowStatement} node, whose children are the following :
   * <p>
   * f0 -> "throw"<br>
   * f1 -> Expression()<br>
   * f2 -> ";"<br>
   * s: 568421270<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 568421270, JTB_SIG_THROWSTATEMENT, JTB_USER_THROWSTATEMENT })
  public int visit(final ThrowStatement n) {
    int nRes = 0;
    // f0 -> "throw"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ";"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link SynchronizedStatement} node, whose children are the following :
   * <p>
   * f0 -> "synchronized"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Block()<br>
   * s: 2040551171<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2040551171, JTB_SIG_SYNCHRONIZEDSTATEMENT, JTB_USER_SYNCHRONIZEDSTATEMENT })
  public int visit(final SynchronizedStatement n) {
    int nRes = 0;
    // f0 -> "synchronized"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "("
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> ")"
    final Token n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> Block()
    final Block n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link TryStatement} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> Block()<br>
   * f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*<br>
   * f3 -> [ #0 "finally" #1 Block() ]<br>
   * s: 1108527850<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1108527850, JTB_SIG_TRYSTATEMENT, JTB_USER_TRYSTATEMENT })
  public int visit(final TryStatement n) {
    int nRes = 0;
    // f0 -> "try"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Block()
    final Block n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 "catch"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 "("
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 FormalParameter()
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        //#3 ")"
        final INode nd3 = seq.elementAt(3);
        nRes = nd3.accept(this);
        //#4 Block()
        final INode nd4 = seq.elementAt(4);
        nRes = nd4.accept(this);
      }
    }
    // f3 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence seq1 = (NodeSequence) n3.node;
      //#0 "finally"
      final INode nd5 = seq1.elementAt(0);
      nRes = nd5.accept(this);
      //#1 Block()
      final INode nd6 = seq1.elementAt(1);
      nRes = nd6.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link Annotation} node, whose child is the following :
   * <p>
   * f0 -> . %0 NormalAnnotation()<br>
   * .. .. | %1 SingleMemberAnnotation()<br>
   * .. .. | %2 MarkerAnnotation()<br>
   * s: 1542293240<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1542293240, JTB_SIG_ANNOTATION, JTB_USER_ANNOTATION })
  public int visit(final Annotation n) {
    int nRes = 0;
    // f0 -> . %0 NormalAnnotation()
    // .. .. | %1 SingleMemberAnnotation()
    // .. .. | %2 MarkerAnnotation()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 NormalAnnotation()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 SingleMemberAnnotation()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 MarkerAnnotation()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link NormalAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> [ MemberValuePairs() ]<br>
   * f4 -> ")"<br>
   * s: -50913587<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -50913587, JTB_SIG_NORMALANNOTATION, JTB_USER_NORMALANNOTATION })
  public int visit(final NormalAnnotation n) {
    int nRes = 0;
    // f0 -> "@"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "("
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> [ MemberValuePairs() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> ")"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MarkerAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * s: -11544239<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -11544239, JTB_SIG_MARKERANNOTATION, JTB_USER_MARKERANNOTATION })
  public int visit(final MarkerAnnotation n) {
    int nRes = 0;
    // f0 -> "@"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link SingleMemberAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> MemberValue()<br>
   * f4 -> ")"<br>
   * s: -1771126382<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1771126382, JTB_SIG_SINGLEMEMBERANNOTATION, JTB_USER_SINGLEMEMBERANNOTATION })
  public int visit(final SingleMemberAnnotation n) {
    int nRes = 0;
    // f0 -> "@"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Name()
    final Name n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> "("
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> MemberValue()
    final MemberValue n3 = n.f3;
    nRes = n3.accept(this);
    // f4 -> ")"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MemberValuePairs} node, whose children are the following :
   * <p>
   * f0 -> MemberValuePair()<br>
   * f1 -> ( #0 "," #1 MemberValuePair() )*<br>
   * s: -113472239<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -113472239, JTB_SIG_MEMBERVALUEPAIRS, JTB_USER_MEMBERVALUEPAIRS })
  public int visit(final MemberValuePairs n) {
    int nRes = 0;
    // f0 -> MemberValuePair()
    final MemberValuePair n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 "," #1 MemberValuePair() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 MemberValuePair()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link MemberValuePair} node, whose children are the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * f1 -> "="<br>
   * f2 -> MemberValue()<br>
   * s: -476335468<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -476335468, JTB_SIG_MEMBERVALUEPAIR, JTB_USER_MEMBERVALUEPAIR })
  public int visit(final MemberValuePair n) {
    int nRes = 0;
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "="
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> MemberValue()
    final MemberValue n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link MemberValue} node, whose child is the following :
   * <p>
   * f0 -> . %0 Annotation()<br>
   * .. .. | %1 MemberValueArrayInitializer()<br>
   * .. .. | %2 ConditionalExpression()<br>
   * s: -1120846693<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1120846693, JTB_SIG_MEMBERVALUE, JTB_USER_MEMBERVALUE })
  public int visit(final MemberValue n) {
    int nRes = 0;
    // f0 -> . %0 Annotation()
    // .. .. | %1 MemberValueArrayInitializer()
    // .. .. | %2 ConditionalExpression()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 Annotation()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 MemberValueArrayInitializer()
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 ConditionalExpression()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link MemberValueArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> MemberValue()<br>
   * f2 -> ( #0 "," #1 MemberValue() )*<br>
   * f3 -> [ "," ]<br>
   * f4 -> "}"<br>
   * s: 111140055<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 111140055, JTB_SIG_MEMBERVALUEARRAYINITIALIZER, JTB_USER_MEMBERVALUEARRAYINITIALIZER })
  public int visit(final MemberValueArrayInitializer n) {
    int nRes = 0;
    // f0 -> "{"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 "," #1 MemberValue() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        final NodeSequence seq = (NodeSequence) nloeai;
        //#0 ","
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 MemberValue()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
      }
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      nRes = n3.accept(this);
    }
    // f4 -> "}"
    final Token n4 = n.f4;
    nRes = n4.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> "interface"<br>
   * f2 -> < IDENTIFIER ><br>
   * f3 -> AnnotationTypeBody()<br>
   * s: 383718196<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 383718196, JTB_SIG_ANNOTATIONTYPEDECLARATION, JTB_USER_ANNOTATIONTYPEDECLARATION })
  public int visit(final AnnotationTypeDeclaration n) {
    int nRes = 0;
    // f0 -> "@"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> "interface"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> < IDENTIFIER >
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    // f3 -> AnnotationTypeBody()
    final AnnotationTypeBody n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( AnnotationTypeMemberDeclaration() )*<br>
   * f2 -> "}"<br>
   * s: -667465535<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -667465535, JTB_SIG_ANNOTATIONTYPEBODY, JTB_USER_ANNOTATIONTYPEBODY })
  public int visit(final AnnotationTypeBody n) {
    int nRes = 0;
    // f0 -> "{"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( AnnotationTypeMemberDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode nloeai = n1.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    // f2 -> "}"
    final Token n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link AnnotationTypeMemberDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 $0 Type() $1 < IDENTIFIER > $2 "(" $3 ")"<br>
   * .. .. . .. .. . .. $4 [ DefaultValue() ]<br>
   * .. .. . .. .. . .. $5 ";"<br>
   * .. .. . .. .. | &1 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &2 EnumDeclaration()<br>
   * .. .. . .. .. | &3 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration() )<br>
   * .. .. | %1 ";"<br>
   * s: -1120210008<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1120210008, JTB_SIG_ANNOTATIONTYPEMEMBERDECLARATION, JTB_USER_ANNOTATIONTYPEMEMBERDECLARATION })
  public int visit(final AnnotationTypeMemberDeclaration n) {
    int nRes = 0;
    // f0 -> . %0 #0 Modifiers()
    // .. .. . .. #1 ( &0 $0 Type() $1 < IDENTIFIER > $2 "(" $3 ")"
    // .. .. . .. .. . .. $4 [ DefaultValue() ]
    // .. .. . .. .. . .. $5 ";"
    // .. .. . .. .. | &1 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &2 EnumDeclaration()
    // .. .. . .. .. | &3 AnnotationTypeDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration() )
    // .. .. | %1 ";"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 Modifiers()
        //.. #1 ( &0 $0 Type() $1 < IDENTIFIER > $2 "(" $3 ")"
        //.. .. .. $4 [ DefaultValue() ]
        //.. .. .. $5 ";"
        //.. .. | &1 ClassOrInterfaceDeclaration()
        //.. .. | &2 EnumDeclaration()
        //.. .. | &3 AnnotationTypeDeclaration()
        //.. .. | &4 FieldDeclaration() )
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Modifiers()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ( &0 $0 Type() $1 < IDENTIFIER > $2 "(" $3 ")"
        //.. .. $4 [ DefaultValue() ]
        //.. .. $5 ";"
        //.. | &1 ClassOrInterfaceDeclaration()
        //.. | &2 EnumDeclaration()
        //.. | &3 AnnotationTypeDeclaration()
        //.. | &4 FieldDeclaration() )
        final INode nd1 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) nd1;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 $0 Type() $1 < IDENTIFIER > $2 "(" $3 ")"
            //.. $4 [ DefaultValue() ]
            //.. $5 ";"
            final NodeSequence seq1 = (NodeSequence) ich1;
            //$0 Type()
            final INode nd2 = seq1.elementAt(0);
            nRes = nd2.accept(this);
            //$1 < IDENTIFIER >
            final INode nd3 = seq1.elementAt(1);
            nRes = nd3.accept(this);
            //$2 "("
            final INode nd4 = seq1.elementAt(2);
            nRes = nd4.accept(this);
            //$3 ")"
            final INode nd5 = seq1.elementAt(3);
            nRes = nd5.accept(this);
            //$4 [ DefaultValue() ]
            final INode nd6 = seq1.elementAt(4);
            final NodeOptional opt = (NodeOptional) nd6;
            if (opt.present()) {
              nRes = opt.accept(this);
            }
            //$5 ";"
            final INode nd7 = seq1.elementAt(5);
            nRes = nd7.accept(this);
            break;
          case 1:
            //&1 ClassOrInterfaceDeclaration()
            nRes = ich1.accept(this);
            break;
          case 2:
            //&2 EnumDeclaration()
            nRes = ich1.accept(this);
            break;
          case 3:
            //&3 AnnotationTypeDeclaration()
            nRes = ich1.accept(this);
            break;
          case 4:
            //&4 FieldDeclaration()
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      case 1:
        //%1 ";"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link DefaultValue} node, whose children are the following :
   * <p>
   * f0 -> "default"<br>
   * f1 -> MemberValue()<br>
   * s: -1936312236<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1936312236, JTB_SIG_DEFAULTVALUE, JTB_USER_DEFAULTVALUE })
  public int visit(final DefaultValue n) {
    int nRes = 0;
    // f0 -> "default"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Class handling a programmatic exception. Static for generic outer classes.
   */
  public static class ShouldNotOccurException extends RuntimeException {

    /** Default serialVersionUID */
    private static final long serialVersionUID = 1L;

    /**
     * Constructor with no message.
     */
    public ShouldNotOccurException() {
      super();
    }

    /**
     * Constructor which outputs a message.
     *
     * @param ch - a NodeChoice whose which value is invalid or lead to a fall-through
     */
    public ShouldNotOccurException(final NodeChoice ch) {
      super("Invalid switch value (" + ch.which + ") or fall-through");
    }

  }

}
