/*
 * Copyright (c) 2002-2025, the original author(s).
 *
 * This software is distributable under the BSD license. See the terms of the
 * BSD license in the documentation provided with this software.
 *
 * https://opensource.org/licenses/BSD-3-Clause
 */

/**
 * JLine Builtins provides a collection of utility classes and implementations for common terminal
 * functionality.
 * <p>
 * This package contains various components that enhance the JLine library with built-in commands,
 * completers, and utilities for terminal-based applications:
 * </p>
 * <ul>
 *   <li>Terminal commands like {@link org.jline.builtins.Less}, {@link org.jline.builtins.Nano},
 *       and {@link org.jline.builtins.Tmux}</li>
 *   <li>Completion utilities through {@link org.jline.builtins.Completers}</li>
 *   <li>Command-line option parsing with {@link org.jline.builtins.Options}</li>
 *   <li>Configuration management via {@link org.jline.builtins.ConfigurationPath}</li>
 *   <li>Syntax highlighting with {@link org.jline.builtins.SyntaxHighlighter}</li>
 *   <li>Terminal monitoring through {@link org.jline.builtins.TTop}</li>
 * </ul>
 * <p>
 * These built-in components can be used to quickly implement rich terminal applications
 * with features like command completion, syntax highlighting, and file navigation.
 * </p>
 */
package org.jline.builtins;
