/*
 * Decompiled with CFR 0.152.
 */
package org.fedoraproject.xmvn.tools.subst;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fedoraproject.xmvn.artifact.Artifact;
import org.fedoraproject.xmvn.artifact.DefaultArtifact;
import org.fedoraproject.xmvn.metadata.ArtifactMetadata;
import org.fedoraproject.xmvn.metadata.MetadataResult;

public class ArtifactVisitor
implements FileVisitor<Path> {
    private boolean debug;
    private final Set<String> types = new LinkedHashSet<String>();
    private final List<MetadataResult> metadata;
    private boolean followSymlinks;
    private boolean dryRun;
    private int failureCount;

    public ArtifactVisitor(boolean debug, List<MetadataResult> metadata) {
        this.debug = debug;
        this.metadata = metadata;
    }

    public void setTypes(Collection<String> types) {
        this.types.addAll(types);
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
        if (Files.isSymbolicLink(path) && !this.followSymlinks) {
            if (this.debug) {
                System.err.printf("Skipping symlink to directory: %s%n", path);
            }
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            if (this.debug) {
                System.err.printf("Skipping %s: not a regular file%n", path);
            }
            return FileVisitResult.CONTINUE;
        }
        String fileName = path.getFileName().toString();
        for (String type : this.types) {
            if (!fileName.endsWith("." + type)) continue;
            this.substituteArtifact(path, type);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
        System.err.printf("WARNING: Failed to access file %s%n", path);
        return FileVisitResult.CONTINUE;
    }

    private Artifact getArtifactFromManifest(Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Manifest mf = jarFile.getManifest();
            if (mf == null) {
                Artifact artifact = null;
                return artifact;
            }
            String groupId = mf.getMainAttributes().getValue("JavaPackages-GroupId");
            String artifactId = mf.getMainAttributes().getValue("JavaPackages-ArtifactId");
            String extension = mf.getMainAttributes().getValue("JavaPackages-Extension");
            String classifier = mf.getMainAttributes().getValue("JavaPackages-Classifier");
            String version = mf.getMainAttributes().getValue("JavaPackages-Version");
            if (groupId == null || artifactId == null) {
                Artifact artifact = null;
                return artifact;
            }
            DefaultArtifact defaultArtifact = new DefaultArtifact(groupId, artifactId, extension, classifier, version);
            return defaultArtifact;
        }
    }

    private Artifact getArtifactFromPomProperties(Path path, String extension) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.startsWith("META-INF/maven/") || !name.endsWith("/pom.properties")) continue;
                Properties properties = new Properties();
                properties.load(zis);
                String groupId = properties.getProperty("groupId");
                String artifactId = properties.getProperty("artifactId");
                String version = properties.getProperty("version");
                DefaultArtifact defaultArtifact = new DefaultArtifact(groupId, artifactId, extension, version);
                return defaultArtifact;
            }
            Artifact artifact = null;
            return artifact;
        }
    }

    private Artifact readArtifactDefinition(Path path, String extension) {
        try {
            Artifact artifact = this.getArtifactFromManifest(path);
            if (artifact != null) {
                return artifact;
            }
            artifact = this.getArtifactFromPomProperties(path, extension);
            if (artifact != null) {
                return artifact;
            }
            return null;
        }
        catch (IOException e) {
            System.err.printf("ERROR: Failed to get artifact definition from file %s%n", path);
            e.printStackTrace();
            return null;
        }
    }

    private void substituteArtifact(Path path, String type) throws IOException {
        Artifact artifact = this.readArtifactDefinition(path, type);
        if (artifact == null) {
            System.err.printf("Skipping file %s: No artifact definition found%n", path);
            ++this.failureCount;
            return;
        }
        ArtifactMetadata metadata = this.resolveMetadata(artifact);
        if (metadata == null) {
            System.err.printf("WARNING: Skipping file %s: Artifact %s not found in repository%n", path, artifact);
            ++this.failureCount;
            return;
        }
        Path artifactPath = Paths.get(metadata.getPath(), new String[0]);
        if (!this.dryRun) {
            Files.delete(path);
            Files.createSymbolicLink(path, artifactPath, new FileAttribute[0]);
        }
        System.err.printf("Linked %s to %s%n", path, artifactPath);
    }

    private ArtifactMetadata resolveMetadata(Artifact artifact) {
        List<Artifact> versionedArtifacts = Arrays.asList(artifact, artifact.setVersion(null));
        for (MetadataResult metadataResult : this.metadata) {
            for (Artifact versionedArtifact : versionedArtifacts) {
                ArtifactMetadata metadata = metadataResult.getMetadataFor(versionedArtifact);
                if (metadata == null) continue;
                return metadata;
            }
        }
        return null;
    }
}

