/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.File;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.SourceHistory;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;

public final class TargetInfo {
    private static final File[] emptyFileArray = new File[0];
    private ProcessorConfiguration config;
    private File output;
    private boolean rebuild;
    private File[] sources;
    private File[] sysSources;

    public TargetInfo(ProcessorConfiguration config, File[] sources, File[] sysSources, File output, boolean rebuild) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        if (sources == null) {
            throw new NullPointerException("sources");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.config = config;
        this.sources = (File[])sources.clone();
        this.sysSources = sysSources == null ? emptyFileArray : (File[])sysSources.clone();
        this.output = output;
        this.rebuild = rebuild;
        if (!output.exists()) {
            rebuild = true;
        }
    }

    public String[] getAllSourcePaths() {
        String[] paths = new String[this.sysSources.length + this.sources.length];
        int i = 0;
        while (i < this.sysSources.length) {
            paths[i] = this.sysSources[i].toString();
            ++i;
        }
        int offset = this.sysSources.length;
        int i2 = 0;
        while (i2 < this.sources.length) {
            paths[offset + i2] = this.sources[i2].toString();
            ++i2;
        }
        return paths;
    }

    public File[] getAllSources() {
        File[] allSources = new File[this.sources.length + this.sysSources.length];
        int i = 0;
        while (i < this.sysSources.length) {
            allSources[i] = this.sysSources[i];
            ++i;
        }
        int offset = this.sysSources.length;
        int i2 = 0;
        while (i2 < this.sources.length) {
            allSources[i2 + offset] = this.sources[i2];
            ++i2;
        }
        return allSources;
    }

    public ProcessorConfiguration getConfiguration() {
        return this.config;
    }

    public File getOutput() {
        return this.output;
    }

    public boolean getRebuild() {
        return this.rebuild;
    }

    public SourceHistory[] getSourceHistories(String basePath) {
        SourceHistory[] histories = new SourceHistory[this.sources.length];
        int i = 0;
        while (i < this.sources.length) {
            String relativeName = CUtil.getRelativePath(basePath, this.sources[i]);
            long lastModified = this.sources[i].lastModified();
            histories[i] = new SourceHistory(relativeName, lastModified);
            ++i;
        }
        return histories;
    }

    public String[] getSourcePaths() {
        String[] paths = new String[this.sources.length];
        int i = 0;
        while (i < this.sources.length) {
            paths[i] = this.sources[i].toString();
            ++i;
        }
        return paths;
    }

    public File[] getSources() {
        File[] clone = (File[])this.sources.clone();
        return clone;
    }

    public String[] getSysSourcePaths() {
        String[] paths = new String[this.sysSources.length];
        int i = 0;
        while (i < this.sysSources.length) {
            paths[i] = this.sysSources[i].toString();
            ++i;
        }
        return paths;
    }

    public File[] getSysSources() {
        File[] clone = (File[])this.sysSources.clone();
        return clone;
    }

    public void mustRebuild() {
        this.rebuild = true;
    }
}

