/*
 * Decompiled with CFR 0.152.
 */
package JFlex.anttask;

import JFlex.GeneratorException;
import JFlex.anttask.JFlexWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JFlexTask
extends Task {
    private File destinationDir;
    private File inputFile;
    private JFlexWrapper wrapper = new JFlexWrapper();
    private boolean verbose = false;
    private boolean generateDot = false;
    private boolean skipMin = false;
    private boolean displayTime = false;
    private File skeletonFile = null;

    public void execute() throws BuildException {
        try {
            if (this.inputFile == null) {
                throw new BuildException("You must specify the input file for JFlex!");
            }
            this.processFile(this.inputFile);
        }
        catch (GeneratorException e) {
            throw new BuildException("JFlex: generation failed!");
        }
    }

    public void setDestdir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public void setFile(File file) {
        this.inputFile = file;
    }

    public void setGenerateDot(boolean genDot) {
        this.generateDot = genDot;
    }

    public void setTimeStatistics(boolean displayTime) {
        this.displayTime = displayTime;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setSkeleton(File skeleton) {
        this.skeletonFile = skeleton;
    }

    public void setSkipMinimization(boolean skipMin) {
        this.skipMin = skipMin;
    }

    protected void processFile(File file) throws BuildException {
        try {
            String line;
            String packageName = null;
            String className = null;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = reader.readLine()) != null) {
                int end;
                int index;
                if (packageName == null && (index = line.indexOf("package")) != -1 && (end = line.indexOf(59, index += 7)) != -1) {
                    packageName = line.substring(index, end);
                    packageName = packageName.trim();
                }
                if (className == null && (index = line.indexOf("%class")) != -1) {
                    className = line.substring(index += 6);
                    className = className.trim();
                }
                if (className == null || packageName == null) continue;
                break;
            }
            if (className == null) {
                className = "Yylex";
            }
            StringBuffer destDir = new StringBuffer();
            if (this.destinationDir != null) {
                destDir.append(this.destinationDir.getAbsolutePath());
                if (packageName != null) {
                    destDir.append(File.separatorChar);
                    String path = packageName.replace('.', File.separatorChar);
                    destDir.append(path);
                }
            } else {
                destDir.append(file.getParent());
            }
            File destFile = new File(destDir.toString() + File.separator + className + ".java");
            if (file.lastModified() > destFile.lastModified()) {
                this.wrapper.setTimeStatistics(this.displayTime);
                this.wrapper.setVerbose(this.verbose);
                this.wrapper.setGenerateDot(this.generateDot);
                this.wrapper.setSkipMinimization(this.skipMin);
                this.wrapper.setSkeleton(this.skeletonFile);
                this.wrapper.setDestinationDir(destDir.toString());
                this.wrapper.generate(file);
                if (!this.verbose) {
                    System.out.println("Generated: " + destFile.getName());
                }
            }
        }
        catch (IOException e) {
            throw new BuildException("IOException: " + e.toString());
        }
    }
}

