pub const DEFAULT_IO_MAX_SIZE: usize = 32 * 1024;

pub const AES_BLOCK_SIZE: usize = 16;
pub const AES_256_KEY_LEN: usize = 32;
pub const SHA1_HMAC_LEN: usize = 12;

// Tested on a 3.2GHz aarch64 machine to hit ~1 second with a --release build with at least
// 0x40_0000 rounds. The goal would be 0x150_000 in a perfect world though.
#[cfg(test)]
pub const PBKDF2_SHA1_ITER_MINIMUM: u32 = 0x0100;
#[cfg(not(test))]
pub const PBKDF2_SHA1_ITER_MINIMUM: u32 = 0x4000;

pub const PBKDF2_SHA1_ITER: u32 = 0x8900;
pub const RFC_PBKDF2_SHA1_ITER: u32 = 0x1000;

pub const IV_ZERO: [u8; AES_BLOCK_SIZE] = [0u8; AES_BLOCK_SIZE];

// In the DK phase of key derivation, a pub constant is used with the nfold algorithm. Since this
// is a pub constant, we don't need to derive it at run time, we can just staticly define it.
// pub const DK_CONSTANT: &[u8] = b"kerberos";
pub const N_FOLD_KERBEROS_16: [u8; 16] = [
    0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x7b, 0x9b, 0x5b, 0x2b, 0x93, 0x13, 0x2b, 0x93,
];
// pub const N_FOLD_KERBEROS_32: [u8; 32] = [
//     0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x7b, 0x9b, 0x5b, 0x2b, 0x93, 0x13, 0x2b, 0x93,
//     0x5c, 0x9b, 0xdc, 0xda, 0xd9, 0x5c, 0x98, 0x99, 0xc4, 0xca, 0xe4, 0xde, 0xe6, 0xd6, 0xca, 0xe4
// ];

// This is a table of all the pre-calculated key usage values.
pub const N_FOLD_KEY_USAGE_KI_00: [u8; 16] = [
    0x52, 0xd3, 0xe9, 0xf4, 0xfa, 0x52, 0xa8, 0x1, 0x54, 0xaa, 0x55, 0x2a, 0x95, 0x40, 0xa, 0xa5,
];
pub const N_FOLD_KEY_USAGE_KE_00: [u8; 16] = [
    0xa5, 0xa7, 0xd3, 0xe9, 0xf4, 0xa5, 0x50, 0x2, 0xa9, 0x54, 0xaa, 0x55, 0x2a, 0x80, 0x15, 0x4a,
];
pub const N_FOLD_KEY_USAGE_KC_00: [u8; 16] = [
    0x95, 0x17, 0x0B, 0x85, 0xC2, 0x94, 0xC8, 0x02, 0x65, 0x32, 0x99, 0x4C, 0xA6, 0x40, 0x13, 0x29,
];

pub const N_FOLD_KEY_USAGE_KI_01: [u8; 16] = [
    0x5b, 0x58, 0x2c, 0x16, 0xa, 0x5a, 0xa8, 0x5, 0x56, 0xab, 0x55, 0xaa, 0xd5, 0x40, 0x2a, 0xb5,
];
pub const N_FOLD_KEY_USAGE_KE_01: [u8; 16] = [
    0xae, 0x2c, 0x16, 0xb, 0x4, 0xad, 0x50, 0x6, 0xab, 0x55, 0xaa, 0xd5, 0x6a, 0x80, 0x35, 0x5a,
];
pub const N_FOLD_KEY_USAGE_KC_01: [u8; 16] = [
    0x9D, 0x9B, 0x4D, 0xA6, 0xD2, 0x9C, 0xC8, 0x06, 0x67, 0x33, 0x99, 0xCC, 0xE6, 0x40, 0x33, 0x39,
];

pub const N_FOLD_KEY_USAGE_KI_02: [u8; 16] = [
    0x62, 0xdc, 0x6e, 0x37, 0x1a, 0x63, 0xa8, 0x9, 0x58, 0xac, 0x56, 0x2b, 0x15, 0x40, 0x4a, 0xc5,
];
pub const N_FOLD_KEY_USAGE_KE_02: [u8; 16] = [
    0xb5, 0xb0, 0x58, 0x2c, 0x14, 0xb6, 0x50, 0xa, 0xad, 0x56, 0xab, 0x55, 0xaa, 0x80, 0x55, 0x6a,
];
pub const N_FOLD_KEY_USAGE_KC_02: [u8; 16] = [
    0xA5, 0x1F, 0x8F, 0xC7, 0xE2, 0xA5, 0xC8, 0x0A, 0x69, 0x34, 0x9A, 0x4D, 0x26, 0x40, 0x53, 0x49,
];

pub const N_FOLD_KEY_USAGE_KI_03: [u8; 16] = [
    0x6b, 0x60, 0xb0, 0x58, 0x2a, 0x6b, 0xa8, 0xd, 0x5a, 0xad, 0x56, 0xab, 0x55, 0x40, 0x6a, 0xd5,
];
pub const N_FOLD_KEY_USAGE_KE_03: [u8; 16] = [
    0xbe, 0x34, 0x9a, 0x4d, 0x24, 0xbe, 0x50, 0xe, 0xaf, 0x57, 0xab, 0xd5, 0xea, 0x80, 0x75, 0x7a,
];
pub const N_FOLD_KEY_USAGE_KC_03: [u8; 16] = [
    0xAD, 0xA3, 0xD1, 0xE8, 0xF2, 0xAD, 0xC8, 0x0E, 0x6B, 0x35, 0x9A, 0xCD, 0x66, 0x40, 0x73, 0x59,
];

pub const N_FOLD_KEY_USAGE_KI_04: [u8; 16] = [
    0x72, 0xe3, 0xf2, 0x79, 0x3a, 0x74, 0xa9, 0x11, 0x5c, 0xae, 0x57, 0x2b, 0x95, 0x40, 0x8a, 0xe5,
];
pub const N_FOLD_KEY_USAGE_KE_04: [u8; 16] = [
    0xc5, 0xb7, 0xdc, 0x6e, 0x34, 0xc7, 0x51, 0x12, 0xb1, 0x58, 0xac, 0x56, 0x2a, 0x80, 0x95, 0x8a,
];
pub const N_FOLD_KEY_USAGE_KC_04: [u8; 16] = [
    0xB5, 0x27, 0x14, 0x0A, 0x02, 0xB6, 0xC9, 0x12, 0x6D, 0x36, 0x9B, 0x4D, 0xA6, 0x40, 0x93, 0x69,
];

pub const N_FOLD_KEY_USAGE_KI_05: [u8; 16] = [
    0x7b, 0x68, 0x34, 0x9a, 0x4a, 0x7c, 0xa9, 0x15, 0x5e, 0xaf, 0x57, 0xab, 0xd5, 0x40, 0xaa, 0xf5,
];
pub const N_FOLD_KEY_USAGE_KE_05: [u8; 16] = [
    0xce, 0x3c, 0x1e, 0x8f, 0x44, 0xcf, 0x51, 0x16, 0xb3, 0x59, 0xac, 0xd6, 0x6a, 0x80, 0xb5, 0x9a,
];
pub const N_FOLD_KEY_USAGE_KC_05: [u8; 16] = [
    0xBD, 0xAB, 0x56, 0x2B, 0x12, 0xBE, 0xC9, 0x16, 0x6F, 0x37, 0x9B, 0xCD, 0xE6, 0x40, 0xB3, 0x79,
];

pub const N_FOLD_KEY_USAGE_KI_06: [u8; 16] = [
    0x82, 0xec, 0x76, 0xbb, 0x5a, 0x85, 0xa9, 0x19, 0x60, 0xb0, 0x58, 0x2c, 0x15, 0x40, 0xcb, 0x5,
];
pub const N_FOLD_KEY_USAGE_KE_06: [u8; 16] = [
    0xd5, 0xc0, 0x60, 0xb0, 0x54, 0xd8, 0x51, 0x1a, 0xb5, 0x5a, 0xad, 0x56, 0xaa, 0x80, 0xd5, 0xaa,
];
pub const N_FOLD_KEY_USAGE_KC_06: [u8; 16] = [
    0xC5, 0x2F, 0x98, 0x4C, 0x22, 0xC7, 0xC9, 0x1A, 0x71, 0x38, 0x9C, 0x4E, 0x26, 0x40, 0xD3, 0x89,
];

pub const N_FOLD_KEY_USAGE_KI_07: [u8; 16] = [
    0x8b, 0x70, 0xb8, 0xdc, 0x6a, 0x8d, 0xa9, 0x1d, 0x62, 0xb1, 0x58, 0xac, 0x55, 0x40, 0xeb, 0x15,
];
pub const N_FOLD_KEY_USAGE_KE_07: [u8; 16] = [
    0xde, 0x44, 0xa2, 0xd1, 0x64, 0xe0, 0x51, 0x1e, 0xb7, 0x5b, 0xad, 0xd6, 0xea, 0x80, 0xf5, 0xba,
];
pub const N_FOLD_KEY_USAGE_KC_07: [u8; 16] = [
    0xCD, 0xB3, 0xDA, 0x6D, 0x32, 0xCF, 0xC9, 0x1E, 0x73, 0x39, 0x9C, 0xCE, 0x66, 0x40, 0xF3, 0x99,
];

pub const N_FOLD_KEY_USAGE_KI_08: [u8; 16] = [
    0x92, 0xf3, 0xf9, 0xfd, 0x7a, 0x96, 0xaa, 0x22, 0x64, 0xb2, 0x59, 0x2c, 0x95, 0x41, 0xb, 0x25,
];
pub const N_FOLD_KEY_USAGE_KE_08: [u8; 16] = [
    0xe5, 0xc7, 0xe3, 0xf2, 0x74, 0xe9, 0x52, 0x23, 0xb9, 0x5c, 0xae, 0x57, 0x2a, 0x81, 0x15, 0xca,
];
pub const N_FOLD_KEY_USAGE_KC_08: [u8; 16] = [
    0xD5, 0x37, 0x1B, 0x8E, 0x42, 0xD8, 0xCA, 0x23, 0x75, 0x3A, 0x9D, 0x4E, 0xA6, 0x41, 0x13, 0xA9,
];

pub const N_FOLD_KEY_USAGE_KI_09: [u8; 16] = [
    0x9b, 0x78, 0x3c, 0x1e, 0x8a, 0x9e, 0xaa, 0x26, 0x66, 0xb3, 0x59, 0xac, 0xd5, 0x41, 0x2b, 0x35,
];
pub const N_FOLD_KEY_USAGE_KE_09: [u8; 16] = [
    0xee, 0x4c, 0x26, 0x13, 0x84, 0xf1, 0x52, 0x27, 0xbb, 0x5d, 0xae, 0xd7, 0x6a, 0x81, 0x35, 0xda,
];
pub const N_FOLD_KEY_USAGE_KC_09: [u8; 16] = [
    0xDD, 0xBB, 0x5D, 0xAF, 0x52, 0xE0, 0xCA, 0x27, 0x77, 0x3B, 0x9D, 0xCE, 0xE6, 0x41, 0x33, 0xB9,
];

pub const N_FOLD_KEY_USAGE_KI_10: [u8; 16] = [
    0xa2, 0xfc, 0x7e, 0x3f, 0x9a, 0xa7, 0xaa, 0x2a, 0x68, 0xb4, 0x5a, 0x2d, 0x15, 0x41, 0x4b, 0x45,
];
pub const N_FOLD_KEY_USAGE_KE_10: [u8; 16] = [
    0xf5, 0xd0, 0x68, 0x34, 0x94, 0xfa, 0x52, 0x2b, 0xbd, 0x5e, 0xaf, 0x57, 0xaa, 0x81, 0x55, 0xea,
];
pub const N_FOLD_KEY_USAGE_KC_10: [u8; 16] = [
    0xE5, 0x3F, 0x9F, 0xD0, 0x62, 0xE9, 0xCA, 0x2B, 0x79, 0x3C, 0x9E, 0x4F, 0x26, 0x41, 0x53, 0xC9,
];

pub const N_FOLD_KEY_USAGE_KI_11: [u8; 16] = [
    0xab, 0x80, 0xc0, 0x60, 0xaa, 0xaf, 0xaa, 0x2e, 0x6a, 0xb5, 0x5a, 0xad, 0x55, 0x41, 0x6b, 0x55,
];
pub const N_FOLD_KEY_USAGE_KE_11: [u8; 16] = [
    0xfe, 0x54, 0xaa, 0x55, 0xa5, 0x2, 0x52, 0x2f, 0xbf, 0x5f, 0xaf, 0xd7, 0xea, 0x81, 0x75, 0xfa,
];
pub const N_FOLD_KEY_USAGE_KC_11: [u8; 16] = [
    0xED, 0xC3, 0xE1, 0xF1, 0x72, 0xF1, 0xCA, 0x2F, 0x7B, 0x3D, 0x9E, 0xCF, 0x66, 0x41, 0x73, 0xD9,
];

pub const N_FOLD_KEY_USAGE_KI_12: [u8; 16] = [
    0xb3, 0x4, 0x2, 0x81, 0xba, 0xb8, 0xab, 0x32, 0x6c, 0xb6, 0x5b, 0x2d, 0x95, 0x41, 0x8b, 0x65,
];
pub const N_FOLD_KEY_USAGE_KE_12: [u8; 16] = [
    0x5, 0xd7, 0xec, 0x76, 0xb5, 0xb, 0x53, 0x33, 0xc1, 0x60, 0xb0, 0x58, 0x2a, 0x81, 0x96, 0xb,
];
pub const N_FOLD_KEY_USAGE_KC_12: [u8; 16] = [
    0xF5, 0x47, 0x24, 0x12, 0x82, 0xFA, 0xCB, 0x33, 0x7D, 0x3E, 0x9F, 0x4F, 0xA6, 0x41, 0x93, 0xE9,
];

pub const N_FOLD_KEY_USAGE_KI_13: [u8; 16] = [
    0xbb, 0x88, 0x44, 0xa2, 0xca, 0xc0, 0xab, 0x36, 0x6e, 0xb7, 0x5b, 0xad, 0xd5, 0x41, 0xab, 0x75,
];
pub const N_FOLD_KEY_USAGE_KE_13: [u8; 16] = [
    0xe, 0x5c, 0x2e, 0x97, 0xc5, 0x13, 0x53, 0x37, 0xc3, 0x61, 0xb0, 0xd8, 0x6a, 0x81, 0xb6, 0x1b,
];
pub const N_FOLD_KEY_USAGE_KC_13: [u8; 16] = [
    0xFD, 0xCB, 0x66, 0x33, 0x93, 0x02, 0xCB, 0x37, 0x7F, 0x3F, 0x9F, 0xCF, 0xE6, 0x41, 0xB3, 0xF9,
];

pub const N_FOLD_KEY_USAGE_KI_14: [u8; 16] = [
    0xc3, 0xc, 0x86, 0xc3, 0xda, 0xc9, 0xab, 0x3a, 0x70, 0xb8, 0x5c, 0x2e, 0x15, 0x41, 0xcb, 0x85,
];
pub const N_FOLD_KEY_USAGE_KE_14: [u8; 16] = [
    0x15, 0xe0, 0x70, 0xb8, 0xd5, 0x1c, 0x53, 0x3b, 0xc5, 0x62, 0xb1, 0x58, 0xaa, 0x81, 0xd6, 0x2b,
];
pub const N_FOLD_KEY_USAGE_KC_14: [u8; 16] = [
    0x05, 0x4F, 0xA8, 0x54, 0xA3, 0x0B, 0xCB, 0x3B, 0x81, 0x40, 0xA0, 0x50, 0x26, 0x41, 0xD4, 0x0A,
];

pub const N_FOLD_KEY_USAGE_KI_15: [u8; 16] = [
    0xcb, 0x90, 0xc8, 0xe4, 0xea, 0xd1, 0xab, 0x3e, 0x72, 0xb9, 0x5c, 0xae, 0x55, 0x41, 0xeb, 0x95,
];
pub const N_FOLD_KEY_USAGE_KE_15: [u8; 16] = [
    0x1e, 0x64, 0xb2, 0xd9, 0xe5, 0x24, 0x53, 0x3f, 0xc7, 0x63, 0xb1, 0xd8, 0xea, 0x81, 0xf6, 0x3b,
];
pub const N_FOLD_KEY_USAGE_KC_15: [u8; 16] = [
    0x0D, 0xD3, 0xEA, 0x75, 0xB3, 0x13, 0xCB, 0x3F, 0x83, 0x41, 0xA0, 0xD0, 0x66, 0x41, 0xF4, 0x1A,
];

pub const N_FOLD_KEY_USAGE_KI_16: [u8; 16] = [
    0xd3, 0x14, 0xa, 0x4, 0xfa, 0xda, 0xac, 0x43, 0x75, 0xba, 0x5d, 0x2e, 0x95, 0x42, 0xb, 0xa5,
];
pub const N_FOLD_KEY_USAGE_KE_16: [u8; 16] = [
    0x25, 0xe7, 0xf3, 0xf9, 0xf5, 0x2d, 0x54, 0x44, 0xca, 0x64, 0xb2, 0x59, 0x2a, 0x82, 0x16, 0x4b,
];
pub const N_FOLD_KEY_USAGE_KC_16: [u8; 16] = [
    0x15, 0x57, 0x2B, 0x95, 0xC3, 0x1C, 0xCC, 0x44, 0x86, 0x42, 0xA1, 0x50, 0xA6, 0x42, 0x14, 0x2A,
];

pub const N_FOLD_KEY_USAGE_KI_17: [u8; 16] = [
    0xdb, 0x98, 0x4c, 0x26, 0xa, 0xe2, 0xac, 0x47, 0x77, 0xbb, 0x5d, 0xae, 0xd5, 0x42, 0x2b, 0xb5,
];
pub const N_FOLD_KEY_USAGE_KE_17: [u8; 16] = [
    0x2e, 0x6c, 0x36, 0x1b, 0x5, 0x35, 0x54, 0x48, 0xcc, 0x65, 0xb2, 0xd9, 0x6a, 0x82, 0x36, 0x5b,
];
pub const N_FOLD_KEY_USAGE_KC_17: [u8; 16] = [
    0x1D, 0xDB, 0x6D, 0xB6, 0xD3, 0x24, 0xCC, 0x48, 0x88, 0x43, 0xA1, 0xD0, 0xE6, 0x42, 0x34, 0x3A,
];

pub const N_FOLD_KEY_USAGE_KI_18: [u8; 16] = [
    0xe3, 0x1c, 0x8e, 0x47, 0x1a, 0xeb, 0xac, 0x4b, 0x79, 0xbc, 0x5e, 0x2f, 0x15, 0x42, 0x4b, 0xc5,
];
pub const N_FOLD_KEY_USAGE_KE_18: [u8; 16] = [
    0x35, 0xf0, 0x78, 0x3c, 0x15, 0x3e, 0x54, 0x4c, 0xce, 0x66, 0xb3, 0x59, 0xaa, 0x82, 0x56, 0x6b,
];
pub const N_FOLD_KEY_USAGE_KC_18: [u8; 16] = [
    0x25, 0x5F, 0xAF, 0xD7, 0xE3, 0x2D, 0xCC, 0x4C, 0x8A, 0x44, 0xA2, 0x51, 0x26, 0x42, 0x54, 0x4A,
];

pub const N_FOLD_KEY_USAGE_KI_19: [u8; 16] = [
    0xeb, 0xa0, 0xd0, 0x68, 0x2a, 0xf3, 0xac, 0x4f, 0x7b, 0xbd, 0x5e, 0xaf, 0x55, 0x42, 0x6b, 0xd5,
];
pub const N_FOLD_KEY_USAGE_KE_19: [u8; 16] = [
    0x3e, 0x74, 0xba, 0x5d, 0x25, 0x46, 0x54, 0x50, 0xd0, 0x67, 0xb3, 0xd9, 0xea, 0x82, 0x76, 0x7b,
];
pub const N_FOLD_KEY_USAGE_KC_19: [u8; 16] = [
    0x2D, 0xE3, 0xF1, 0xF8, 0xF3, 0x35, 0xCC, 0x50, 0x8C, 0x45, 0xA2, 0xD1, 0x66, 0x42, 0x74, 0x5A,
];

pub const N_FOLD_KEY_USAGE_KI_20: [u8; 16] = [
    0xf3, 0x24, 0x12, 0x89, 0x3a, 0xfc, 0xad, 0x53, 0x7d, 0xbe, 0x5f, 0x2f, 0x95, 0x42, 0x8b, 0xe5,
];
pub const N_FOLD_KEY_USAGE_KE_20: [u8; 16] = [
    0x45, 0xf7, 0xfc, 0x7e, 0x35, 0x4f, 0x55, 0x54, 0xd2, 0x68, 0xb4, 0x5a, 0x2a, 0x82, 0x96, 0x8b,
];
pub const N_FOLD_KEY_USAGE_KC_20: [u8; 16] = [
    0x35, 0x67, 0x34, 0x1A, 0x03, 0x3E, 0xCD, 0x54, 0x8E, 0x46, 0xA3, 0x51, 0xA6, 0x42, 0x94, 0x6A,
];

pub const N_FOLD_KEY_USAGE_KI_21: [u8; 16] = [
    0xfb, 0xa8, 0x54, 0xaa, 0x4b, 0x4, 0xad, 0x57, 0x7f, 0xbf, 0x5f, 0xaf, 0xd5, 0x42, 0xab, 0xf5,
];
pub const N_FOLD_KEY_USAGE_KE_21: [u8; 16] = [
    0x4e, 0x7c, 0x3e, 0x9f, 0x45, 0x57, 0x55, 0x58, 0xd4, 0x69, 0xb4, 0xda, 0x6a, 0x82, 0xb6, 0x9b,
];
pub const N_FOLD_KEY_USAGE_KC_21: [u8; 16] = [
    0x3D, 0xEB, 0x76, 0x3B, 0x13, 0x46, 0xCD, 0x58, 0x90, 0x47, 0xA3, 0xD1, 0xE6, 0x42, 0xB4, 0x7A,
];

pub const N_FOLD_KEY_USAGE_KI_22: [u8; 16] = [
    0x3, 0x2c, 0x96, 0xcb, 0x5b, 0xd, 0xad, 0x5b, 0x81, 0xc0, 0x60, 0x30, 0x15, 0x42, 0xcc, 0x6,
];
pub const N_FOLD_KEY_USAGE_KE_22: [u8; 16] = [
    0x56, 0x0, 0x80, 0xc0, 0x55, 0x60, 0x55, 0x5c, 0xd6, 0x6a, 0xb5, 0x5a, 0xaa, 0x82, 0xd6, 0xab,
];
pub const N_FOLD_KEY_USAGE_KC_22: [u8; 16] = [
    0x45, 0x6F, 0xB8, 0x5C, 0x23, 0x4F, 0xCD, 0x5C, 0x92, 0x48, 0xA4, 0x52, 0x26, 0x42, 0xD4, 0x8A,
];

pub const N_FOLD_KEY_USAGE_KI_23: [u8; 16] = [
    0xb, 0xb0, 0xd8, 0xec, 0x6b, 0x15, 0xad, 0x5f, 0x83, 0xc1, 0x60, 0xb0, 0x55, 0x42, 0xec, 0x16,
];
pub const N_FOLD_KEY_USAGE_KE_23: [u8; 16] = [
    0x5e, 0x84, 0xc2, 0xe1, 0x65, 0x68, 0x55, 0x60, 0xd8, 0x6b, 0xb5, 0xda, 0xea, 0x82, 0xf6, 0xbb,
];
pub const N_FOLD_KEY_USAGE_KC_23: [u8; 16] = [
    0x4D, 0xF3, 0xFA, 0x7D, 0x33, 0x57, 0xCD, 0x60, 0x94, 0x49, 0xA4, 0xD2, 0x66, 0x42, 0xF4, 0x9A,
];

pub const N_FOLD_KEY_USAGE_KI_24: [u8; 16] = [
    0x13, 0x34, 0x1a, 0xd, 0x7b, 0x1e, 0xae, 0x64, 0x85, 0xc2, 0x61, 0x30, 0x95, 0x43, 0xc, 0x26,
];
pub const N_FOLD_KEY_USAGE_KE_24: [u8; 16] = [
    0x66, 0x8, 0x4, 0x2, 0x75, 0x71, 0x56, 0x65, 0xda, 0x6c, 0xb6, 0x5b, 0x2a, 0x83, 0x16, 0xcb,
];
pub const N_FOLD_KEY_USAGE_KC_24: [u8; 16] = [
    0x55, 0x77, 0x3B, 0x9E, 0x43, 0x60, 0xCE, 0x65, 0x96, 0x4A, 0xA5, 0x52, 0xA6, 0x43, 0x14, 0xAA,
];

pub const N_FOLD_KEY_USAGE_KI_25: [u8; 16] = [
    0x1b, 0xb8, 0x5c, 0x2e, 0x8b, 0x26, 0xae, 0x68, 0x87, 0xc3, 0x61, 0xb0, 0xd5, 0x43, 0x2c, 0x36,
];
pub const N_FOLD_KEY_USAGE_KE_25: [u8; 16] = [
    0x6e, 0x8c, 0x46, 0x23, 0x85, 0x79, 0x56, 0x69, 0xdc, 0x6d, 0xb6, 0xdb, 0x6a, 0x83, 0x36, 0xdb,
];
pub const N_FOLD_KEY_USAGE_KC_25: [u8; 16] = [
    0x5D, 0xFB, 0x7D, 0xBF, 0x53, 0x68, 0xCE, 0x69, 0x98, 0x4B, 0xA5, 0xD2, 0xE6, 0x43, 0x34, 0xBA,
];

pub const N_FOLD_KEY_USAGE_KI_26: [u8; 16] = [
    0x23, 0x3c, 0x9e, 0x4f, 0x9b, 0x2f, 0xae, 0x6c, 0x89, 0xc4, 0x62, 0x31, 0x15, 0x43, 0x4c, 0x46,
];
pub const N_FOLD_KEY_USAGE_KE_26: [u8; 16] = [
    0x76, 0x10, 0x88, 0x44, 0x95, 0x82, 0x56, 0x6d, 0xde, 0x6e, 0xb7, 0x5b, 0xaa, 0x83, 0x56, 0xeb,
];
pub const N_FOLD_KEY_USAGE_KC_26: [u8; 16] = [
    0x65, 0x7F, 0xBF, 0xE0, 0x63, 0x71, 0xCE, 0x6D, 0x9A, 0x4C, 0xA6, 0x53, 0x26, 0x43, 0x54, 0xCA,
];

pub const N_FOLD_KEY_USAGE_KI_27: [u8; 16] = [
    0x2b, 0xc0, 0xe0, 0x70, 0xab, 0x37, 0xae, 0x70, 0x8b, 0xc5, 0x62, 0xb1, 0x55, 0x43, 0x6c, 0x56,
];
pub const N_FOLD_KEY_USAGE_KE_27: [u8; 16] = [
    0x7e, 0x94, 0xca, 0x65, 0xa5, 0x8a, 0x56, 0x71, 0xe0, 0x6f, 0xb7, 0xdb, 0xea, 0x83, 0x76, 0xfb,
];
pub const N_FOLD_KEY_USAGE_KC_27: [u8; 16] = [
    0x6E, 0x04, 0x02, 0x01, 0x73, 0x79, 0xCE, 0x71, 0x9C, 0x4D, 0xA6, 0xD3, 0x66, 0x43, 0x74, 0xDA,
];

pub const N_FOLD_KEY_USAGE_KI_28: [u8; 16] = [
    0x33, 0x44, 0x22, 0x91, 0xbb, 0x40, 0xaf, 0x74, 0x8d, 0xc6, 0x63, 0x31, 0x95, 0x43, 0x8c, 0x66,
];
pub const N_FOLD_KEY_USAGE_KE_28: [u8; 16] = [
    0x86, 0x18, 0xc, 0x86, 0xb5, 0x93, 0x57, 0x75, 0xe2, 0x70, 0xb8, 0x5c, 0x2a, 0x83, 0x97, 0xb,
];
pub const N_FOLD_KEY_USAGE_KC_28: [u8; 16] = [
    0x75, 0x87, 0x44, 0x22, 0x83, 0x82, 0xCF, 0x75, 0x9E, 0x4E, 0xA7, 0x53, 0xA6, 0x43, 0x94, 0xEA,
];

pub const N_FOLD_KEY_USAGE_KI_29: [u8; 16] = [
    0x3b, 0xc8, 0x64, 0xb2, 0xcb, 0x48, 0xaf, 0x78, 0x8f, 0xc7, 0x63, 0xb1, 0xd5, 0x43, 0xac, 0x76,
];
pub const N_FOLD_KEY_USAGE_KE_29: [u8; 16] = [
    0x8e, 0x9c, 0x4e, 0xa7, 0xc5, 0x9b, 0x57, 0x79, 0xe4, 0x71, 0xb8, 0xdc, 0x6a, 0x83, 0xb7, 0x1b,
];
pub const N_FOLD_KEY_USAGE_KC_29: [u8; 16] = [
    0x7E, 0x0B, 0x86, 0x43, 0x93, 0x8A, 0xCF, 0x79, 0xA0, 0x4F, 0xA7, 0xD3, 0xE6, 0x43, 0xB4, 0xFA,
];

pub const N_FOLD_KEY_USAGE_KI_30: [u8; 16] = [
    0x43, 0x4c, 0xa6, 0xd3, 0xdb, 0x51, 0xaf, 0x7c, 0x91, 0xc8, 0x64, 0x32, 0x15, 0x43, 0xcc, 0x86,
];
pub const N_FOLD_KEY_USAGE_KE_30: [u8; 16] = [
    0x96, 0x20, 0x90, 0xc8, 0xd5, 0xa4, 0x57, 0x7d, 0xe6, 0x72, 0xb9, 0x5c, 0xaa, 0x83, 0xd7, 0x2b,
];
pub const N_FOLD_KEY_USAGE_KC_30: [u8; 16] = [
    0x85, 0x8F, 0xC8, 0x64, 0xA3, 0x93, 0xCF, 0x7D, 0xA2, 0x50, 0xA8, 0x54, 0x26, 0x43, 0xD5, 0x0A,
];

pub const N_FOLD_KEY_USAGE_KI_31: [u8; 16] = [
    0x4b, 0xd0, 0xe8, 0xf4, 0xeb, 0x59, 0xaf, 0x80, 0x93, 0xc9, 0x64, 0xb2, 0x55, 0x43, 0xec, 0x96,
];
pub const N_FOLD_KEY_USAGE_KE_31: [u8; 16] = [
    0x9e, 0xa4, 0xd2, 0xe9, 0xe5, 0xac, 0x57, 0x81, 0xe8, 0x73, 0xb9, 0xdc, 0xea, 0x83, 0xf7, 0x3b,
];
pub const N_FOLD_KEY_USAGE_KC_31: [u8; 16] = [
    0x8E, 0x14, 0x0A, 0x85, 0xB3, 0x9B, 0xCF, 0x81, 0xA4, 0x51, 0xA8, 0xD4, 0x66, 0x43, 0xF5, 0x1A,
];
