Compact JWT / JWE
=================

Json Web Tokens (JWT) are a popular method for creating signed transparent tokens that can be verified
by clients and servers. They are enshrined in standards like OpenID Connect which causes them to
be a widespread and required component of many modern web authentication system.

Json Web Encryption (JWE) is an occasionally used method for sending secrets to a recipient
or to create opaque tokens for services.

JWE, JWT, and Json Web Signature (JWS) however have a long track record of handling issues, which have
led to security issues. This library will not be a complete implementation of JWE/JWT/JWS, instead
focusing on a minimal subset that can be secured and audited for correctness more closely within
a limited set of use cases.

When should I use this library?
-------------------------------

If you are:

* creating ECDSA signed JWT tokens, or verify ECDSA signed JWT tokens
* implementing OIDC as a relying party or authorisation server
* wanting to use HMAC signatures for transparent json data
* needing a minimal secure JWS implementation
* using TPM bound keys for signing JWTs
* creating opaque encrypted tokens protected with AES-128-GCM
* receiving or sending encrypted data to an ECDSA key

Then this library is for you

If you need non-compact JWS, or other complex use cases, this library is not for you.

Why another JWT library?
------------------------

There are already many other libraries for JWT on crates.io however they each have a limitation
or design that conflicts with the project goals in Kanidm. Examples are:

* Incorrect Implementations - There are a number of JWT libraries in Rust that are incorrect to the RFC or do not have RFC vector tests
* Only supporting RSA/Weak cryptographic algos - We want to use ECDSA and modern cryptography
* Full JWS implementation - As mentioned, JWS has a number of sharp edges like alg=none
* No library supports pkcs11 or TPMS - We aim to allow hardware security modules to store private keys

As a result, nothing "fit" what we wanted, so we are making another library.

