// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v1.7.2 with parameter "target=js+dts"
// @generated from file livekit_agent.proto (package livekit, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import { proto3 } from "@bufbuild/protobuf";
import { ParticipantInfo, Room } from "./livekit_models_pb.js";

/**
 * @generated from enum livekit.JobType
 */
export const JobType = proto3.makeEnum(
  "livekit.JobType",
  [
    {no: 0, name: "JT_ROOM"},
    {no: 1, name: "JT_PUBLISHER"},
  ],
);

/**
 * @generated from enum livekit.WorkerStatus
 */
export const WorkerStatus = proto3.makeEnum(
  "livekit.WorkerStatus",
  [
    {no: 0, name: "WS_AVAILABLE"},
    {no: 1, name: "WS_FULL"},
  ],
);

/**
 * @generated from enum livekit.JobStatus
 */
export const JobStatus = proto3.makeEnum(
  "livekit.JobStatus",
  [
    {no: 0, name: "JS_UNKNOWN"},
    {no: 1, name: "JS_SUCCESS"},
    {no: 2, name: "JS_FAILED"},
  ],
);

/**
 * @generated from message livekit.AgentInfo
 */
export const AgentInfo = proto3.makeMessageType(
  "livekit.AgentInfo",
  () => [
    { no: 1, name: "id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.Job
 */
export const Job = proto3.makeMessageType(
  "livekit.Job",
  () => [
    { no: 1, name: "id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "type", kind: "enum", T: proto3.getEnumType(JobType) },
    { no: 3, name: "room", kind: "message", T: Room },
    { no: 4, name: "participant", kind: "message", T: ParticipantInfo, opt: true },
  ],
);

/**
 * from Worker to Server
 *
 * @generated from message livekit.WorkerMessage
 */
export const WorkerMessage = proto3.makeMessageType(
  "livekit.WorkerMessage",
  () => [
    { no: 1, name: "register", kind: "message", T: RegisterWorkerRequest, oneof: "message" },
    { no: 2, name: "availability", kind: "message", T: AvailabilityResponse, oneof: "message" },
    { no: 3, name: "status", kind: "message", T: UpdateWorkerStatus, oneof: "message" },
    { no: 4, name: "job_update", kind: "message", T: JobStatusUpdate, oneof: "message" },
  ],
);

/**
 * from Server to Worker
 *
 * @generated from message livekit.ServerMessage
 */
export const ServerMessage = proto3.makeMessageType(
  "livekit.ServerMessage",
  () => [
    { no: 1, name: "register", kind: "message", T: RegisterWorkerResponse, oneof: "message" },
    { no: 2, name: "availability", kind: "message", T: AvailabilityRequest, oneof: "message" },
    { no: 3, name: "assignment", kind: "message", T: JobAssignment, oneof: "message" },
  ],
);

/**
 * @generated from message livekit.RegisterWorkerRequest
 */
export const RegisterWorkerRequest = proto3.makeMessageType(
  "livekit.RegisterWorkerRequest",
  () => [
    { no: 1, name: "type", kind: "enum", T: proto3.getEnumType(JobType) },
    { no: 2, name: "worker_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.RegisterWorkerResponse
 */
export const RegisterWorkerResponse = proto3.makeMessageType(
  "livekit.RegisterWorkerResponse",
  () => [
    { no: 1, name: "worker_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "server_version", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.AvailabilityRequest
 */
export const AvailabilityRequest = proto3.makeMessageType(
  "livekit.AvailabilityRequest",
  () => [
    { no: 1, name: "job", kind: "message", T: Job },
  ],
);

/**
 * @generated from message livekit.AvailabilityResponse
 */
export const AvailabilityResponse = proto3.makeMessageType(
  "livekit.AvailabilityResponse",
  () => [
    { no: 1, name: "job_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "available", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ],
);

/**
 * @generated from message livekit.JobStatusUpdate
 */
export const JobStatusUpdate = proto3.makeMessageType(
  "livekit.JobStatusUpdate",
  () => [
    { no: 1, name: "job_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "status", kind: "enum", T: proto3.getEnumType(JobStatus) },
    { no: 3, name: "error", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "user_data", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.JobAssignment
 */
export const JobAssignment = proto3.makeMessageType(
  "livekit.JobAssignment",
  () => [
    { no: 1, name: "job", kind: "message", T: Job },
  ],
);

/**
 * @generated from message livekit.UpdateWorkerStatus
 */
export const UpdateWorkerStatus = proto3.makeMessageType(
  "livekit.UpdateWorkerStatus",
  () => [
    { no: 1, name: "status", kind: "enum", T: proto3.getEnumType(WorkerStatus) },
  ],
);

