// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`TranslateText`](crate::operation::translate_text::builders::TranslateTextFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::text) / [`set_text(Option<String>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::set_text):<br>required: **true**<br><p>The text to translate. The text string can be a maximum of 10,000 bytes long. Depending on your character set, this may be fewer than 10,000 characters.</p><br>
    ///   - [`terminology_names(impl Into<String>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::terminology_names) / [`set_terminology_names(Option<Vec::<String>>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::set_terminology_names):<br>required: **false**<br><p>The name of a terminology list file to add to the translation job. This file provides source terms and the desired translation for each term. A terminology list can contain a maximum of 256 terms. You can use one custom terminology resource in your translation request.</p> <p>Use the <code>ListTerminologies</code> operation to get the available terminology lists.</p> <p>For more information about custom terminology lists, see <a href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.</p><br>
    ///   - [`source_language_code(impl Into<String>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::source_language_code) / [`set_source_language_code(Option<String>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::set_source_language_code):<br>required: **true**<br><p>The language code for the language of the source text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p> <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p><note>  <p>If you specify <code>auto</code>, you must send the <code>TranslateText</code> request in a region that supports Amazon Comprehend. Otherwise, the request returns an error indicating that autodetect is not supported.</p> </note><br>
    ///   - [`target_language_code(impl Into<String>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::target_language_code) / [`set_target_language_code(Option<String>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::set_target_language_code):<br>required: **true**<br><p>The language code requested for the language of the target text. For a list of language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p><br>
    ///   - [`settings(TranslationSettings)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::settings) / [`set_settings(Option<TranslationSettings>)`](crate::operation::translate_text::builders::TranslateTextFluentBuilder::set_settings):<br>required: **false**<br><p>Settings to configure your translation output. You can configure the following options:</p> <ul>  <li>   <p>Brevity: reduces the length of the translated output for most translations.</p></li>  <li>   <p>Formality: sets the formality level of the output text.</p></li>  <li>   <p>Profanity: masks profane words and phrases in your translation output.</p></li> </ul><br>
    /// - On success, responds with [`TranslateTextOutput`](crate::operation::translate_text::TranslateTextOutput) with field(s):
    ///   - [`translated_text(String)`](crate::operation::translate_text::TranslateTextOutput::translated_text): <p>The translated text.</p>
    ///   - [`source_language_code(String)`](crate::operation::translate_text::TranslateTextOutput::source_language_code): <p>The language code for the language of the source text.</p>
    ///   - [`target_language_code(String)`](crate::operation::translate_text::TranslateTextOutput::target_language_code): <p>The language code for the language of the target text.</p>
    ///   - [`applied_terminologies(Option<Vec::<AppliedTerminology>>)`](crate::operation::translate_text::TranslateTextOutput::applied_terminologies): <p>The names of the custom terminologies applied to the input text by Amazon Translate for the translated text response.</p>
    ///   - [`applied_settings(Option<TranslationSettings>)`](crate::operation::translate_text::TranslateTextOutput::applied_settings): <p>Optional settings that modify the translation output.</p>
    /// - On failure, responds with [`SdkError<TranslateTextError>`](crate::operation::translate_text::TranslateTextError)
    pub fn translate_text(&self) -> crate::operation::translate_text::builders::TranslateTextFluentBuilder {
        crate::operation::translate_text::builders::TranslateTextFluentBuilder::new(self.handle.clone())
    }
}
