// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The language code that represents the language identified in your audio, including the associated confidence score. If you enabled channel identification in your request and each channel contained a different language, you will have more than one <code>LanguageWithScore</code> result.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct LanguageWithScore {
    /// <p>The language code of the identified language.</p>
    pub language_code: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>The confidence score associated with the identified language code. Confidence scores are values between zero and one; larger values indicate a higher confidence in the identified language.</p>
    pub score: f64,
}
impl LanguageWithScore {
    /// <p>The language code of the identified language.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The confidence score associated with the identified language code. Confidence scores are values between zero and one; larger values indicate a higher confidence in the identified language.</p>
    pub fn score(&self) -> f64 {
        self.score
    }
}
impl LanguageWithScore {
    /// Creates a new builder-style object to manufacture [`LanguageWithScore`](crate::types::LanguageWithScore).
    pub fn builder() -> crate::types::builders::LanguageWithScoreBuilder {
        crate::types::builders::LanguageWithScoreBuilder::default()
    }
}

/// A builder for [`LanguageWithScore`](crate::types::LanguageWithScore).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct LanguageWithScoreBuilder {
    pub(crate) language_code: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) score: ::std::option::Option<f64>,
}
impl LanguageWithScoreBuilder {
    /// <p>The language code of the identified language.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>The language code of the identified language.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>The language code of the identified language.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.language_code
    }
    /// <p>The confidence score associated with the identified language code. Confidence scores are values between zero and one; larger values indicate a higher confidence in the identified language.</p>
    pub fn score(mut self, input: f64) -> Self {
        self.score = ::std::option::Option::Some(input);
        self
    }
    /// <p>The confidence score associated with the identified language code. Confidence scores are values between zero and one; larger values indicate a higher confidence in the identified language.</p>
    pub fn set_score(mut self, input: ::std::option::Option<f64>) -> Self {
        self.score = input;
        self
    }
    /// <p>The confidence score associated with the identified language code. Confidence scores are values between zero and one; larger values indicate a higher confidence in the identified language.</p>
    pub fn get_score(&self) -> &::std::option::Option<f64> {
        &self.score
    }
    /// Consumes the builder and constructs a [`LanguageWithScore`](crate::types::LanguageWithScore).
    pub fn build(self) -> crate::types::LanguageWithScore {
        crate::types::LanguageWithScore {
            language_code: self.language_code,
            score: self.score.unwrap_or_default(),
        }
    }
}
