// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_list_objects_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::list_objects::ListObjectsOutput, crate::operation::list_objects::ListObjectsError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::list_objects::ListObjectsError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::list_objects::ListObjectsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchBucket" => crate::operation::list_objects::ListObjectsError::NoSuchBucket({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::NoSuchBucketBuilder::default();
                output = crate::protocol_serde::shape_no_such_bucket::de_no_such_bucket_xml_err(_response_body, output)
                    .map_err(crate::operation::list_objects::ListObjectsError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::list_objects::ListObjectsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_list_objects_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::list_objects::ListObjectsOutput, crate::operation::list_objects::ListObjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::list_objects::builders::ListObjectsOutputBuilder::default();
        output = crate::protocol_serde::shape_list_objects::de_list_objects(_response_body, output)
            .map_err(crate::operation::list_objects::ListObjectsError::unhandled)?;
        output = output.set_request_charged(
            crate::protocol_serde::shape_list_objects_output::de_request_charged_header(_response_headers).map_err(|_| {
                crate::operation::list_objects::ListObjectsError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged")
            })?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_list_objects_headers(
    input: &crate::operation::list_objects::ListObjectsInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.request_payer {
        let formatted_2 = inner_1.as_str();
        let header_value = formatted_2;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "request_payer",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-request-payer", header_value);
    }
    if let ::std::option::Option::Some(inner_3) = &input.expected_bucket_owner {
        let formatted_4 = inner_3.as_str();
        let header_value = formatted_4;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "expected_bucket_owner",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-expected-bucket-owner", header_value);
    }
    if let ::std::option::Option::Some(inner_5) = &input.optional_object_attributes {
        // Empty vec in header is serialized as an empty string
        if inner_5.is_empty() {
            builder = builder.header("x-amz-optional-object-attributes", "");
        } else {
            for inner_6 in inner_5 {
                let formatted_7 = ::aws_smithy_http::header::quote_header_value(inner_6.as_str());
                let header_value = formatted_7;
                let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                    ::aws_smithy_types::error::operation::BuildError::invalid_field(
                        "optional_object_attributes",
                        format!("`{}` cannot be used as a header value: {}", &header_value, err),
                    )
                })?;
                builder = builder.header("x-amz-optional-object-attributes", header_value);
            }
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn de_list_objects(
    inp: &[u8],
    mut builder: crate::operation::list_objects::builders::ListObjectsOutputBuilder,
) -> Result<crate::operation::list_objects::builders::ListObjectsOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !start_el.matches("ListBucketResult") {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "encountered invalid XML root: expected ListBucketResult but got {:?}. This is likely a bug in the SDK.",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CommonPrefixes") /* CommonPrefixes com.amazonaws.s3.synthetic#ListObjectsOutput$CommonPrefixes */ =>  {
                let var_8 =
                    Some(
                        Result::<::std::vec::Vec::<crate::types::CommonPrefix>, ::aws_smithy_xml::decode::XmlDecodeError>::Ok({
                            let mut list_9 = builder.common_prefixes.take().unwrap_or_default();
                            list_9.push(
                                crate::protocol_serde::shape_common_prefix::de_common_prefix(&mut tag)
                                ?
                            );
                            list_9
                        })
                        ?
                    )
                ;
                builder = builder.set_common_prefixes(var_8);
            }
            ,
            s if s.matches("Contents") /* Contents com.amazonaws.s3.synthetic#ListObjectsOutput$Contents */ =>  {
                let var_10 =
                    Some(
                        Result::<::std::vec::Vec::<crate::types::Object>, ::aws_smithy_xml::decode::XmlDecodeError>::Ok({
                            let mut list_11 = builder.contents.take().unwrap_or_default();
                            list_11.push(
                                crate::protocol_serde::shape_object::de_object(&mut tag)
                                ?
                            );
                            list_11
                        })
                        ?
                    )
                ;
                builder = builder.set_contents(var_10);
            }
            ,
            s if s.matches("Delimiter") /* Delimiter com.amazonaws.s3.synthetic#ListObjectsOutput$Delimiter */ =>  {
                let var_12 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delimiter(var_12);
            }
            ,
            s if s.matches("EncodingType") /* EncodingType com.amazonaws.s3.synthetic#ListObjectsOutput$EncodingType */ =>  {
                let var_13 =
                    Some(
                        Result::<crate::types::EncodingType, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            crate::types::EncodingType::from(
                                ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_encoding_type(var_13);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListObjectsOutput$IsTruncated */ =>  {
                let var_14 =
                    Some(
                         {
                            <bool as ::aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|::aws_smithy_xml::decode::XmlDecodeError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_14);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.s3.synthetic#ListObjectsOutput$Marker */ =>  {
                let var_15 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_15);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3.synthetic#ListObjectsOutput$Prefix */ =>  {
                let var_16 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_16);
            }
            ,
            s if s.matches("NextMarker") /* NextMarker com.amazonaws.s3.synthetic#ListObjectsOutput$NextMarker */ =>  {
                let var_17 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_marker(var_17);
            }
            ,
            s if s.matches("MaxKeys") /* MaxKeys com.amazonaws.s3.synthetic#ListObjectsOutput$MaxKeys */ =>  {
                let var_18 =
                    Some(
                         {
                            <i32 as ::aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|::aws_smithy_xml::decode::XmlDecodeError::custom("expected (integer: `com.amazonaws.s3#MaxKeys`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_keys(var_18);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.s3.synthetic#ListObjectsOutput$Name */ =>  {
                let var_19 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_19);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}
