// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub struct SynthesizeSpeechOutput {
    /// <p>Stream containing the synthesized speech.</p>
    pub audio_stream: ::aws_smithy_types::byte_stream::ByteStream,
    /// <p>Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.</p>
    /// <ul>
    /// <li>
    /// <p>If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/mpeg.</p></li>
    /// <li>
    /// <p>If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/ogg.</p></li>
    /// <li>
    /// <p>If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.</p></li>
    /// <li>
    /// <p>If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is application/x-json-stream.</p></li>
    /// </ul>
    /// <p></p>
    pub content_type: ::std::option::Option<::std::string::String>,
    /// <p>Number of characters synthesized.</p>
    pub request_characters: i32,
    _request_id: Option<String>,
}
impl SynthesizeSpeechOutput {
    /// <p>Stream containing the synthesized speech.</p>
    pub fn audio_stream(&self) -> &::aws_smithy_types::byte_stream::ByteStream {
        &self.audio_stream
    }
    /// <p>Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.</p>
    /// <ul>
    /// <li>
    /// <p>If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/mpeg.</p></li>
    /// <li>
    /// <p>If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/ogg.</p></li>
    /// <li>
    /// <p>If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.</p></li>
    /// <li>
    /// <p>If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is application/x-json-stream.</p></li>
    /// </ul>
    /// <p></p>
    pub fn content_type(&self) -> ::std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>Number of characters synthesized.</p>
    pub fn request_characters(&self) -> i32 {
        self.request_characters
    }
}
impl ::aws_types::request_id::RequestId for SynthesizeSpeechOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl SynthesizeSpeechOutput {
    /// Creates a new builder-style object to manufacture [`SynthesizeSpeechOutput`](crate::operation::synthesize_speech::SynthesizeSpeechOutput).
    pub fn builder() -> crate::operation::synthesize_speech::builders::SynthesizeSpeechOutputBuilder {
        crate::operation::synthesize_speech::builders::SynthesizeSpeechOutputBuilder::default()
    }
}

/// A builder for [`SynthesizeSpeechOutput`](crate::operation::synthesize_speech::SynthesizeSpeechOutput).
#[derive(::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SynthesizeSpeechOutputBuilder {
    pub(crate) audio_stream: ::std::option::Option<::aws_smithy_types::byte_stream::ByteStream>,
    pub(crate) content_type: ::std::option::Option<::std::string::String>,
    pub(crate) request_characters: ::std::option::Option<i32>,
    _request_id: Option<String>,
}
impl SynthesizeSpeechOutputBuilder {
    /// <p>Stream containing the synthesized speech.</p>
    pub fn audio_stream(mut self, input: ::aws_smithy_types::byte_stream::ByteStream) -> Self {
        self.audio_stream = ::std::option::Option::Some(input);
        self
    }
    /// <p>Stream containing the synthesized speech.</p>
    pub fn set_audio_stream(mut self, input: ::std::option::Option<::aws_smithy_types::byte_stream::ByteStream>) -> Self {
        self.audio_stream = input;
        self
    }
    /// <p>Stream containing the synthesized speech.</p>
    pub fn get_audio_stream(&self) -> &::std::option::Option<::aws_smithy_types::byte_stream::ByteStream> {
        &self.audio_stream
    }
    /// <p>Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.</p>
    /// <ul>
    /// <li>
    /// <p>If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/mpeg.</p></li>
    /// <li>
    /// <p>If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/ogg.</p></li>
    /// <li>
    /// <p>If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.</p></li>
    /// <li>
    /// <p>If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is application/x-json-stream.</p></li>
    /// </ul>
    /// <p></p>
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.</p>
    /// <ul>
    /// <li>
    /// <p>If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/mpeg.</p></li>
    /// <li>
    /// <p>If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/ogg.</p></li>
    /// <li>
    /// <p>If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.</p></li>
    /// <li>
    /// <p>If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is application/x-json-stream.</p></li>
    /// </ul>
    /// <p></p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_type = input;
        self
    }
    /// <p>Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.</p>
    /// <ul>
    /// <li>
    /// <p>If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/mpeg.</p></li>
    /// <li>
    /// <p>If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/ogg.</p></li>
    /// <li>
    /// <p>If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.</p></li>
    /// <li>
    /// <p>If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is application/x-json-stream.</p></li>
    /// </ul>
    /// <p></p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_type
    }
    /// <p>Number of characters synthesized.</p>
    pub fn request_characters(mut self, input: i32) -> Self {
        self.request_characters = ::std::option::Option::Some(input);
        self
    }
    /// <p>Number of characters synthesized.</p>
    pub fn set_request_characters(mut self, input: ::std::option::Option<i32>) -> Self {
        self.request_characters = input;
        self
    }
    /// <p>Number of characters synthesized.</p>
    pub fn get_request_characters(&self) -> &::std::option::Option<i32> {
        &self.request_characters
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`SynthesizeSpeechOutput`](crate::operation::synthesize_speech::SynthesizeSpeechOutput).
    pub fn build(self) -> crate::operation::synthesize_speech::SynthesizeSpeechOutput {
        crate::operation::synthesize_speech::SynthesizeSpeechOutput {
            audio_stream: self.audio_stream.unwrap_or_default(),
            content_type: self.content_type,
            request_characters: self.request_characters.unwrap_or_default(),
            _request_id: self._request_id,
        }
    }
}
