// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::send_alexa_offer_to_master::_send_alexa_offer_to_master_output::SendAlexaOfferToMasterOutputBuilder;

pub use crate::operation::send_alexa_offer_to_master::_send_alexa_offer_to_master_input::SendAlexaOfferToMasterInputBuilder;

impl crate::operation::send_alexa_offer_to_master::builders::SendAlexaOfferToMasterInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.send_alexa_offer_to_master();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `SendAlexaOfferToMaster`.
///
/// <p>This API allows you to connect WebRTC-enabled devices with Alexa display devices. When invoked, it sends the Alexa Session Description Protocol (SDP) offer to the master peer. The offer is delivered as soon as the master is connected to the specified signaling channel. This API returns the SDP answer from the connected master. If the master is not connected to the signaling channel, redelivery requests are made until the message expires.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct SendAlexaOfferToMasterFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::send_alexa_offer_to_master::builders::SendAlexaOfferToMasterInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterOutput,
        crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError,
    > for SendAlexaOfferToMasterFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterOutput,
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl SendAlexaOfferToMasterFluentBuilder {
    /// Creates a new `SendAlexaOfferToMasterFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the SendAlexaOfferToMaster as a reference.
    pub fn as_input(&self) -> &crate::operation::send_alexa_offer_to_master::builders::SendAlexaOfferToMasterInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMaster::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMaster::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterOutput,
        crate::operation::send_alexa_offer_to_master::SendAlexaOfferToMasterError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The ARN of the signaling channel by which Alexa and the master peer communicate.</p>
    pub fn channel_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.channel_arn(input.into());
        self
    }
    /// <p>The ARN of the signaling channel by which Alexa and the master peer communicate.</p>
    pub fn set_channel_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_channel_arn(input);
        self
    }
    /// <p>The ARN of the signaling channel by which Alexa and the master peer communicate.</p>
    pub fn get_channel_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_channel_arn()
    }
    /// <p>The unique identifier for the sender client.</p>
    pub fn sender_client_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sender_client_id(input.into());
        self
    }
    /// <p>The unique identifier for the sender client.</p>
    pub fn set_sender_client_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sender_client_id(input);
        self
    }
    /// <p>The unique identifier for the sender client.</p>
    pub fn get_sender_client_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sender_client_id()
    }
    /// <p>The base64-encoded SDP offer content.</p>
    pub fn message_payload(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.message_payload(input.into());
        self
    }
    /// <p>The base64-encoded SDP offer content.</p>
    pub fn set_message_payload(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_message_payload(input);
        self
    }
    /// <p>The base64-encoded SDP offer content.</p>
    pub fn get_message_payload(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_message_payload()
    }
}
