// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/extension.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum of location an HTTP element can be.
type HttpElementLocation int32

const (
	HttpElementLocation_HTTP_IN_UNSPECIFIED HttpElementLocation = 0
	// Element is in the HTTP request query.
	HttpElementLocation_HTTP_IN_QUERY HttpElementLocation = 1
	// Element is in the HTTP request header.
	HttpElementLocation_HTTP_IN_HEADER HttpElementLocation = 2
	// Element is in the HTTP request path.
	HttpElementLocation_HTTP_IN_PATH HttpElementLocation = 3
	// Element is in the HTTP request body.
	HttpElementLocation_HTTP_IN_BODY HttpElementLocation = 4
	// Element is in the HTTP request cookie.
	HttpElementLocation_HTTP_IN_COOKIE HttpElementLocation = 5
)

// Enum value maps for HttpElementLocation.
var (
	HttpElementLocation_name = map[int32]string{
		0: "HTTP_IN_UNSPECIFIED",
		1: "HTTP_IN_QUERY",
		2: "HTTP_IN_HEADER",
		3: "HTTP_IN_PATH",
		4: "HTTP_IN_BODY",
		5: "HTTP_IN_COOKIE",
	}
	HttpElementLocation_value = map[string]int32{
		"HTTP_IN_UNSPECIFIED": 0,
		"HTTP_IN_QUERY":       1,
		"HTTP_IN_HEADER":      2,
		"HTTP_IN_PATH":        3,
		"HTTP_IN_BODY":        4,
		"HTTP_IN_COOKIE":      5,
	}
)

func (x HttpElementLocation) Enum() *HttpElementLocation {
	p := new(HttpElementLocation)
	*p = x
	return p
}

func (x HttpElementLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpElementLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_enumTypes[0].Descriptor()
}

func (HttpElementLocation) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_extension_proto_enumTypes[0]
}

func (x HttpElementLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpElementLocation.Descriptor instead.
func (HttpElementLocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{0}
}

// Type of Auth.
type AuthType int32

const (
	AuthType_AUTH_TYPE_UNSPECIFIED AuthType = 0
	// No Auth.
	AuthType_NO_AUTH AuthType = 1
	// API Key Auth.
	AuthType_API_KEY_AUTH AuthType = 2
	// HTTP Basic Auth.
	AuthType_HTTP_BASIC_AUTH AuthType = 3
	// Google Service Account Auth.
	AuthType_GOOGLE_SERVICE_ACCOUNT_AUTH AuthType = 4
	// OAuth auth.
	AuthType_OAUTH AuthType = 6
	// OpenID Connect (OIDC) Auth.
	AuthType_OIDC_AUTH AuthType = 8
)

// Enum value maps for AuthType.
var (
	AuthType_name = map[int32]string{
		0: "AUTH_TYPE_UNSPECIFIED",
		1: "NO_AUTH",
		2: "API_KEY_AUTH",
		3: "HTTP_BASIC_AUTH",
		4: "GOOGLE_SERVICE_ACCOUNT_AUTH",
		6: "OAUTH",
		8: "OIDC_AUTH",
	}
	AuthType_value = map[string]int32{
		"AUTH_TYPE_UNSPECIFIED":       0,
		"NO_AUTH":                     1,
		"API_KEY_AUTH":                2,
		"HTTP_BASIC_AUTH":             3,
		"GOOGLE_SERVICE_ACCOUNT_AUTH": 4,
		"OAUTH":                       6,
		"OIDC_AUTH":                   8,
	}
)

func (x AuthType) Enum() *AuthType {
	p := new(AuthType)
	*p = x
	return p
}

func (x AuthType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_enumTypes[1].Descriptor()
}

func (AuthType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_extension_proto_enumTypes[1]
}

func (x AuthType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthType.Descriptor instead.
func (AuthType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{1}
}

// Extensions are tools for large language models to access external data, run
// computations, etc.
type Extension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the Extension.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the Extension.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the Extension.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Timestamp when this Extension was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this Extension was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Used to perform consistent read-modify-write updates. If not set,
	// a blind "overwrite" update happens.
	Etag string `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// Required. Manifest of the Extension.
	Manifest *ExtensionManifest `protobuf:"bytes,9,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// Output only. Supported operations.
	ExtensionOperations []*ExtensionOperation `protobuf:"bytes,11,rep,name=extension_operations,json=extensionOperations,proto3" json:"extension_operations,omitempty"`
	// Optional. Runtime config controlling the runtime behavior of this
	// Extension.
	RuntimeConfig *RuntimeConfig `protobuf:"bytes,13,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
	// Optional. Examples to illustrate the usage of the extension as a tool.
	ToolUseExamples []*ToolUseExample `protobuf:"bytes,15,rep,name=tool_use_examples,json=toolUseExamples,proto3" json:"tool_use_examples,omitempty"`
	// Optional. The PrivateServiceConnect config for the extension.
	// If specified, the service endpoints associated with the
	// Extension should be registered with private network access in the provided
	// Service Directory
	// (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
	//
	// If the service contains more than one endpoint with a network, the service
	// will arbitrarilty choose one of the endpoints to use for extension
	// execution.
	PrivateServiceConnectConfig *ExtensionPrivateServiceConnectConfig `protobuf:"bytes,16,opt,name=private_service_connect_config,json=privateServiceConnectConfig,proto3" json:"private_service_connect_config,omitempty"`
}

func (x *Extension) Reset() {
	*x = Extension{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Extension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Extension) ProtoMessage() {}

func (x *Extension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Extension.ProtoReflect.Descriptor instead.
func (*Extension) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{0}
}

func (x *Extension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Extension) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Extension) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Extension) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Extension) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Extension) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Extension) GetManifest() *ExtensionManifest {
	if x != nil {
		return x.Manifest
	}
	return nil
}

func (x *Extension) GetExtensionOperations() []*ExtensionOperation {
	if x != nil {
		return x.ExtensionOperations
	}
	return nil
}

func (x *Extension) GetRuntimeConfig() *RuntimeConfig {
	if x != nil {
		return x.RuntimeConfig
	}
	return nil
}

func (x *Extension) GetToolUseExamples() []*ToolUseExample {
	if x != nil {
		return x.ToolUseExamples
	}
	return nil
}

func (x *Extension) GetPrivateServiceConnectConfig() *ExtensionPrivateServiceConnectConfig {
	if x != nil {
		return x.PrivateServiceConnectConfig
	}
	return nil
}

// Manifest spec of an Extension needed for runtime execution.
type ExtensionManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Extension name shown to the LLM.
	// The name can be up to 128 characters long.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The natural language description shown to the LLM.
	// It should describe the usage of the extension, and is essential for the LLM
	// to perform reasoning. e.g., if the extension is a data store, you can let
	// the LLM know what data it contains.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. The API specification shown to the LLM.
	ApiSpec *ExtensionManifest_ApiSpec `protobuf:"bytes,3,opt,name=api_spec,json=apiSpec,proto3" json:"api_spec,omitempty"`
	// Required. Immutable. Type of auth supported by this extension.
	AuthConfig *AuthConfig `protobuf:"bytes,5,opt,name=auth_config,json=authConfig,proto3" json:"auth_config,omitempty"`
}

func (x *ExtensionManifest) Reset() {
	*x = ExtensionManifest{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionManifest) ProtoMessage() {}

func (x *ExtensionManifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionManifest.ProtoReflect.Descriptor instead.
func (*ExtensionManifest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{1}
}

func (x *ExtensionManifest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExtensionManifest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ExtensionManifest) GetApiSpec() *ExtensionManifest_ApiSpec {
	if x != nil {
		return x.ApiSpec
	}
	return nil
}

func (x *ExtensionManifest) GetAuthConfig() *AuthConfig {
	if x != nil {
		return x.AuthConfig
	}
	return nil
}

// Operation of an extension.
type ExtensionOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation ID that uniquely identifies the operations among the extension.
	// See: "Operation Object" in https://swagger.io/specification/.
	//
	// This field is parsed from the OpenAPI spec. For HTTP extensions, if it does
	// not exist in the spec, we will generate one from the HTTP method and path.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Output only. Structured representation of a function declaration as defined
	// by the OpenAPI Spec.
	FunctionDeclaration *FunctionDeclaration `protobuf:"bytes,3,opt,name=function_declaration,json=functionDeclaration,proto3" json:"function_declaration,omitempty"`
}

func (x *ExtensionOperation) Reset() {
	*x = ExtensionOperation{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionOperation) ProtoMessage() {}

func (x *ExtensionOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionOperation.ProtoReflect.Descriptor instead.
func (*ExtensionOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{2}
}

func (x *ExtensionOperation) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *ExtensionOperation) GetFunctionDeclaration() *FunctionDeclaration {
	if x != nil {
		return x.FunctionDeclaration
	}
	return nil
}

// Auth configuration to run the extension.
type AuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to AuthConfig:
	//
	//	*AuthConfig_ApiKeyConfig_
	//	*AuthConfig_HttpBasicAuthConfig_
	//	*AuthConfig_GoogleServiceAccountConfig_
	//	*AuthConfig_OauthConfig_
	//	*AuthConfig_OidcConfig_
	AuthConfig isAuthConfig_AuthConfig `protobuf_oneof:"auth_config"`
	// Type of auth scheme.
	AuthType AuthType `protobuf:"varint,101,opt,name=auth_type,json=authType,proto3,enum=google.cloud.aiplatform.v1beta1.AuthType" json:"auth_type,omitempty"`
}

func (x *AuthConfig) Reset() {
	*x = AuthConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig) ProtoMessage() {}

func (x *AuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{3}
}

func (m *AuthConfig) GetAuthConfig() isAuthConfig_AuthConfig {
	if m != nil {
		return m.AuthConfig
	}
	return nil
}

func (x *AuthConfig) GetApiKeyConfig() *AuthConfig_ApiKeyConfig {
	if x, ok := x.GetAuthConfig().(*AuthConfig_ApiKeyConfig_); ok {
		return x.ApiKeyConfig
	}
	return nil
}

func (x *AuthConfig) GetHttpBasicAuthConfig() *AuthConfig_HttpBasicAuthConfig {
	if x, ok := x.GetAuthConfig().(*AuthConfig_HttpBasicAuthConfig_); ok {
		return x.HttpBasicAuthConfig
	}
	return nil
}

func (x *AuthConfig) GetGoogleServiceAccountConfig() *AuthConfig_GoogleServiceAccountConfig {
	if x, ok := x.GetAuthConfig().(*AuthConfig_GoogleServiceAccountConfig_); ok {
		return x.GoogleServiceAccountConfig
	}
	return nil
}

func (x *AuthConfig) GetOauthConfig() *AuthConfig_OauthConfig {
	if x, ok := x.GetAuthConfig().(*AuthConfig_OauthConfig_); ok {
		return x.OauthConfig
	}
	return nil
}

func (x *AuthConfig) GetOidcConfig() *AuthConfig_OidcConfig {
	if x, ok := x.GetAuthConfig().(*AuthConfig_OidcConfig_); ok {
		return x.OidcConfig
	}
	return nil
}

func (x *AuthConfig) GetAuthType() AuthType {
	if x != nil {
		return x.AuthType
	}
	return AuthType_AUTH_TYPE_UNSPECIFIED
}

type isAuthConfig_AuthConfig interface {
	isAuthConfig_AuthConfig()
}

type AuthConfig_ApiKeyConfig_ struct {
	// Config for API key auth.
	ApiKeyConfig *AuthConfig_ApiKeyConfig `protobuf:"bytes,2,opt,name=api_key_config,json=apiKeyConfig,proto3,oneof"`
}

type AuthConfig_HttpBasicAuthConfig_ struct {
	// Config for HTTP Basic auth.
	HttpBasicAuthConfig *AuthConfig_HttpBasicAuthConfig `protobuf:"bytes,3,opt,name=http_basic_auth_config,json=httpBasicAuthConfig,proto3,oneof"`
}

type AuthConfig_GoogleServiceAccountConfig_ struct {
	// Config for Google Service Account auth.
	GoogleServiceAccountConfig *AuthConfig_GoogleServiceAccountConfig `protobuf:"bytes,4,opt,name=google_service_account_config,json=googleServiceAccountConfig,proto3,oneof"`
}

type AuthConfig_OauthConfig_ struct {
	// Config for user oauth.
	OauthConfig *AuthConfig_OauthConfig `protobuf:"bytes,5,opt,name=oauth_config,json=oauthConfig,proto3,oneof"`
}

type AuthConfig_OidcConfig_ struct {
	// Config for user OIDC auth.
	OidcConfig *AuthConfig_OidcConfig `protobuf:"bytes,7,opt,name=oidc_config,json=oidcConfig,proto3,oneof"`
}

func (*AuthConfig_ApiKeyConfig_) isAuthConfig_AuthConfig() {}

func (*AuthConfig_HttpBasicAuthConfig_) isAuthConfig_AuthConfig() {}

func (*AuthConfig_GoogleServiceAccountConfig_) isAuthConfig_AuthConfig() {}

func (*AuthConfig_OauthConfig_) isAuthConfig_AuthConfig() {}

func (*AuthConfig_OidcConfig_) isAuthConfig_AuthConfig() {}

// Runtime configuration to run the extension.
type RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Runtime configurations for Google first party extensions.
	//
	// Types that are assignable to GoogleFirstPartyExtensionConfig:
	//
	//	*RuntimeConfig_CodeInterpreterRuntimeConfig_
	//	*RuntimeConfig_VertexAiSearchRuntimeConfig
	GoogleFirstPartyExtensionConfig isRuntimeConfig_GoogleFirstPartyExtensionConfig `protobuf_oneof:"GoogleFirstPartyExtensionConfig"`
	// Optional. Default parameters that will be set for all the execution of this
	// extension. If specified, the parameter values can be overridden by values
	// in [[ExecuteExtensionRequest.operation_params]] at request time.
	//
	// The struct should be in a form of map with param name as the key and actual
	// param value as the value.
	// E.g. If this operation requires a param "name" to be set to "abc". you can
	// set this to something like {"name": "abc"}.
	DefaultParams *structpb.Struct `protobuf:"bytes,4,opt,name=default_params,json=defaultParams,proto3" json:"default_params,omitempty"`
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{4}
}

func (m *RuntimeConfig) GetGoogleFirstPartyExtensionConfig() isRuntimeConfig_GoogleFirstPartyExtensionConfig {
	if m != nil {
		return m.GoogleFirstPartyExtensionConfig
	}
	return nil
}

func (x *RuntimeConfig) GetCodeInterpreterRuntimeConfig() *RuntimeConfig_CodeInterpreterRuntimeConfig {
	if x, ok := x.GetGoogleFirstPartyExtensionConfig().(*RuntimeConfig_CodeInterpreterRuntimeConfig_); ok {
		return x.CodeInterpreterRuntimeConfig
	}
	return nil
}

func (x *RuntimeConfig) GetVertexAiSearchRuntimeConfig() *RuntimeConfig_VertexAISearchRuntimeConfig {
	if x, ok := x.GetGoogleFirstPartyExtensionConfig().(*RuntimeConfig_VertexAiSearchRuntimeConfig); ok {
		return x.VertexAiSearchRuntimeConfig
	}
	return nil
}

func (x *RuntimeConfig) GetDefaultParams() *structpb.Struct {
	if x != nil {
		return x.DefaultParams
	}
	return nil
}

type isRuntimeConfig_GoogleFirstPartyExtensionConfig interface {
	isRuntimeConfig_GoogleFirstPartyExtensionConfig()
}

type RuntimeConfig_CodeInterpreterRuntimeConfig_ struct {
	// Code execution runtime configurations for code interpreter extension.
	CodeInterpreterRuntimeConfig *RuntimeConfig_CodeInterpreterRuntimeConfig `protobuf:"bytes,2,opt,name=code_interpreter_runtime_config,json=codeInterpreterRuntimeConfig,proto3,oneof"`
}

type RuntimeConfig_VertexAiSearchRuntimeConfig struct {
	// Runtime configuration for Vertex AI Search extension.
	VertexAiSearchRuntimeConfig *RuntimeConfig_VertexAISearchRuntimeConfig `protobuf:"bytes,6,opt,name=vertex_ai_search_runtime_config,json=vertexAiSearchRuntimeConfig,proto3,oneof"`
}

func (*RuntimeConfig_CodeInterpreterRuntimeConfig_) isRuntimeConfig_GoogleFirstPartyExtensionConfig() {
}

func (*RuntimeConfig_VertexAiSearchRuntimeConfig) isRuntimeConfig_GoogleFirstPartyExtensionConfig() {}

// PrivateExtensionConfig configuration for the extension.
type ExtensionPrivateServiceConnectConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Service Directory resource name in which the service
	// endpoints associated to the extension are registered. Format:
	// `projects/{project_id}/locations/{location_id}/namespaces/{namespace_id}/services/{service_id}`
	//
	// - The Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// should be granted `servicedirectory.viewer` and
	// `servicedirectory.pscAuthorizedService` roles on the resource.
	ServiceDirectory string `protobuf:"bytes,1,opt,name=service_directory,json=serviceDirectory,proto3" json:"service_directory,omitempty"`
}

func (x *ExtensionPrivateServiceConnectConfig) Reset() {
	*x = ExtensionPrivateServiceConnectConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionPrivateServiceConnectConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionPrivateServiceConnectConfig) ProtoMessage() {}

func (x *ExtensionPrivateServiceConnectConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionPrivateServiceConnectConfig.ProtoReflect.Descriptor instead.
func (*ExtensionPrivateServiceConnectConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{5}
}

func (x *ExtensionPrivateServiceConnectConfig) GetServiceDirectory() string {
	if x != nil {
		return x.ServiceDirectory
	}
	return ""
}

// The API specification shown to the LLM.
type ExtensionManifest_ApiSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ApiSpec:
	//
	//	*ExtensionManifest_ApiSpec_OpenApiYaml
	//	*ExtensionManifest_ApiSpec_OpenApiGcsUri
	ApiSpec isExtensionManifest_ApiSpec_ApiSpec `protobuf_oneof:"api_spec"`
}

func (x *ExtensionManifest_ApiSpec) Reset() {
	*x = ExtensionManifest_ApiSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionManifest_ApiSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionManifest_ApiSpec) ProtoMessage() {}

func (x *ExtensionManifest_ApiSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionManifest_ApiSpec.ProtoReflect.Descriptor instead.
func (*ExtensionManifest_ApiSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{1, 0}
}

func (m *ExtensionManifest_ApiSpec) GetApiSpec() isExtensionManifest_ApiSpec_ApiSpec {
	if m != nil {
		return m.ApiSpec
	}
	return nil
}

func (x *ExtensionManifest_ApiSpec) GetOpenApiYaml() string {
	if x, ok := x.GetApiSpec().(*ExtensionManifest_ApiSpec_OpenApiYaml); ok {
		return x.OpenApiYaml
	}
	return ""
}

func (x *ExtensionManifest_ApiSpec) GetOpenApiGcsUri() string {
	if x, ok := x.GetApiSpec().(*ExtensionManifest_ApiSpec_OpenApiGcsUri); ok {
		return x.OpenApiGcsUri
	}
	return ""
}

type isExtensionManifest_ApiSpec_ApiSpec interface {
	isExtensionManifest_ApiSpec_ApiSpec()
}

type ExtensionManifest_ApiSpec_OpenApiYaml struct {
	// The API spec in Open API standard and YAML format.
	OpenApiYaml string `protobuf:"bytes,1,opt,name=open_api_yaml,json=openApiYaml,proto3,oneof"`
}

type ExtensionManifest_ApiSpec_OpenApiGcsUri struct {
	// Cloud Storage URI pointing to the OpenAPI spec.
	OpenApiGcsUri string `protobuf:"bytes,2,opt,name=open_api_gcs_uri,json=openApiGcsUri,proto3,oneof"`
}

func (*ExtensionManifest_ApiSpec_OpenApiYaml) isExtensionManifest_ApiSpec_ApiSpec() {}

func (*ExtensionManifest_ApiSpec_OpenApiGcsUri) isExtensionManifest_ApiSpec_ApiSpec() {}

// Config for authentication with API key.
type AuthConfig_ApiKeyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parameter name of the API key.
	// E.g. If the API request is "https://example.com/act?api_key=<API KEY>",
	// "api_key" would be the parameter name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the SecretManager secret version resource storing
	// the API key. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}`
	//
	// - If specified, the `secretmanager.versions.access` permission should be
	// granted to Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	ApiKeySecret string `protobuf:"bytes,2,opt,name=api_key_secret,json=apiKeySecret,proto3" json:"api_key_secret,omitempty"`
	// Required. The location of the API key.
	HttpElementLocation HttpElementLocation `protobuf:"varint,3,opt,name=http_element_location,json=httpElementLocation,proto3,enum=google.cloud.aiplatform.v1beta1.HttpElementLocation" json:"http_element_location,omitempty"`
}

func (x *AuthConfig_ApiKeyConfig) Reset() {
	*x = AuthConfig_ApiKeyConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthConfig_ApiKeyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_ApiKeyConfig) ProtoMessage() {}

func (x *AuthConfig_ApiKeyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_ApiKeyConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig_ApiKeyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AuthConfig_ApiKeyConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AuthConfig_ApiKeyConfig) GetApiKeySecret() string {
	if x != nil {
		return x.ApiKeySecret
	}
	return ""
}

func (x *AuthConfig_ApiKeyConfig) GetHttpElementLocation() HttpElementLocation {
	if x != nil {
		return x.HttpElementLocation
	}
	return HttpElementLocation_HTTP_IN_UNSPECIFIED
}

// Config for HTTP Basic Authentication.
type AuthConfig_HttpBasicAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SecretManager secret version resource storing
	// the base64 encoded credentials. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}`
	//
	// - If specified, the `secretmanager.versions.access` permission should be
	// granted to Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	CredentialSecret string `protobuf:"bytes,2,opt,name=credential_secret,json=credentialSecret,proto3" json:"credential_secret,omitempty"`
}

func (x *AuthConfig_HttpBasicAuthConfig) Reset() {
	*x = AuthConfig_HttpBasicAuthConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthConfig_HttpBasicAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_HttpBasicAuthConfig) ProtoMessage() {}

func (x *AuthConfig_HttpBasicAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_HttpBasicAuthConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig_HttpBasicAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{3, 1}
}

func (x *AuthConfig_HttpBasicAuthConfig) GetCredentialSecret() string {
	if x != nil {
		return x.CredentialSecret
	}
	return ""
}

// Config for Google Service Account Authentication.
type AuthConfig_GoogleServiceAccountConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The service account that the extension execution service runs
	// as.
	//
	// - If the service account is specified,
	// the `iam.serviceAccounts.getAccessToken` permission should be granted to
	// Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified service account.
	//
	// - If not specified, the Vertex AI Extension Service Agent
	// will be used to execute the Extension.
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *AuthConfig_GoogleServiceAccountConfig) Reset() {
	*x = AuthConfig_GoogleServiceAccountConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthConfig_GoogleServiceAccountConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_GoogleServiceAccountConfig) ProtoMessage() {}

func (x *AuthConfig_GoogleServiceAccountConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_GoogleServiceAccountConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig_GoogleServiceAccountConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{3, 2}
}

func (x *AuthConfig_GoogleServiceAccountConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// Config for user oauth.
type AuthConfig_OauthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OauthConfig:
	//
	//	*AuthConfig_OauthConfig_AccessToken
	//	*AuthConfig_OauthConfig_ServiceAccount
	OauthConfig isAuthConfig_OauthConfig_OauthConfig `protobuf_oneof:"oauth_config"`
}

func (x *AuthConfig_OauthConfig) Reset() {
	*x = AuthConfig_OauthConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthConfig_OauthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_OauthConfig) ProtoMessage() {}

func (x *AuthConfig_OauthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_OauthConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig_OauthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{3, 3}
}

func (m *AuthConfig_OauthConfig) GetOauthConfig() isAuthConfig_OauthConfig_OauthConfig {
	if m != nil {
		return m.OauthConfig
	}
	return nil
}

func (x *AuthConfig_OauthConfig) GetAccessToken() string {
	if x, ok := x.GetOauthConfig().(*AuthConfig_OauthConfig_AccessToken); ok {
		return x.AccessToken
	}
	return ""
}

func (x *AuthConfig_OauthConfig) GetServiceAccount() string {
	if x, ok := x.GetOauthConfig().(*AuthConfig_OauthConfig_ServiceAccount); ok {
		return x.ServiceAccount
	}
	return ""
}

type isAuthConfig_OauthConfig_OauthConfig interface {
	isAuthConfig_OauthConfig_OauthConfig()
}

type AuthConfig_OauthConfig_AccessToken struct {
	// Access token for extension endpoint.
	// Only used to propagate token from
	// [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3,oneof"`
}

type AuthConfig_OauthConfig_ServiceAccount struct {
	// The service account used to generate access tokens for executing the
	// Extension.
	//
	// - If the service account is specified,
	// the `iam.serviceAccounts.getAccessToken` permission should be granted
	// to Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the provided service account.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3,oneof"`
}

func (*AuthConfig_OauthConfig_AccessToken) isAuthConfig_OauthConfig_OauthConfig() {}

func (*AuthConfig_OauthConfig_ServiceAccount) isAuthConfig_OauthConfig_OauthConfig() {}

// Config for user OIDC auth.
type AuthConfig_OidcConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OidcConfig:
	//
	//	*AuthConfig_OidcConfig_IdToken
	//	*AuthConfig_OidcConfig_ServiceAccount
	OidcConfig isAuthConfig_OidcConfig_OidcConfig `protobuf_oneof:"oidc_config"`
}

func (x *AuthConfig_OidcConfig) Reset() {
	*x = AuthConfig_OidcConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthConfig_OidcConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_OidcConfig) ProtoMessage() {}

func (x *AuthConfig_OidcConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_OidcConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig_OidcConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{3, 4}
}

func (m *AuthConfig_OidcConfig) GetOidcConfig() isAuthConfig_OidcConfig_OidcConfig {
	if m != nil {
		return m.OidcConfig
	}
	return nil
}

func (x *AuthConfig_OidcConfig) GetIdToken() string {
	if x, ok := x.GetOidcConfig().(*AuthConfig_OidcConfig_IdToken); ok {
		return x.IdToken
	}
	return ""
}

func (x *AuthConfig_OidcConfig) GetServiceAccount() string {
	if x, ok := x.GetOidcConfig().(*AuthConfig_OidcConfig_ServiceAccount); ok {
		return x.ServiceAccount
	}
	return ""
}

type isAuthConfig_OidcConfig_OidcConfig interface {
	isAuthConfig_OidcConfig_OidcConfig()
}

type AuthConfig_OidcConfig_IdToken struct {
	// OpenID Connect formatted ID token for extension endpoint.
	// Only used to propagate token from
	// [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
	IdToken string `protobuf:"bytes,1,opt,name=id_token,json=idToken,proto3,oneof"`
}

type AuthConfig_OidcConfig_ServiceAccount struct {
	// The service account used to generate an OpenID Connect
	// (OIDC)-compatible JWT token signed by the Google OIDC Provider
	// (accounts.google.com) for extension endpoint
	// (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
	//
	// - The audience for the token will be set to the URL in the server url
	// defined in the OpenApi spec.
	//
	// - If the service account is provided, the service account should grant
	// `iam.serviceAccounts.getOpenIdToken` permission to Vertex AI Extension
	// Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3,oneof"`
}

func (*AuthConfig_OidcConfig_IdToken) isAuthConfig_OidcConfig_OidcConfig() {}

func (*AuthConfig_OidcConfig_ServiceAccount) isAuthConfig_OidcConfig_OidcConfig() {}

type RuntimeConfig_CodeInterpreterRuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Cloud Storage bucket for file input of this Extension.
	// If specified, support input from the Cloud Storage bucket.
	// Vertex Extension Custom Code Service Agent should be granted
	// file reader to this bucket.
	// If not specified, the extension will only accept file contents from
	// request body and reject Cloud Storage file inputs.
	FileInputGcsBucket string `protobuf:"bytes,1,opt,name=file_input_gcs_bucket,json=fileInputGcsBucket,proto3" json:"file_input_gcs_bucket,omitempty"`
	// Optional. The Cloud Storage bucket for file output of this Extension.
	// If specified, write all output files to the Cloud Storage bucket.
	// Vertex Extension Custom Code Service Agent should be granted
	// file writer to this bucket.
	// If not specified, the file content will be output in response body.
	FileOutputGcsBucket string `protobuf:"bytes,2,opt,name=file_output_gcs_bucket,json=fileOutputGcsBucket,proto3" json:"file_output_gcs_bucket,omitempty"`
}

func (x *RuntimeConfig_CodeInterpreterRuntimeConfig) Reset() {
	*x = RuntimeConfig_CodeInterpreterRuntimeConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeConfig_CodeInterpreterRuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig_CodeInterpreterRuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig_CodeInterpreterRuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig_CodeInterpreterRuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig_CodeInterpreterRuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{4, 0}
}

func (x *RuntimeConfig_CodeInterpreterRuntimeConfig) GetFileInputGcsBucket() string {
	if x != nil {
		return x.FileInputGcsBucket
	}
	return ""
}

func (x *RuntimeConfig_CodeInterpreterRuntimeConfig) GetFileOutputGcsBucket() string {
	if x != nil {
		return x.FileOutputGcsBucket
	}
	return ""
}

type RuntimeConfig_VertexAISearchRuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Vertex AI Search serving config name. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/servingConfigs/{serving_config}`
	ServingConfigName string `protobuf:"bytes,1,opt,name=serving_config_name,json=servingConfigName,proto3" json:"serving_config_name,omitempty"`
	// Optional. Vertex AI Search engine ID. This is used to construct the
	// search request. By setting this engine_id, API will construct the serving
	// config using the default value to call search API for the user. The
	// engine_id and serving_config_name cannot both be empty at the same time.
	EngineId string `protobuf:"bytes,2,opt,name=engine_id,json=engineId,proto3" json:"engine_id,omitempty"`
}

func (x *RuntimeConfig_VertexAISearchRuntimeConfig) Reset() {
	*x = RuntimeConfig_VertexAISearchRuntimeConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeConfig_VertexAISearchRuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig_VertexAISearchRuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig_VertexAISearchRuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig_VertexAISearchRuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig_VertexAISearchRuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP(), []int{4, 1}
}

func (x *RuntimeConfig_VertexAISearchRuntimeConfig) GetServingConfigName() string {
	if x != nil {
		return x.ServingConfigName
	}
	return ""
}

func (x *RuntimeConfig_VertexAISearchRuntimeConfig) GetEngineId() string {
	if x != nil {
		return x.EngineId
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_extension_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_extension_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x07, 0x0a, 0x09, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x53, 0x0a, 0x08,
	0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x12, 0x6b, 0x0a, 0x14, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a,
	0x0a, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x11, 0x74, 0x6f,
	0x6f, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18,
	0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x74, 0x6f, 0x6f,
	0x6c, 0x55, 0x73, 0x65, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x8f, 0x01, 0x0a,
	0x1e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x1b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x7f,
	0xea, 0x41, 0x7c, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x32, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xf0, 0x02, 0x0a, 0x11, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x70, 0x69, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x70, 0x69,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x54, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x61, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x66, 0x0a, 0x07, 0x41, 0x70,
	0x69, 0x53, 0x70, 0x65, 0x63, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x61, 0x70,
	0x69, 0x5f, 0x79, 0x61, 0x6d, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b,
	0x6f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x59, 0x61, 0x6d, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x6f,
	0x70, 0x65, 0x6e, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69,
	0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x42, 0x0a, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x22, 0xa5, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x6c, 0x0a, 0x14,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x0a, 0x0a, 0x0a, 0x41,
	0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x0e, 0x61, 0x70, 0x69,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41,
	0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x61,
	0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x76, 0x0a, 0x16, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x42, 0x61, 0x73,
	0x69, 0x63, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x13,
	0x68, 0x74, 0x74, 0x70, 0x42, 0x61, 0x73, 0x69, 0x63, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x8b, 0x01, 0x0a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x5c, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x59, 0x0a, 0x0b, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0a,
	0x6f, 0x69, 0x64, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x09, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x1a, 0xf0, 0x01, 0x0a, 0x0c, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e,
	0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x6d, 0x0a, 0x15, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x13, 0x68, 0x74, 0x74, 0x70, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x76, 0x0a, 0x13, 0x48, 0x74, 0x74, 0x70, 0x42, 0x61, 0x73,
	0x69, 0x63, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x11,
	0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x63, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x1a, 0x4a, 0x0a,
	0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x6d, 0x0a, 0x0b, 0x4f, 0x61, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x29, 0x0a,
	0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x63, 0x0a, 0x0a, 0x4f, 0x69, 0x64, 0x63,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x69, 0x64, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x29, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0d,
	0x0a, 0x0b, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0d, 0x0a,
	0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xac, 0x05, 0x0a,
	0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x94,
	0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x65, 0x72, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1c, 0x63, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x92, 0x01, 0x0a, 0x1f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x5f, 0x61, 0x69, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x49, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1b, 0x76,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x69, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a, 0x0e, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x1a,
	0x90, 0x01, 0x0a, 0x1c, 0x43, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x36, 0x0a, 0x15, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x67,
	0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x47,
	0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x66,
	0x69, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x1a, 0x74, 0x0a, 0x1b, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x49, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x33, 0x0a, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x49, 0x64, 0x42, 0x21, 0x0a, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x46, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x79, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x84, 0x01, 0x0a, 0x24,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x2a, 0x8d, 0x01, 0x0a, 0x13, 0x48, 0x74, 0x74, 0x70, 0x45, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x48, 0x54,
	0x54, 0x50, 0x5f, 0x49, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x49, 0x4e, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x49,
	0x4e, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x54,
	0x54, 0x50, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x41, 0x54, 0x48, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c,
	0x48, 0x54, 0x54, 0x50, 0x5f, 0x49, 0x4e, 0x5f, 0x42, 0x4f, 0x44, 0x59, 0x10, 0x04, 0x12, 0x12,
	0x0a, 0x0e, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4f, 0x4b, 0x49, 0x45,
	0x10, 0x05, 0x2a, 0x94, 0x01, 0x0a, 0x08, 0x41, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x19, 0x0a, 0x15, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x4f,
	0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x50, 0x49, 0x5f, 0x4b,
	0x45, 0x59, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x48, 0x54, 0x54,
	0x50, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x03, 0x12, 0x1f,
	0x0a, 0x1b, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45,
	0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x04, 0x12,
	0x09, 0x0a, 0x05, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x49,
	0x44, 0x43, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x08, 0x42, 0xa7, 0x04, 0xea, 0x41, 0xbf, 0x01,
	0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x52, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0xea,
	0x41, 0x7c, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x51, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x42, 0x0e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_extension_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_extension_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_extension_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_aiplatform_v1beta1_extension_proto_goTypes = []any{
	(HttpElementLocation)(0),                           // 0: google.cloud.aiplatform.v1beta1.HttpElementLocation
	(AuthType)(0),                                      // 1: google.cloud.aiplatform.v1beta1.AuthType
	(*Extension)(nil),                                  // 2: google.cloud.aiplatform.v1beta1.Extension
	(*ExtensionManifest)(nil),                          // 3: google.cloud.aiplatform.v1beta1.ExtensionManifest
	(*ExtensionOperation)(nil),                         // 4: google.cloud.aiplatform.v1beta1.ExtensionOperation
	(*AuthConfig)(nil),                                 // 5: google.cloud.aiplatform.v1beta1.AuthConfig
	(*RuntimeConfig)(nil),                              // 6: google.cloud.aiplatform.v1beta1.RuntimeConfig
	(*ExtensionPrivateServiceConnectConfig)(nil),       // 7: google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
	(*ExtensionManifest_ApiSpec)(nil),                  // 8: google.cloud.aiplatform.v1beta1.ExtensionManifest.ApiSpec
	(*AuthConfig_ApiKeyConfig)(nil),                    // 9: google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig
	(*AuthConfig_HttpBasicAuthConfig)(nil),             // 10: google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
	(*AuthConfig_GoogleServiceAccountConfig)(nil),      // 11: google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
	(*AuthConfig_OauthConfig)(nil),                     // 12: google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig
	(*AuthConfig_OidcConfig)(nil),                      // 13: google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig
	(*RuntimeConfig_CodeInterpreterRuntimeConfig)(nil), // 14: google.cloud.aiplatform.v1beta1.RuntimeConfig.CodeInterpreterRuntimeConfig
	(*RuntimeConfig_VertexAISearchRuntimeConfig)(nil),  // 15: google.cloud.aiplatform.v1beta1.RuntimeConfig.VertexAISearchRuntimeConfig
	(*timestamppb.Timestamp)(nil),                      // 16: google.protobuf.Timestamp
	(*ToolUseExample)(nil),                             // 17: google.cloud.aiplatform.v1beta1.ToolUseExample
	(*FunctionDeclaration)(nil),                        // 18: google.cloud.aiplatform.v1beta1.FunctionDeclaration
	(*structpb.Struct)(nil),                            // 19: google.protobuf.Struct
}
var file_google_cloud_aiplatform_v1beta1_extension_proto_depIdxs = []int32{
	16, // 0: google.cloud.aiplatform.v1beta1.Extension.create_time:type_name -> google.protobuf.Timestamp
	16, // 1: google.cloud.aiplatform.v1beta1.Extension.update_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.aiplatform.v1beta1.Extension.manifest:type_name -> google.cloud.aiplatform.v1beta1.ExtensionManifest
	4,  // 3: google.cloud.aiplatform.v1beta1.Extension.extension_operations:type_name -> google.cloud.aiplatform.v1beta1.ExtensionOperation
	6,  // 4: google.cloud.aiplatform.v1beta1.Extension.runtime_config:type_name -> google.cloud.aiplatform.v1beta1.RuntimeConfig
	17, // 5: google.cloud.aiplatform.v1beta1.Extension.tool_use_examples:type_name -> google.cloud.aiplatform.v1beta1.ToolUseExample
	7,  // 6: google.cloud.aiplatform.v1beta1.Extension.private_service_connect_config:type_name -> google.cloud.aiplatform.v1beta1.ExtensionPrivateServiceConnectConfig
	8,  // 7: google.cloud.aiplatform.v1beta1.ExtensionManifest.api_spec:type_name -> google.cloud.aiplatform.v1beta1.ExtensionManifest.ApiSpec
	5,  // 8: google.cloud.aiplatform.v1beta1.ExtensionManifest.auth_config:type_name -> google.cloud.aiplatform.v1beta1.AuthConfig
	18, // 9: google.cloud.aiplatform.v1beta1.ExtensionOperation.function_declaration:type_name -> google.cloud.aiplatform.v1beta1.FunctionDeclaration
	9,  // 10: google.cloud.aiplatform.v1beta1.AuthConfig.api_key_config:type_name -> google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig
	10, // 11: google.cloud.aiplatform.v1beta1.AuthConfig.http_basic_auth_config:type_name -> google.cloud.aiplatform.v1beta1.AuthConfig.HttpBasicAuthConfig
	11, // 12: google.cloud.aiplatform.v1beta1.AuthConfig.google_service_account_config:type_name -> google.cloud.aiplatform.v1beta1.AuthConfig.GoogleServiceAccountConfig
	12, // 13: google.cloud.aiplatform.v1beta1.AuthConfig.oauth_config:type_name -> google.cloud.aiplatform.v1beta1.AuthConfig.OauthConfig
	13, // 14: google.cloud.aiplatform.v1beta1.AuthConfig.oidc_config:type_name -> google.cloud.aiplatform.v1beta1.AuthConfig.OidcConfig
	1,  // 15: google.cloud.aiplatform.v1beta1.AuthConfig.auth_type:type_name -> google.cloud.aiplatform.v1beta1.AuthType
	14, // 16: google.cloud.aiplatform.v1beta1.RuntimeConfig.code_interpreter_runtime_config:type_name -> google.cloud.aiplatform.v1beta1.RuntimeConfig.CodeInterpreterRuntimeConfig
	15, // 17: google.cloud.aiplatform.v1beta1.RuntimeConfig.vertex_ai_search_runtime_config:type_name -> google.cloud.aiplatform.v1beta1.RuntimeConfig.VertexAISearchRuntimeConfig
	19, // 18: google.cloud.aiplatform.v1beta1.RuntimeConfig.default_params:type_name -> google.protobuf.Struct
	0,  // 19: google.cloud.aiplatform.v1beta1.AuthConfig.ApiKeyConfig.http_element_location:type_name -> google.cloud.aiplatform.v1beta1.HttpElementLocation
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_extension_proto_init() }
func file_google_cloud_aiplatform_v1beta1_extension_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_extension_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_init()
	file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[3].OneofWrappers = []any{
		(*AuthConfig_ApiKeyConfig_)(nil),
		(*AuthConfig_HttpBasicAuthConfig_)(nil),
		(*AuthConfig_GoogleServiceAccountConfig_)(nil),
		(*AuthConfig_OauthConfig_)(nil),
		(*AuthConfig_OidcConfig_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[4].OneofWrappers = []any{
		(*RuntimeConfig_CodeInterpreterRuntimeConfig_)(nil),
		(*RuntimeConfig_VertexAiSearchRuntimeConfig)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[6].OneofWrappers = []any{
		(*ExtensionManifest_ApiSpec_OpenApiYaml)(nil),
		(*ExtensionManifest_ApiSpec_OpenApiGcsUri)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[10].OneofWrappers = []any{
		(*AuthConfig_OauthConfig_AccessToken)(nil),
		(*AuthConfig_OauthConfig_ServiceAccount)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes[11].OneofWrappers = []any{
		(*AuthConfig_OidcConfig_IdToken)(nil),
		(*AuthConfig_OidcConfig_ServiceAccount)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_extension_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_extension_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_extension_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_extension_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_extension_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_extension_proto = out.File
	file_google_cloud_aiplatform_v1beta1_extension_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_extension_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_extension_proto_depIdxs = nil
}
