#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

extern gnu_get_libc_version(void);

int main(void) {
  void *p;

  printf("Press ENTER when ready.\n");
  getchar();

  printf("libc version: %s\n", gnu_get_libc_version());

  /* Check if an ordinary memory allocation is workinng.  */
  posix_memalign(&p, 1024, 8);
  ((char *)p)[1023] = 'a';

  memset (p, 'a', 1024);
  for (int i = 0; i < 1024; i++) {
    if (((char *)p)[i] != 'a') {
      printf ("error writing to memalign pointer \n");
      return 1;
    }
  }

  printf("Memory allocation works\n");

  /* Trigger the problem.  */
  int r;
  r = posix_memalign(&p, 1ULL << 63, PTRDIFF_MAX - 0x30);

  if (r == ENOMEM)
    printf("memalign bug is fixed\n");
  else
    printf("Wrong error code. Bug may still be there.\n");

  return 0;
}
