#include <stdint.h>
#include <stddef.h>
#include <errno.h>

#define __set_errno(val) (errno = (val))

struct malloc_state;
typedef struct malloc_state *mstate;


/* Defined in common.h, used to call unpatched function.  */
void *call_old_func(void *p1, void *p2, void *p3, void *p4,
                           void *p5, void *p6, void *func);

#define CALL_OLD_FUNCTION_3(func, arg1, arg2, arg3)   \
  call_old_func((void *)(arg1), (void *)(arg2), (void *)(arg3), NULL, NULL, NULL, func)


void *(*klpe_int_memalign) (mstate av, size_t alignment, size_t bytes) __attribute__((used)) __attribute__((visibility ("default")));


/* This patch was manually created because its simpler to call the original
   function rather than extract thousand lines of code.  */

__attribute__((visibility ("default")))
void *
_int_memalign_lp (mstate av, size_t alignment, size_t bytes)
{

  if (bytes > PTRDIFF_MAX || alignment > PTRDIFF_MAX)
    {
      __set_errno (ENOMEM);
      return NULL;
    }

  return CALL_OLD_FUNCTION_3 (klpe_int_memalign, av, alignment, bytes);
}
