#ARCHS="x86_64 ppc64le"
ARCHS="ppc64le"
declare -A PLATFORM_HASH=( ["x86_64"]="SLE-15-SP3 SLE-15-SP6 SLE-15-SP7 ALP SLFO:1.1 SLFO:1.2"
                           ["ppc64le"]="SLE-15-SP6 SLFO:1.2"
                         )

for arch in ${ARCHS}; do
  PLATFORMS=${PLATFORM_HASH[$arch]}
  for platform in ${PLATFORMS}; do
    setup_package.sh --platform=$platform --arch=$arch --package=glibc --no-src-download
    find $arch/$platform -type f  ! -name "*.json"  -delete
    find $arch/$platform -xtype l -delete
    mv -f $arch/$platform/glibc/* $arch/
    rm -rf $arch/$platform

    # Create symlink to some important files.
    find -type f -name "libc-2.31.so.json" -exec sh -c 'ln -s $(basename {}) $(dirname {})/libc.so.6.json' \;
  done
done

# Delete empty directories
find . -type d -empty -print -delete
