@bootstrap
Feature: crmsh bootstrap process - init, join and remove

  Test crmsh bootstrap init/join/remove process
  Need nodes: hanode1 hanode2 hanode3

  Background: Setup a two nodes cluster
    Given   Nodes ["hanode1", "hanode2", "hanode3"] are cleaned up
    And     Cluster service is "stopped" on "hanode1"
    And     Cluster service is "stopped" on "hanode2"
    When    Run "crm cluster init -y" on "hanode1"
    Then    Cluster service is "started" on "hanode1"
    And     Show cluster status on "hanode1"
    When    Run "crm cluster join -c hanode1 -y" on "hanode2"
    Then    Cluster service is "started" on "hanode2"
    And     Online nodes are "hanode1 hanode2"
    And     two_node in corosync.conf is "1"
    And     Show cluster status on "hanode1"
    And     Cluster is using "knet" transport mode

  Scenario: Init cluster service on node "hanode1", and join on node "hanode2"
    Then    Run "corosync-cmapctl|grep "votequorum.two_node .* = 1"" OK
    Then    Run "corosync-cmapctl|grep "votequorum.two_node .* = 1"" OK on "hanode2"

  Scenario: Support --all or specific node to manage cluster and nodes
    When    Run "crm node standby --all" on "hanode1"
    Then    Node "hanode1" is standby
    And     Node "hanode2" is standby
    When    Run "crm node online --all" on "hanode1"
    Then    Node "hanode1" is online
    And     Node "hanode2" is online
    When    Wait for DC
    When    Run "crm cluster stop --all" on "hanode1"
    Then    Cluster service is "stopped" on "hanode1"
    And     Cluster service is "stopped" on "hanode2"
    When    Run "crm cluster start --all" on "hanode1"
    Then    Cluster service is "started" on "hanode1"
    And     Cluster service is "started" on "hanode2"
    When    Wait for DC
    When    Run "crm cluster stop hanode2" on "hanode1"
    Then    Cluster service is "stopped" on "hanode2"
    When    Run "crm cluster start hanode2" on "hanode1"
    Then    Cluster service is "started" on "hanode2"
    When    Run "crm cluster disable hanode2" on "hanode1"
    Then    Cluster service is "disabled" on "hanode2"
    When    Run "crm cluster enable hanode2" on "hanode1"
    Then    Cluster service is "enabled" on "hanode2"
    When    Run "crm cluster restart --all" on "hanode1"
    Then    Cluster service is "started" on "hanode1"
    And     Cluster service is "started" on "hanode2"

  Scenario: Remove peer node "hanode2"
    When    Run "crm configure primitive d1 Dummy" on "hanode1"
    When    Run "crm configure primitive d2 Dummy" on "hanode2"
    Then    File "/etc/corosync/authkey" exists on "hanode2"
    Then    File "/etc/corosync/corosync.conf" exists on "hanode2"
    Then    File "/etc/pacemaker/authkey" exists on "hanode2"
    Then    Directory "/var/lib/pacemaker/cib/" not empty on "hanode2"
    Then    Directory "/var/lib/corosync/" not empty on "hanode2"
    When    Run "crm cluster remove hanode2 -y" on "hanode1"
    Then    Cluster service is "started" on "hanode1"
    And     Cluster service is "stopped" on "hanode2"
    And     Online nodes are "hanode1"
    And     two_node in corosync.conf is "0"
    And     Show cluster status on "hanode1"
    Then    File "/etc/corosync/authkey" not exist on "hanode2"
    Then    File "/etc/corosync/corosync.conf" not exist on "hanode2"
    Then    File "/etc/pacemaker/authkey" not exist on "hanode2"
    Then    Directory "/var/lib/pacemaker/cib/" is empty on "hanode2"
    Then    Directory "/var/lib/pacemaker/pengine/" is empty on "hanode2"
    Then    Directory "/var/lib/corosync/" is empty on "hanode2"
    When    Try "crm cluster run "crm cluster stop" hanode1" on "hanode2"
    Then    Expected "Cannot get the member list of the cluster" in stderr

  Scenario: Remove peer node when cluster is not running
    Then    File "/etc/corosync/authkey" exists on "hanode2"
    Then    File "/etc/corosync/corosync.conf" exists on "hanode2"
    Then    File "/etc/pacemaker/authkey" exists on "hanode2"
    Then    Directory "/var/lib/pacemaker/cib/" not empty on "hanode2"
    Then    Directory "/var/lib/corosync/" not empty on "hanode2"
    When    Run "crm cluster stop" on "hanode2"
    When    Try "crm cluster remove @hanode2.ip.0 -y" on "hanode1"
    Then    Expected "Node @hanode2.ip.0 is not configured in cluster! (valid nodes: hanode1, hanode2)" in stderr
    When    Run "crm cluster remove hanode2 -y" on "hanode1"
    Then    File "/etc/corosync/authkey" not exist on "hanode2"
    Then    File "/etc/corosync/corosync.conf" not exist on "hanode2"
    Then    File "/etc/pacemaker/authkey" not exist on "hanode2"
    Then    Directory "/var/lib/pacemaker/cib/" is empty on "hanode2"
    Then    Directory "/var/lib/pacemaker/pengine/" is empty on "hanode2"
    Then    Directory "/var/lib/corosync/" is empty on "hanode2"

  Scenario: Remove local node "hanode1"
    When    Run "crm configure primitive d1 Dummy" on "hanode1"
    When    Run "crm configure primitive d2 Dummy" on "hanode1"
    Then    File "/etc/corosync/authkey" exists on "hanode1"
    Then    File "/etc/corosync/corosync.conf" exists on "hanode1"
    Then    File "/etc/pacemaker/authkey" exists on "hanode1"
    Then    Directory "/var/lib/pacemaker/cib/" not empty on "hanode1"
    Then    Directory "/var/lib/corosync/" not empty on "hanode1"
    When    Run "crm cluster remove hanode1 -y --force" on "hanode1"
    Then    Cluster service is "stopped" on "hanode1"
    And     Cluster service is "started" on "hanode2"
    And     Show cluster status on "hanode2"
    Then    File "/etc/corosync/authkey" not exist on "hanode1"
    Then    File "/etc/corosync/corosync.conf" not exist on "hanode1"
    Then    File "/etc/pacemaker/authkey" not exist on "hanode1"
    Then    Directory "/var/lib/pacemaker/cib/" is empty on "hanode1"
    Then    Directory "/var/lib/pacemaker/pengine/" is empty on "hanode1"
    Then    Directory "/var/lib/corosync/" is empty on "hanode1"

  Scenario: Remove peer node "hanode2" with `crm -F node delete`
    When    Run "crm configure primitive d1 Dummy" on "hanode1"
    When    Run "crm configure primitive d2 Dummy" on "hanode2"
    Then    File "/etc/corosync/authkey" exists on "hanode2"
    Then    File "/etc/corosync/corosync.conf" exists on "hanode2"
    Then    File "/etc/pacemaker/authkey" exists on "hanode2"
    Then    Directory "/var/lib/pacemaker/cib/" not empty on "hanode2"
    Then    Directory "/var/lib/corosync/" not empty on "hanode2"
    When    Run "crm -F cluster remove hanode2" on "hanode1"
    Then    Cluster service is "started" on "hanode1"
    And     Cluster service is "stopped" on "hanode2"
    And     Online nodes are "hanode1"
    And     Show cluster status on "hanode1"
    Then    File "/etc/corosync/authkey" not exist on "hanode2"
    Then    File "/etc/corosync/corosync.conf" not exist on "hanode2"
    Then    File "/etc/pacemaker/authkey" not exist on "hanode2"
    Then    Directory "/var/lib/pacemaker/cib/" is empty on "hanode2"
    Then    Directory "/var/lib/pacemaker/pengine/" is empty on "hanode2"
    Then    Directory "/var/lib/corosync/" is empty on "hanode2"
    When    Run "crm cluster remove hanode1 -y --force" on "hanode1"
    Then    File "/etc/corosync/corosync.conf" not exist on "hanode1"

  Scenario: Remove local node "hanode1" with `crm -F node delete`
    When    Run "crm configure primitive d1 Dummy" on "hanode1"
    When    Run "crm configure primitive d2 Dummy" on "hanode1"
    Then    File "/etc/corosync/authkey" exists on "hanode1"
    Then    File "/etc/corosync/corosync.conf" exists on "hanode1"
    Then    File "/etc/pacemaker/authkey" exists on "hanode1"
    Then    Directory "/var/lib/pacemaker/cib/" not empty on "hanode1"
    Then    Directory "/var/lib/corosync/" not empty on "hanode1"
    When    Run "crm -F node delete hanode1" on "hanode1"
    Then    Cluster service is "stopped" on "hanode1"
    And     Cluster service is "started" on "hanode2"
    And     Show cluster status on "hanode2"
    Then    File "/etc/corosync/authkey" not exist on "hanode1"
    Then    File "/etc/corosync/corosync.conf" not exist on "hanode1"
    Then    File "/etc/pacemaker/authkey" not exist on "hanode1"
    Then    Directory "/var/lib/pacemaker/cib/" is empty on "hanode1"
    Then    Directory "/var/lib/pacemaker/pengine/" is empty on "hanode1"
    Then    Directory "/var/lib/corosync/" is empty on "hanode1"

  Scenario: Check hacluster's passwordless configuration on 2 nodes
    Then    Check user shell for hacluster between "hanode1 hanode2"
    Then    Check passwordless for hacluster between "hanode1 hanode2" "successfully"

  Scenario: Check hacluster's passwordless configuration in old cluster, 2 nodes
    When    Run "crm cluster stop --all" on "hanode1"
    Then    Cluster service is "stopped" on "hanode1"
    And     Cluster service is "stopped" on "hanode2"
    When    Run "crm cluster init -y" on "hanode1"
    Then    Cluster service is "started" on "hanode1"
    When    Run "rm -rf /var/lib/pacemaker/.ssh" on "hanode1"
    Then    Check passwordless for hacluster between "hanode1 hanode2" "failed"
    When    Run "crm cluster join -c hanode1 -y" on "hanode2"
    Then    Cluster service is "started" on "hanode2"
    And     Online nodes are "hanode1 hanode2"
    And     Check passwordless for hacluster between "hanode1 hanode2" "successfully"

  Scenario: Check hacluster's passwordless configuration on 3 nodes
    Given   Cluster service is "stopped" on "hanode3"
    When    Run "crm cluster join -c hanode1 -y" on "hanode3"
    Then    Cluster service is "started" on "hanode3"
    And     Online nodes are "hanode1 hanode2 hanode3"
    And     Check user shell for hacluster between "hanode1 hanode2 hanode3"
    And     Check passwordless for hacluster between "hanode1 hanode2 hanode3" "successfully"

  Scenario: Check hacluster's passwordless configuration in old cluster, 3 nodes
    Given   Cluster service is "stopped" on "hanode3"
    When    Run "rm -rf /var/lib/pacemaker/.ssh" on "hanode1"
    And     Run "rm -rf /var/lib/pacemaker/.ssh" on "hanode2"
    Then    Check passwordless for hacluster between "hanode1 hanode2 hanode3" "failed"
    When    Run "crm cluster join -c hanode1 -y" on "hanode3"
    Then    Cluster service is "started" on "hanode3"
    And     Online nodes are "hanode1 hanode2 hanode3"
    And     Check passwordless for hacluster between "hanode1 hanode2 hanode3" "successfully"

  @skip_non_root
  Scenario: Remove offline and unreachable node
    When    Run "init 0" on "hanode2"
    Then    Online nodes are "hanode1"
    When    Run "sleep 10" on "hanode1"
    When    Try "crm cluster remove hanode2 -y" on "hanode1"
    Then    Expected "There are offline nodes also unreachable: hanode2" in stderr
    When    Try "crm status|grep "OFFLINE.*hanode2"" on "hanode1"
    Then    Expected return code is "0"
    When    Run "crm cluster remove hanode2 -y --force" on "hanode1"
    When    Try "crm status|grep "OFFLINE.*hanode2"" on "hanode1"
    Then    Expected return code is "1"
