/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PropertyNotFoundException;
import net.sf.hibernate.Query;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.type.SerializableType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;

public class QueryImpl
implements Query {
    private final SessionImplementor session;
    private String queryString;
    private RowSelection selection;
    private ArrayList values = new ArrayList(4);
    private ArrayList types = new ArrayList(4);
    private Map namedParameters = new HashMap(4);
    private Map namedParameterLists = new HashMap(4);
    private Map lockModes = new HashMap(2);
    static final Type[] NO_TYPES = new Type[0];

    public QueryImpl(String queryString, SessionImplementor session) {
        this.session = session;
        this.queryString = queryString;
        this.selection = new RowSelection();
    }

    public Iterator iterate() throws HibernateException {
        HashMap namedParams = new HashMap(this.namedParameters);
        String query = this.bindParameterLists(namedParams);
        return this.session.iterate(query, this.values.toArray(), this.types.toArray(NO_TYPES), this.selection, namedParams, this.lockModes);
    }

    public ScrollableResults scroll() throws HibernateException {
        HashMap namedParams = new HashMap(this.namedParameters);
        String query = this.bindParameterLists(namedParams);
        return this.session.scroll(query, this.values.toArray(), this.types.toArray(NO_TYPES), this.selection, namedParams, this.lockModes);
    }

    public List list() throws HibernateException {
        HashMap namedParams = new HashMap(this.namedParameters);
        String query = this.bindParameterLists(namedParams);
        return this.session.find(query, this.values.toArray(), this.types.toArray(NO_TYPES), this.selection, namedParams, this.lockModes);
    }

    public Query setMaxResults(int maxResults) {
        this.selection.setMaxRows(new Integer(maxResults));
        return this;
    }

    public Query setTimeout(int timeout) {
        this.selection.setTimeout(new Integer(timeout));
        return this;
    }

    public Query setFirstResult(int firstResult) {
        this.selection.setFirstRow(new Integer(firstResult));
        return this;
    }

    public Query setParameter(int position, Object val, Type type) {
        int size = this.values.size();
        if (position < size) {
            this.values.set(position, val);
            this.types.set(position, type);
        } else {
            int i = 0;
            while (i < position - size) {
                this.values.add(null);
                this.types.add(null);
                ++i;
            }
            this.values.add(val);
            this.types.add(type);
        }
        return this;
    }

    public Query setString(int position, String val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.STRING);
        return this;
    }

    public Query setCharacter(int position, char val) {
        this.setParameter(position, (Object)new Character(val), (Type)Hibernate.CHARACTER);
        return this;
    }

    public Query setBoolean(int position, boolean val) {
        this.setParameter(position, (Object)new Boolean(val), (Type)Hibernate.BOOLEAN);
        return this;
    }

    public Query setByte(int position, byte val) {
        this.setParameter(position, (Object)new Byte(val), (Type)Hibernate.BYTE);
        return this;
    }

    public Query setShort(int position, short val) {
        this.setParameter(position, (Object)new Short(val), (Type)Hibernate.SHORT);
        return this;
    }

    public Query setInteger(int position, int val) {
        this.setParameter(position, (Object)new Integer(val), (Type)Hibernate.INTEGER);
        return this;
    }

    public Query setLong(int position, long val) {
        this.setParameter(position, (Object)new Long(val), (Type)Hibernate.LONG);
        return this;
    }

    public Query setFloat(int position, float val) {
        this.setParameter(position, (Object)new Float(val), (Type)Hibernate.FLOAT);
        return this;
    }

    public Query setDouble(int position, double val) {
        this.setParameter(position, (Object)new Double(val), (Type)Hibernate.DOUBLE);
        return this;
    }

    public Query setBinary(int position, byte[] val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.BINARY);
        return this;
    }

    public Query setSerializable(int position, Serializable val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.SERIALIZABLE);
        return this;
    }

    public Query setDate(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.DATE);
        return this;
    }

    public Query setTime(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.TIME);
        return this;
    }

    public Query setTimestamp(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.TIMESTAMP);
        return this;
    }

    public Query setEntity(int position, Object val) {
        this.setParameter(position, val, Hibernate.entity(HibernateProxyHelper.getClass(val)));
        return this;
    }

    public Query setEnum(int position, Object val) throws MappingException {
        this.setParameter(position, val, Hibernate.enum(val.getClass()));
        return this;
    }

    public Query setLocale(int position, Locale locale) {
        this.setParameter(position, (Object)locale, (Type)Hibernate.LOCALE);
        return this;
    }

    public Query setCalendar(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)Hibernate.CALENDAR);
        return this;
    }

    public Query setCalendarDate(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
        return this;
    }

    public Query setBinary(String name, byte[] val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.BINARY);
        return this;
    }

    public Query setBoolean(String name, boolean val) {
        this.setParameter(name, (Object)new Boolean(val), (Type)Hibernate.BOOLEAN);
        return this;
    }

    public Query setByte(String name, byte val) {
        this.setParameter(name, (Object)new Byte(val), (Type)Hibernate.BYTE);
        return this;
    }

    public Query setCharacter(String name, char val) {
        this.setParameter(name, (Object)new Character(val), (Type)Hibernate.CHARACTER);
        return this;
    }

    public Query setDate(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.DATE);
        return this;
    }

    public Query setDouble(String name, double val) {
        this.setParameter(name, (Object)new Double(val), (Type)Hibernate.DOUBLE);
        return this;
    }

    public Query setEntity(String name, Object val) {
        this.setParameter(name, val, Hibernate.entity(HibernateProxyHelper.getClass(val)));
        return this;
    }

    public Query setEnum(String name, Object val) throws MappingException {
        this.setParameter(name, val, Hibernate.enum(val.getClass()));
        return this;
    }

    public Query setFloat(String name, float val) {
        this.setParameter(name, (Object)new Float(val), (Type)Hibernate.FLOAT);
        return this;
    }

    public Query setInteger(String name, int val) {
        this.setParameter(name, (Object)new Integer(val), (Type)Hibernate.INTEGER);
        return this;
    }

    public Query setLocale(String name, Locale locale) {
        this.setParameter(name, (Object)locale, (Type)Hibernate.LOCALE);
        return this;
    }

    public Query setCalendar(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)Hibernate.CALENDAR);
        return this;
    }

    public Query setCalendarDate(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
        return this;
    }

    public Query setLong(String name, long val) {
        this.setParameter(name, (Object)new Long(val), (Type)Hibernate.LONG);
        return this;
    }

    public Query setParameter(String name, Object val, Type type) {
        this.namedParameters.put(name, new TypedValue(type, val));
        return this;
    }

    public Query setSerializable(String name, Serializable val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.SERIALIZABLE);
        return this;
    }

    public Query setShort(String name, short val) {
        this.setParameter(name, (Object)new Short(val), (Type)Hibernate.SHORT);
        return this;
    }

    public Query setString(String name, String val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.STRING);
        return this;
    }

    public Query setTime(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.TIME);
        return this;
    }

    public Query setTimestamp(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.TIMESTAMP);
        return this;
    }

    public Query setBigDecimal(int position, BigDecimal number) {
        this.setParameter(position, (Object)number, (Type)Hibernate.BIG_DECIMAL);
        return this;
    }

    public Query setBigDecimal(String name, BigDecimal number) {
        this.setParameter(name, (Object)number, (Type)Hibernate.BIG_DECIMAL);
        return this;
    }

    public Query setParameter(int position, Object val) throws HibernateException {
        this.setParameter(position, val, this.guessType(val));
        return this;
    }

    public Query setParameter(String name, Object val) throws HibernateException {
        this.setParameter(name, val, this.guessType(val));
        return this;
    }

    private Type guessType(Object param) throws HibernateException {
        Class clazz = HibernateProxyHelper.getClass(param);
        return this.guessType(clazz);
    }

    private Type guessType(Class clazz) throws HibernateException {
        boolean serializable;
        String typename = clazz.getName();
        Type type = TypeFactory.hueristicType(typename);
        boolean bl = serializable = type != null && type instanceof SerializableType;
        if (type == null || serializable) {
            try {
                this.session.getFactory().getPersister(clazz);
            }
            catch (MappingException me) {
                if (serializable) {
                    return type;
                }
                throw new HibernateException("Could not determine a type for class: " + typename);
            }
            return Hibernate.entity(clazz);
        }
        return type;
    }

    public Type[] getReturnTypes() throws HibernateException {
        return this.session.getFactory().getReturnTypes(this.queryString);
    }

    public Query setParameterList(String name, Collection vals, Type type) throws HibernateException {
        this.namedParameterLists.put(name, new TypedValue(type, vals));
        return this;
    }

    protected String bindParameterLists(Map namedParams) {
        Iterator iter = this.namedParameterLists.entrySet().iterator();
        String query = this.queryString;
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            query = this.bindParameterList(query, (String)me.getKey(), (TypedValue)me.getValue(), namedParams);
        }
        return query;
    }

    private String bindParameterList(String queryString, String name, TypedValue typedList, Map namedParams) {
        Collection vals = (Collection)typedList.getValue();
        Type type = typedList.getType();
        StringBuffer list = new StringBuffer(16);
        Iterator iter = vals.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String alias = name + i++ + '_';
            namedParams.put(alias, new TypedValue(type, iter.next()));
            list.append(':' + alias);
            if (!iter.hasNext()) continue;
            list.append(", ");
        }
        return StringHelper.replace(queryString, ':' + name, list.toString());
    }

    public Query setParameterList(String name, Collection vals) throws HibernateException {
        this.setParameterList(name, vals, this.guessType(vals.iterator().next()));
        return this;
    }

    public String[] getNamedParameters() throws HibernateException {
        return ArrayHelper.toStringArray(this.session.getFactory().getNamedParameters(this.queryString));
    }

    public Query setProperties(Object bean) throws HibernateException {
        Class<?> clazz = bean.getClass();
        Iterator iter = this.session.getFactory().getNamedParameters(this.queryString).iterator();
        while (iter.hasNext()) {
            String namedParam = (String)iter.next();
            try {
                ReflectHelper.Getter getter = ReflectHelper.getGetter(clazz, namedParam);
                this.setParameter(namedParam, getter.get(bean), this.guessType(getter.getReturnType()));
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
        }
        return this;
    }

    SessionImplementor getSession() {
        return this.session;
    }

    ArrayList getValues() {
        return this.values;
    }

    ArrayList getTypes() {
        return this.types;
    }

    RowSelection getSelection() {
        return this.selection;
    }

    public String getQueryString() {
        return this.queryString;
    }

    Map getNamedParams() {
        return this.namedParameters;
    }

    public Query setParameterList(String name, Object[] vals, Type type) throws HibernateException {
        return this.setParameterList(name, Arrays.asList(vals), type);
    }

    public Query setParameterList(String name, Object[] vals) throws HibernateException {
        return this.setParameterList(name, Arrays.asList(vals));
    }

    public void setLockMode(String alias, LockMode lockMode) {
        this.lockModes.put(alias, lockMode);
    }

    Map getLockModes() {
        return this.lockModes;
    }
}

