```toml
[advisory]
id = "RUSTSEC-2020-0097"
package = "xcb"
aliases = ["CVE-2020-36205", "GHSA-c8hq-x4mm-p6q6"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-12-10"
url = "https://github.com/rust-x-bindings/rust-xcb/issues/93"
categories = ["memory-corruption", "thread-safety"]
informational = "unsound"

[versions]
patched = [">= 1.0"]
```

# Soundness issue with base::Error

`base::Error` type contains public field named `ptr`.
With this definition, it is possible to create a `base::Error` with an invalid pointer and trigger memory safety errors
such as use-after-free or double-free with safe Rust.

The users of `xcb` crate are advised not to manipulate the field.
