```toml
[advisory]
id = "RUSTSEC-2022-0075"
package = "wasmtime"
date = "2022-11-10"
url = "https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-wh6w-3828-g9qf"
references = ["https://github.com/bytecodealliance/wasmtime/commit/2614f2e9d2d36805ead8a8da0fa0c6e0d9e428a0", "https://github.com/bytecodealliance/wasmtime/commit/3535acbf3be032ef1ba0b469b8ab92538a8a18a6"]
categories = ["memory-exposure"]
keywords = ["use-after-free", "Wasm", "garbage collection"]
aliases = ["CVE-2022-39393", "GHSA-wh6w-3828-g9qf"]

[versions]
patched = [">= 1.0.2, < 2.0.0", ">= 2.0.2"]
```

# Bug in pooling instance allocator

bug in Wasmtime's implementation of its pooling instance allocator where when a linear memory is reused for another instance the initial heap snapshot of the prior instance can be visible, erroneously to the next instance.

Mitigations are described [here](https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-wh6w-3828-g9qf).
