```toml
[advisory]
id = "RUSTSEC-2023-0056"
package = "vm-memory"
date = "2023-09-01"
url = "https://github.com/rust-vmm/vm-memory/issues/250"
references = ["https://github.com/rust-vmm/vm-memory/commit/aff1dd4a5259f7deba56692840f7a2d9ca34c9c8"]
informational = "unsound"
categories = ["memory-exposure"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:L"
aliases = ["CVE-2023-41051", "GHSA-49hh-fprx-m68g"]

[affected]
[affected.functions]
"vm_memory::volatile_memory::VolatileMemory::get_atomic_ref" = ["< 0.12.2"]
"vm_memory::volatile_memory::VolatileMemory::aligned_as_ref" = ["< 0.12.2"]
"vm_memory::volatile_memory::VolatileMemory::aligned_as_mut" = ["< 0.12.2"]
"vm_memory::volatile_memory::VolatileMemory::get_ref" = ["< 0.12.2"]
"vm_memory::volatile_memory::VolatileMemory::get_array_ref" = ["< 0.12.2"]

[versions]
patched = [">= 0.12.2"]
```

# Default functions in VolatileMemory trait lack bounds checks, potentially leading to out-of-bounds memory accesses 

An issue was discovered in the default implementations of the `VolatileMemory::{get_atomic_ref, aligned_as_ref, aligned_as_mut, get_ref, get_array_ref}` trait functions, which allows out-of-bounds memory access if the `VolatileMemory::get_slice` function returns a `VolatileSlice` whose length is less than the function’s `count` argument. No implementations of `get_slice` provided in `vm_memory` are affected. Users of custom `VolatileMemory` implementations may be impacted if the custom implementation does not adhere to `get_slice`'s documentation.

The issue started in version 0.1.0 but was fixed in version 0.12.2 by inserting a check that verifies that the `VolatileSlice` returned by `get_slice` is of the correct length.
