```toml
[advisory]
id = "RUSTSEC-2020-0087"
package = "try-mutex"
aliases = ["CVE-2020-35924", "GHSA-64j8-7gp2-xjx5"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-17"
url = "https://github.com/mpdn/try-mutex/issues/2"
categories = ["thread-safety"]

[versions]
patched = [">= 0.3.0"]
```

# TryMutex<T> allows sending non-Send type across threads

Affected versions of this crate unconditionally implemented Sync trait for `TryMutex<T>` type.

This allows users to put non-Send `T` type in `TryMutex` and send it to another thread, which can cause a data race.

The flaw was corrected in the 0.3.0 release by adding `T: Send` bound for the Sync trait implementation.
