```toml
[advisory]
id = "RUSTSEC-2020-0136"
package = "toolshed"
date = "2020-11-15"
url = "https://github.com/ratel-rust/toolshed/issues/12"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]
aliases = ["CVE-2020-36456", "GHSA-2r6q-6c8c-g762"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# CopyCell lacks bounds on its Send trait allowing for data races

`CopyCell<T>` is a `Cell`-like type that is implemented for any type `T` that
is `Copy`able. It's `Send` trait has no bounds on the contained type.

As not all `Copy`able types are thread safe, for example non-mutable references
implement the `Copy` trait, it is possible to send references to types with
interior mutability such as `Cell` across threads and cause data races.
