```toml
[advisory]
id = "RUSTSEC-2023-0001"
package = "tokio"
aliases = ["CVE-2023-22466", "GHSA-7rrj-xr53-82p7"]
date = "2023-01-04"
url = "https://github.com/tokio-rs/tokio/security/advisories/GHSA-7rrj-xr53-82p7"
references = ["https://github.com/tokio-rs/tokio/pull/5336", "https://learn.microsoft.com/en-us/windows/win32/api/winbase/nf-winbase-createnamedpipea#pipe_reject_remote_clients"]
keywords = ["configuration failure"]

[versions]
patched = [">= 1.18.4, < 1.19.0", ">= 1.20.3, < 1.21.0", ">= 1.23.1"]
unaffected = ["< 1.7.0"]

[affected]
os = ["windows"]
```

# reject_remote_clients Configuration corruption

On Windows, configuring a named pipe server with [pipe_mode] will force [ServerOptions]::[reject_remote_clients] as `false`.

This drops any intended explicit configuration for the [reject_remote_clients] that may have been set as `true` previously.

The default setting of [reject_remote_clients] is normally `true` meaning the default is also overridden as `false`.

## Workarounds

Ensure that [pipe_mode] is set first after initializing a [ServerOptions]. For example:

```rust
let mut opts = ServerOptions::new();
opts.pipe_mode(PipeMode::Message);
opts.reject_remote_clients(true);
```

[ServerOptions]: https://docs.rs/tokio/latest/tokio/net/windows/named_pipe/struct.ServerOptions.html
[pipe_mode]: https://docs.rs/tokio/latest/tokio/net/windows/named_pipe/struct.ServerOptions.html#method.pipe_mode
[reject_remote_clients]: https://docs.rs/tokio/latest/tokio/net/windows/named_pipe/struct.ServerOptions.html#method.reject_remote_clients
