```toml
[advisory]
id = "RUSTSEC-2021-0049"
package = "through"
aliases = ["CVE-2021-29940", "GHSA-5hpj-m323-cphm"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-02-18"
url = "https://github.com/gretchenfrage/through/issues/1"
categories = ["memory-corruption"]
keywords = ["memory-safety", "double-free"]

[versions]
patched = []
```

# `through` and `through_and` causes a double free if the map function panics

`through` and `through_and` take a mutable reference as well as a mapping
function to change the provided reference. They do this by calling `ptr::read`
on the reference which duplicates ownership and then calling the mapping
function.

If the mapping function panics, both the original object and the one
duplicated by `ptr::read` get dropped, causing a double free.
