```toml
[advisory]
id = "RUSTSEC-2021-0112"
package = "tectonic_xdv"
date = "2021-02-17"
url = "https://github.com/tectonic-typesetting/tectonic/issues/752"
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["CVE-2021-45703", "GHSA-6692-8qqf-79jc", "GHSA-qwvx-c8j7-5g75"]
[versions]
patched = [">= 0.1.12"]
```

# `Read` on uninitialized buffer may cause UB ('tectonic_xdv' crate)

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` implementation.

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure) and also can return incorrect number of bytes written to the buffer. Reading from uninitialized memory produces undefined values that can quickly invoke undefined behavior.

The problem was fixed in commit `cdff034` by zero-initializing the buffer before passing it to a user-provided `Read` implementation.
