```toml
[advisory]
id = "RUSTSEC-2022-0088"
package = "tauri"
date = "2022-08-07"
url = "https://github.com/tauri-apps/tauri/issues/4882"
categories = ["privilege-escalation"]
aliases = ["CVE-2022-39215", "GHSA-28m8-9j7v-x499"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:N"

[versions]
patched = [">= 1.0.6"]
```

# `tauri`'s `readDir` endpoint allows possible enumeration outside of filesystem scope

It is possible for `readDir` to incorrectly enumerate files from a symlinked directory if called recursively when specifying an empty string for the dir parameter as outlined in [this](https://github.com/tauri-apps/tauri/issues/4882) issue.

This is corrected in [this](https://github.com/tauri-apps/tauri/pull/5123) PR by checking if a directory is a symlink before reading from it.
