```toml
[advisory]
id = "RUSTSEC-2019-0023"
package = "string-interner"
aliases = ["CVE-2019-16882", "GHSA-49fq-pw77-6qxj"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N"
date = "2019-08-24"
keywords = ["use after free"]
url = "https://github.com/Robbepop/string-interner/issues/9"

[versions]
patched = ["^0.6.4", ">= 0.7.1"]
```

# Cloned interners may read already dropped strings

Affected versions of this crate did not clone contained strings when an interner is cloned.
Interners have raw pointers to the contained strings, and they keep pointing the strings which the old interner owns, after the interner is cloned.
If a new cloned interner is alive and the old original interner is dead, the new interner has dangling pointers to the old interner's storage, which is already dropped.

This allows an attacker to read the already freed memory.
The dangling pointers are used by the interners to check a string is already interned.
An attacker can do brute force attack to get the data pointed by the dangling pointer.

The flaw was corrected by <https://github.com/Robbepop/string-interner/pull/10>.
This patch implements `Clone` manually to the interner type, so that the internal raw pointers always point the strings owned by the same interner.

PR #10 was also backported to the 0.6 release line in
<https://github.com/Robbepop/string-interner/pull/14> and was released in 0.6.4.
