```toml
[advisory]
id = "RUSTSEC-2019-0008"
package = "simd-json"
aliases = ["CVE-2019-15550", "GHSA-gwfj-pw2x-h6c2"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2019-06-24"
keywords = ["simd"]
url = "https://github.com/Licenser/simdjson-rs/pull/27"

[affected]
arch = ["x86", "x86_64"]

[versions]
patched = [">= 0.1.15"]
unaffected = ["<= 0.1.13"]
```

# Flaw in string parsing can lead to crashes due to invalid memory access.

The affected version of this crate did not guard against accessing memory
beyond the range of its input data. A pointer cast to read the data into
a 256-bit register could lead to a segmentation fault when the end plus
the 32 bytes (256 bit) read would overlap into the next page during string
parsing.

```
page   |  ...  page 1  ...  | ... page 2  ... |
data   | x[n * 32 byte]xx__ |                 |
access | ..][ 32 byte ]     |                 |
segflt |               [ 32 | byte ]          |
```

This allows an attacker to eventually crash a service.

The flaw was corrected by using a padding buffer for the last read from the
input. So that we are we never read over the boundary of the input data.
