```toml
[advisory]

id = "RUSTSEC-2023-0087"

package = "simd-json-derive"

date = "2023-10-14"


url = "https://github.com/simd-lite/simd-json-derive/issues/67"

informational = "unsound"

categories = []

# Freeform keywords which describe this vulnerability, similar to Cargo (optional)
keywords = ["panic", "undefined behavior"]

[versions]
patched = [">= 0.12.0"]
```

# `MaybeUninit` misuse in `simd-json-derive`

An invalid use of `MaybeUninit::uninit().assume_init()` in `simd-json-derive`'s derive macro can cause undefined behavior. The original code used `MaybeUninit` to avoid initialisation of the struct and then set the fields using `ptr::write`. The undefined behavior triggered by this misuse of `MaybeUninit` can lead to invlaid memory access and panics in binaries compiled in release mode (aka simd-json-derive prior to version 0.12 has UB and optimizes into some nonsense)

The `0.12.0` removes this section of code, avoiding the use of MaybeUninit alltogether.
