```toml
[advisory]
id = "RUSTSEC-2023-0038"
package = "sequoia-openpgp"
date = "2023-05-16"
url = "https://lists.sequoia-pgp.org/hyperkitty/list/announce@lists.sequoia-pgp.org/thread/SN2E3QRT4DMQ5JNEK6VIN6DJ5SH766DI/"
references = ["https://gitlab.com/sequoia-pgp/sequoia/-/tags/openpgp%2Fv1.16.0"]
categories = ["denial-of-service"]
# Attacker-controlled input can result in a panic due to an
# out-of-bounds array index.
keywords = ["panic"]
aliases = ["GHSA-25mx-8f3v-8wh7"]

[versions]
patched = [">= 1.1.1, < 1.2.0", ">= 1.8.1, < 1.9.0", ">= 1.16.0"]
```

# Out-of-bounds array access leads to panic

Affected versions of the crate have several bugs where
attacker-controlled input can result in the use of an out-of-bound
array index.  Rust detects the use of the out-of-bound index and
causes the application to panic.  An attacker may be able to use this
to cause a denial-of-service.  However, it is not possible for an
attacker to read from or write to the application's address space.

