```toml
[advisory]
id = "RUSTSEC-2023-0081"
package = "safemem"
date = "2023-02-14"
url = "https://github.com/abonander/safemem"
informational = "unmaintained"

[versions]
patched = []
```

# safemem is unmaintained

The latest crates.io release was in 2019. The repository has been archived by the author.

## Migration

- `safemem::copy_over(slice, src_idx, dest_idx, len);` can be replaced with `slice.copy_within(src_idx..src_idx+len, dest_idx);` as of `rust 1.37.0`.
- `safemem::write_bytes(slice, byte);` can be replaced with `slice.fill(byte);` as of `rust 1.50.0`
- `safemem::prepend(slice, vec);` can be replaced with

  ```rust
  let old_len = vec.len();
  vec.extend_from_slice(slice);
  vec.rotate_left(old_len);
  ```
  
  as of `rust 1.26.0`
