```toml
[advisory]
id = "RUSTSEC-2024-0400"
package = "ruzstd"
date = "2024-11-28"
url = "https://github.com/KillingSpark/zstd-rs/issues/75"
categories = ["memory-exposure"]
references = ["https://github.com/KillingSpark/zstd-rs/pull/76"]

[versions]
patched = [">= 0.7.3"]
unaffected = ["< 0.7.0"]
```

# `ruzstd` uninit and out-of-bounds memory reads

Affected versions of `ruzstd` miscalculate the length of the allocated
and init section of its internal `RingBuffer`, leading to uninitialized
or out-of-bounds reads in `copy_bytes_overshooting` of up to 15 bytes.

This may result in up to 15 bytes of memory contents being written
into the decoded data when decompressing a crafted archive.
This may occur multiple times per archive.
