```toml
[advisory]
id = "RUSTSEC-2022-0004"
package = "rustc-serialize"
date = "2022-01-01"
categories = ["denial-of-service"]
keywords = ["stack overflow"]
aliases = ["GHSA-2226-4v3c-cff8"]

[versions]
patched = []

[affected]
functions = { "rustc_serialize::json::Json::from_str" = ["*"] }
```

# Stack overflow in rustc_serialize when parsing deeply nested JSON

When parsing JSON using `json::Json::from_str`, there is no limit to the depth of the stack, therefore deeply nested objects can cause a stack overflow, which aborts the process.

Example code that triggers the vulnerability is

```rust
fn main() {
    let _ = rustc_serialize::json::Json::from_str(&"[0,[".repeat(10000));
}
```

[serde](https://crates.io/crates/serde) is recommended as a replacement to rustc_serialize.
