```toml
[advisory]
id = "RUSTSEC-2024-0007"
package = "rust-i18n-support"
date = "2024-01-19"
url = "https://github.com/longbridgeapp/rust-i18n/issues/71"
informational = "unsound"
categories = ["memory-exposure"]
references = [
    "https://github.com/longbridgeapp/rust-i18n/pull/72",
    "https://github.com/longbridgeapp/rust-i18n/releases/tag/v3.0.1",
]
aliases = ["GHSA-c8v3-jhv9-4ppc"]

[affected]
functions = { "rust_i18n_support::AtomicStr::as_str" = ["< 3.0.1, >= 3.0.0"] }

[versions]
patched = [">= 3.0.1"]
unaffected = ["< 3.0.0"]
```

# Use-after-free when setting the locale

Version 3.0.0 introduced an `AtomicStr` type, that is used to store the current locale.
It stores the locale as a raw pointer to an `Arc<String>`.
The locale can be read with `AtomicStr::as_str()`.
`AtomicStr::as_str()` does not increment the usage counter of the `Arc`.

If the locale is changed in one thread, another thread can have a stale -- possibly already freed --
reference to the stored string.
