```toml
[advisory]
id = "RUSTSEC-2023-0071"
package = "rsa"
date = "2023-11-22"
keywords = ["cryptography"]
categories = ["crypto-failure"]
url = "https://github.com/RustCrypto/RSA/issues/19#issuecomment-1822995643"
references = ["https://people.redhat.com/~hkario/marvin/"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N"
aliases = ["CVE-2023-49092", "GHSA-c38w-74pg-36hr", "GHSA-4grx-2x9w-596c"]

[versions]
patched = []
```

# Marvin Attack: potential key recovery through timing sidechannels

### Impact
Due to a non-constant-time implementation, information about the private key is leaked through timing information which is observable over the network. An attacker may be able to use that information to recover the key.

### Patches
No patch is yet available, however work is underway to migrate to a fully constant-time implementation.

### Workarounds
The only currently available workaround is to avoid using the `rsa` crate in settings where attackers are able to observe timing information, e.g. local use on a non-compromised computer is fine.

### References
This vulnerability was discovered as part of the "[Marvin Attack]", which revealed several implementations of RSA including OpenSSL had not properly mitigated timing sidechannel attacks.

[Marvin Attack]: https://people.redhat.com/~hkario/marvin/
