```toml
[advisory]
id = "RUSTSEC-2024-0409"
package = "pyo3"
date = "2024-12-04"
url = "https://github.com/PyO3/pyo3/issues/4757"
categories = ["memory-corruption"]
keywords = ["memory-corruption", "ffi", "corrupted-build"]

[versions]
patched = [">= 0.23.3"]
unaffected = ["< 0.23.0"]
```

# Build corruption when using `PYO3_CONFIG_FILE` environment variable

In PyO3 0.23.0 the `PYO3_CONFIG_FILE` environment variable used to configure builds regressed such that changing the environment variable would no longer trigger PyO3 to reconfigure and recompile. In combination with workflows using tools such as `maturin` to build for multiple versions in a single build, this leads to Python wheels being compiled against the wrong Python API version.

All users who distribute artefacts for multiple Python versions are encouraged to update and rebuild with PyO3 0.23.3. Affected wheels produced from PyO3 0.23.0 through 0.23.2 are highly unstable and will crash the Python interpreter in unpredictable ways.
