```toml
[advisory]
id = "RUSTSEC-2024-0378"
package = "pyo3"
date = "2024-10-12"
url = "https://github.com/PyO3/pyo3/pull/4590"
categories = ["memory-corruption"]
keywords = ["use-after-free"]

[affected]
functions = { "pyo3::types::PyWeakrefMethods::upgrade_borrowed_as" = ["< 0.22.4, >= 0.22.0"], "pyo3::types::PyWeakrefMethods::upgrade_borrowed_as_unchecked" = ["< 0.22.4, >= 0.22.0"], "pyo3::types::PyWeakrefMethods::upgrade_borrowed_as_exact" = ["< 0.22.4, >= 0.22.0"], "pyo3::types::PyWeakrefMethods::upgrade_borrowed" = ["< 0.22.4, >= 0.22.0"], "pyo3::types::PyWeakrefMethods::get_object_borrowed" = ["< 0.22.4, >= 0.22.0"] }

[versions]
patched = [">= 0.22.4"]
unaffected = ["< 0.22.0"]
```

# Risk of use-after-free in `borrowed` reads from Python weak references

The family of functions to read "borrowed" values from Python weak references
were fundamentally unsound, because the weak reference does itself not have
ownership of the value. At any point the last strong reference could
be cleared and the borrowed value would become dangling.

In PyO3 0.22.4 these functions have all been deprecated and patched to leak a
strong reference as a mitigation. PyO3 0.23 will remove these functions entirely.

