```toml
[advisory]
categories = ["denial-of-service", "memory-corruption"]
date = "2020-01-16"
id = "RUSTSEC-2020-0002"
package = "prost"
aliases = ["CVE-2020-35858", "GHSA-gv73-9mwv-fwgq"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
keywords = ["stack overflow"]
url = "https://github.com/danburkert/prost/issues/267"

[versions]
patched = [">= 0.6.1"]
```

# Parsing a specially crafted message can result in a stack overflow

Affected versions of this crate contained a bug in which decoding untrusted
input could overflow the stack.

On architectures with stack probes (like x86), this can be used for denial of
service attacks, while on architectures without stack probes (like ARM)
overflowing the stack is unsound and can result in potential memory corruption
(or even RCE).
 
The flaw was quickly corrected by @danburkert and released in version 0.6.1.
