```toml
[advisory]
id = "RUSTSEC-2021-0073"
package = "prost-types"
date = "2021-07-08"
url = "https://github.com/tokio-rs/prost/issues/438"
categories = ["denial-of-service"]
keywords = ["denial-of-service"]
aliases = ["CVE-2021-38192", "GHSA-x4qm-mcjq-v2gf"]

[versions]
patched = [">= 0.8.0"]

[affected]
functions = { "prost_types::Timestamp::Into<SystemTime>" = ["<= 0.7.0"] }
```

# Conversion from `prost_types::Timestamp` to `SystemTime` can cause an overflow and panic 

Affected versions of this crate contained a bug in which untrusted input could cause an overflow and panic when converting a `Timestamp` to `SystemTime`.

It is recommended to upgrade to `prost-types` v0.8 and switch the usage of `From<Timestamp> for SystemTime` to `TryFrom<Timestamp> for SystemTime`.

See [#438] for more information.

[#438]: https://github.com/tokio-rs/prost/issues/438 
