```toml
[advisory]
id = "RUSTSEC-2021-0017"
package = "postscript"
aliases = ["CVE-2021-26953", "GHSA-fhvc-gp6c-h2wx"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N"
date = "2021-01-30"
url = "https://github.com/bodoni/postscript/issues/1"
categories = ["memory-exposure"]

[versions]
patched = [">= 0.14.0"]
```

# `Read` on uninitialized buffer may cause UB (`impl Walue for Vec<u8>`)

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` implementation.

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure) and also can return incorrect number of bytes written to the buffer.
Reading from uninitialized memory produces undefined values that can quickly invoke undefined behavior.

This flaw was fixed in commit 8026286 by zero-initializing the buffer before handing to a user-provided `Read`.
